/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.https;

import com.phaos.SSL.SSLCertificate;
import com.phaos.SSL.SSLParams;
import com.phaos.SSL.SSLSocket;
import com.phaos.SSL.SSLTunneledSocket;
import com.phaos.SSL.SessionParams;
import com.phaos.https.HttpsRequest;
import com.phaos.utils.HttpUtils;
import com.phaos.utils.UnsyncByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;

public class HttpsURLConnection
extends HttpURLConnection {
    private static final int DEFAULT_PORT = 443;
    private static final String EOL = "\r\n";
    private static Hashtable httpReqs;
    private int httpVersionMinor = 1;
    private int httpProxyVersionMinor = 1;
    private SSLParams params;
    private int soTimeout;
    private boolean soTimeoutSet;
    private boolean tcpNoDelay;
    private boolean tcpNoDelaySet;
    private String proxyHost;
    private int proxyPort = -1;
    private Properties proxyReqProperties = new Properties();
    private HttpsRequest httpReq;
    private Properties reqProperties = new Properties();
    private String respStatusLine;
    private String respVersion;
    private Properties respHeaders;
    private Vector respHeaderKeys;
    private boolean doPipelining = false;
    private boolean connAlive = true;
    private int contTimeout = 3000;
    private boolean sentRequest;
    private boolean readHeaders;
    private boolean readInput;
    private OutputStream output;
    private InputStream input;
    private int msgLen = -1;
    private static final Object lockHashtable;

    static {
        lockHashtable = new Object();
    }

    public HttpsURLConnection(String string) throws MalformedURLException {
        this(HttpsURLConnection.fromURLString(string), new SSLParams(), false);
    }

    protected HttpsURLConnection(URL uRL) {
        this(uRL, new SSLParams(), false);
    }

    protected HttpsURLConnection(URL uRL, SSLParams sSLParams) {
        this(uRL, sSLParams, false);
    }

    protected HttpsURLConnection(URL uRL, SSLParams sSLParams, String string, int n) {
        this(uRL, sSLParams, string, n, false);
    }

    protected HttpsURLConnection(URL uRL, SSLParams sSLParams, String string, int n, boolean bl) {
        this(uRL, sSLParams, bl);
        this.proxyHost = string;
        this.proxyPort = n;
    }

    protected HttpsURLConnection(URL uRL, SSLParams sSLParams, boolean bl) {
        super(uRL);
        this.params = sSLParams;
        this.doPipelining = bl;
        if (httpReqs == null) {
            httpReqs = new Hashtable();
        }
    }

    protected HttpsURLConnection(URL uRL, String string, int n) {
        this(uRL, new SSLParams(), string, n, false);
    }

    public void addProxyRequestProperty(String string, String string2) {
        if (this.sentRequest) {
            throw new IllegalStateException("Already connected");
        }
        if (string2 == null) {
            return;
        }
        String string3 = this.proxyReqProperties.getProperty(string);
        if (string3 != null) {
            string2 = String.valueOf(string3) + ", " + string2;
        }
        ((Hashtable)this.proxyReqProperties).put(HttpUtils.toTitleCase((String)string), string2);
    }

    public void addRequestProperty(String string, String string2) {
        if (this.sentRequest) {
            throw new IllegalStateException("Already connected");
        }
        String string3 = this.reqProperties.getProperty(string);
        if (string3 != null) {
            string2 = String.valueOf(string3) + ", " + string2;
        }
        ((Hashtable)this.reqProperties).put(HttpUtils.toTitleCase((String)string), string2);
    }

    private void clearRespHeaders() {
        this.respStatusLine = null;
        this.respVersion = null;
        this.responseCode = -1;
        this.responseMessage = null;
        if (this.respHeaders != null) {
            ((Hashtable)this.respHeaders).clear();
        }
        if (this.respHeaderKeys != null) {
            this.respHeaderKeys.removeAllElements();
        }
        this.readHeaders = false;
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        if (this.httpReq == null) {
            CharSequence charSequence;
            String string;
            String string2 = this.url.getHost().toLowerCase();
            int n = this.url.getPort();
            if (n == -1) {
                n = 443;
            }
            String string3 = String.valueOf(string2) + ":" + n;
            if (this.proxyHost == null) {
                string = System.getProperty("http.proxyHost");
                charSequence = System.getProperty("http.proxyPort", "-1");
                int n2 = -1;
                try {
                    n2 = Integer.parseInt((String)charSequence);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ProtocolException("Invalid proxy port " + (String)charSequence);
                }
                if (string != null) {
                    this.setProxy(string, n2);
                }
            }
            if (this.proxyHost != null) {
                charSequence = new StringBuffer();
                if (!((Hashtable)this.proxyReqProperties).isEmpty()) {
                    Enumeration enumeration = ((Hashtable)this.proxyReqProperties).keys();
                    while (enumeration.hasMoreElements()) {
                        String string4 = (String)enumeration.nextElement();
                        ((StringBuffer)charSequence).append(string4);
                        ((StringBuffer)charSequence).append(": ");
                        ((StringBuffer)charSequence).append(this.getProxyRequestProperty(string4));
                        ((StringBuffer)charSequence).append(EOL);
                    }
                }
                string = ((StringBuffer)charSequence).toString();
            } else {
                string = "";
            }
            this.httpReq = this.getHttpsRequestFromPool(string3, string2, n, this.params, this.httpProxyVersionMinor, this.proxyHost, this.proxyPort, string);
        }
        this.connected = true;
    }

    private void decodeChunkedBody() throws IOException {
        int n;
        Object object;
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        int n2 = 0;
        try {
            block11: {
                String string;
                object = null;
                do {
                    if ((n = (string = HttpUtils.readCanonicalLine((InputStream)this.input)).indexOf(59)) != -1) {
                        string = string.substring(0, n);
                    }
                    int n3 = 0;
                    try {
                        n3 = Integer.parseInt(string.trim(), 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ProtocolException("Invalid chunk size " + string.trim());
                    }
                    if (n3 == 0) break block11;
                    if (object == null || (object).length < n3) {
                        object = new byte[n3];
                    }
                    int n4 = 0;
                    int n5 = 0;
                    while (n4 < n3) {
                        n5 = this.input.read((byte[])object, n4, n3 - n4);
                        if (n5 == -1) break;
                        n4 += n5;
                    }
                    unsyncByteArrayOutputStream.write((byte[])object, 0, n4);
                    n2 += n4;
                    if (n4 >= n3) continue;
                    throw new EOFException("Unexpected end of chunk data: expected " + n3 + " bytes, received " + n4 + " bytes");
                } while ((string = HttpUtils.readCanonicalLine((InputStream)this.input)).length() == 0);
                throw new ProtocolException("Missing CRLF after chunked data");
            }
            HttpUtils.parseHeaderStream((InputStream)this.input, (Hashtable)this.respHeaders, (Vector)this.respHeaderKeys);
        }
        catch (IOException iOException) {
            this.disconnect();
            throw iOException;
        }
        object = (String)((Hashtable)this.respHeaders).get("Transfer-Encoding");
        int n6 = this.respHeaderKeys.indexOf("Transfer-Encoding");
        n = ((String)object).lastIndexOf(44);
        if (n == -1) {
            this.respHeaderKeys.removeElementAt(n6);
            ((Hashtable)this.respHeaders).remove("Transfer-Encoding");
        } else {
            ((Hashtable)this.respHeaders).put("Transfer-Encoding", ((String)object).substring(0, n));
        }
        n6 = this.respHeaderKeys.indexOf("Content-Length");
        if (n6 == -1) {
            this.respHeaderKeys.addElement("Content-Length");
        }
        ((Hashtable)this.respHeaders).put("Content-Length", String.valueOf(n2));
        this.msgLen = n2;
        this.input = n2 > 0 ? new ByteArrayInputStream(unsyncByteArrayOutputStream.toByteArray()) : new EmptyInputStream();
    }

    public void disconnect() {
        if (this.httpReq != null) {
            httpReqs.remove(String.valueOf(this.httpReq.getHost()) + ":" + this.httpReq.getPort());
            this.httpReq.close();
            this.httpReq = null;
        }
        this.readInput = false;
        this.readHeaders = false;
        this.sentRequest = false;
        this.connAlive = false;
        this.connected = false;
    }

    private static URL fromURLString(String string) throws MalformedURLException {
        if (!string.toLowerCase().startsWith("https://")) {
            throw new MalformedURLException("Protocol scheme must be 'https'");
        }
        String string2 = "";
        String string3 = "";
        String string4 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(8), "/");
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.endsWith(":")) {
                throw new MalformedURLException("bad port specifier: " + string);
            }
            stringTokenizer = new StringTokenizer(string2, ":");
            if (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
            }
            if (stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken();
            }
        }
        return new URL("http://" + string3 + ":" + (string4 != null ? string4 : "443") + string.substring(8 + string2.length()));
    }

    public int getContinueTimeout() {
        return this.contTimeout;
    }

    public String getHeaderField(int n) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
        if (n == 0) {
            return this.respStatusLine;
        }
        if (n > 0 && n <= this.respHeaderKeys.size()) {
            return this.respHeaders.getProperty((String)this.respHeaderKeys.elementAt(n - 1));
        }
        return null;
    }

    public String getHeaderField(String string) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
        return this.respHeaders.getProperty(HttpUtils.toTitleCase((String)string));
    }

    public String getHeaderFieldKey(int n) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
        if (n > 0 && n <= this.respHeaderKeys.size()) {
            return (String)this.respHeaderKeys.elementAt(n - 1);
        }
        return null;
    }

    public int getHttpProxyVersionMinor() {
        return this.httpProxyVersionMinor;
    }

    public int getHttpVersionMinor() {
        return this.httpVersionMinor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private HttpsRequest getHttpsRequestFromPool(String string, String string2, int n, SSLParams sSLParams, int n2, String string3, int n3, String string4) throws IOException {
        Vector<HttpsRequest> vector;
        Object object = lockHashtable;
        synchronized (object) {
            Object object2;
            vector = (Vector<HttpsRequest>)httpReqs.get(string);
            if (vector == null) {
                vector = new Vector<HttpsRequest>();
                httpReqs.put(string, vector);
            }
            boolean bl = false;
            int n4 = 0;
            int n5 = vector.size();
            while (n4 < n5) {
                String string5;
                HttpsRequest httpsRequest = (HttpsRequest)vector.elementAt(n4);
                if (!(bl || this.doPipelining || httpsRequest.isDoingPipeline())) {
                    string5 = httpsRequest.getProxyHost();
                    object2 = httpsRequest.getSSLParams();
                    if (sSLParams == object2 && (string3 == string5 || string3 != null && string3.equalsIgnoreCase(string5) && n3 == httpsRequest.getProxyPort() && string4.equalsIgnoreCase(httpsRequest.getProxyReqHeaders()))) {
                        vector.removeElement(httpsRequest);
                        bl = true;
                    }
                }
                if (!bl && this.doPipelining && !this.method.equals("POST") && httpsRequest.isDoingPipeline()) {
                    string5 = httpsRequest.getProxyHost();
                    object2 = httpsRequest.getSSLParams();
                    if (sSLParams == object2 && (string3 == string5 || string3 != null && string3.equalsIgnoreCase(string5) && n3 == httpsRequest.getProxyPort() && string4.equalsIgnoreCase(httpsRequest.getProxyReqHeaders()))) {
                        bl = true;
                    }
                }
                if (bl) {
                    if (this.soTimeoutSet) {
                        httpsRequest.setSoTimeout(this.soTimeout);
                    }
                    if (!this.tcpNoDelaySet) return httpsRequest;
                    httpsRequest.setTcpNoDelay(this.tcpNoDelay);
                    return httpsRequest;
                }
                ++n4;
            }
            if (this.doPipelining && !this.method.equals("POST")) {
                bl = false;
                int n6 = 0;
                int n7 = vector.size();
                while (n6 < n7) {
                    object2 = (HttpsRequest)vector.elementAt(n6);
                    String string6 = ((HttpsRequest)object2).getProxyHost();
                    SSLParams sSLParams2 = ((HttpsRequest)object2).getSSLParams();
                    if (sSLParams == sSLParams2 && (string3 == string6 || string3 != null && string3.equalsIgnoreCase(string6) && n3 == ((HttpsRequest)object2).getProxyPort() && string4.equalsIgnoreCase(((HttpsRequest)object2).getProxyReqHeaders()))) {
                        ((HttpsRequest)object2).setDoingPipeline(true);
                        bl = true;
                    }
                    if (bl) {
                        if (this.soTimeoutSet) {
                            ((HttpsRequest)object2).setSoTimeout(this.soTimeout);
                        }
                        if (!this.tcpNoDelaySet) return object2;
                        ((HttpsRequest)object2).setTcpNoDelay(this.tcpNoDelay);
                        return object2;
                    }
                    ++n6;
                }
            }
        }
        HttpsRequest httpsRequest = new HttpsRequest(string2, n, sSLParams, n2, string3, n3, string4, false);
        if (this.soTimeoutSet) {
            httpsRequest.setSoTimeout(this.soTimeout);
        }
        if (this.tcpNoDelaySet) {
            httpsRequest.setTcpNoDelay(this.tcpNoDelay);
        }
        httpsRequest.performHandshake();
        if (!this.doPipelining) return httpsRequest;
        httpsRequest.setDoingPipeline(true);
        vector.addElement(httpsRequest);
        return httpsRequest;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.doInput) {
            throw new ProtocolException("Input disabled, call setDoInput(true)");
        }
        if (this.readInput) {
            return this.input;
        }
        try {
            this.sendRequest();
        }
        catch (IOException iOException) {
            if ((this.httpReq == null || this.httpReq != null && this.httpReq.isConnAlive()) && this.respStatusLine == null && !this.method.equals("POST")) {
                this.disconnect();
                this.doPipelining = false;
                try {
                    this.sendRequest();
                }
                catch (IOException iOException2) {
                    this.disconnect();
                    throw new IOException("Exception retrying request: " + iOException2.toString());
                }
            }
            this.disconnect();
            throw iOException;
        }
        try {
            Object object = this.httpReq.getReceivingLock();
            synchronized (object) {
                try {
                    int n = this.httpReq.indexOfRequest(this);
                    if (n >= 0) {
                        this.httpReq.removePLRequest(n);
                    } else {
                        n = this.httpReq.getPLRequestCount();
                    }
                    if (n > 0) {
                        this.httpReq.requestGetInputStream(n - 1);
                    }
                    this.input = this.httpReq.getInputStream();
                    this.readRespHeaders(this.input);
                    if (this.responseCode == 100) {
                        this.clearRespHeaders();
                        this.readRespHeaders(this.input);
                    }
                    if (this.doPipelining) {
                        this.readInputStream();
                    }
                }
                catch (IOException iOException) {
                    this.disconnect();
                    throw iOException;
                }
            }
        }
        catch (IOException iOException) {
            if ((this.httpReq == null || this.httpReq != null && this.httpReq.isConnAlive()) && this.respStatusLine == null && !this.method.equals("POST")) {
                this.disconnect();
                this.doPipelining = false;
                try {
                    this.sendRequest();
                    this.input = this.httpReq.getInputStream();
                    this.readRespHeaders(this.input);
                    if (this.responseCode == 100) {
                        this.clearRespHeaders();
                        this.readRespHeaders(this.input);
                    }
                }
                catch (IOException iOException3) {
                    this.disconnect();
                    throw new IOException("Exception retrying request: " + iOException3.toString());
                }
            }
            this.disconnect();
            throw iOException;
        }
        if (!this.doPipelining && HttpURLConnection.getFollowRedirects() && (this.method.equals("GET") || this.method.equals("HEAD"))) {
            int n = 0;
            while (n < 4) {
                int n2;
                String string = this.respHeaders.getProperty("Location");
                if (this.responseCode / 100 != 3 || this.responseCode == 304 || string == null) break;
                URL uRL = null;
                try {
                    uRL = HttpsURLConnection.fromURLString(string);
                }
                catch (MalformedURLException malformedURLException) {
                    break;
                }
                this.readInputStream();
                int n3 = uRL.getPort();
                if (n3 == -1) {
                    n3 = 443;
                }
                if ((n2 = this.url.getPort()) == -1) {
                    n2 = 443;
                }
                if (!uRL.getHost().equalsIgnoreCase(this.url.getHost()) || n3 != n2 || this.responseCode == 305 || !this.connAlive) {
                    this.disconnect();
                } else {
                    this.sentRequest = false;
                }
                if (this.responseCode == 305) {
                    this.setProxy(uRL.getHost(), uRL.getPort());
                } else {
                    this.url = uRL;
                    if (!this.connected) {
                        this.setRequestProperty("Host", null);
                    }
                }
                try {
                    this.sendRequest();
                    this.input = this.httpReq.getInputStream();
                    this.readRespHeaders(this.input);
                    if (this.responseCode == 100) {
                        this.clearRespHeaders();
                        this.readRespHeaders(this.input);
                    }
                }
                catch (IOException iOException) {
                    this.disconnect();
                    throw new IOException("Exception redirecting to " + string + ": " + iOException.toString());
                }
                ++n;
            }
        }
        if (!this.doPipelining) {
            this.readInputStream();
        }
        this.readInput = true;
        return this.input;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.sentRequest) {
            throw new ProtocolException("Request already sent");
        }
        if (this.method.equals("GET")) {
            this.setRequestMethod("POST");
        }
        if (!this.method.equals("POST") && !this.method.equals("PUT")) {
            throw new ProtocolException("Method " + this.method + " does not support output.");
        }
        if (!this.doOutput) {
            throw new ProtocolException("Output disabled, call setDoOutput(true)");
        }
        if (this.output == null) {
            this.output = new UnsyncByteArrayOutputStream();
        }
        return this.output;
    }

    public boolean getPipelineRequests() {
        return this.doPipelining;
    }

    public String getProxyHeaderField(int n) {
        return this.usingProxy() ? ((SSLTunneledSocket)this.httpReq.getSocket()).getProxyHeaderField(n) : null;
    }

    public String getProxyHeaderField(String string) {
        return this.usingProxy() ? ((SSLTunneledSocket)this.httpReq.getSocket()).getProxyHeaderField(string) : null;
    }

    public String getProxyHeaderFieldKey(int n) {
        return this.usingProxy() ? ((SSLTunneledSocket)this.httpReq.getSocket()).getProxyHeaderFieldKey(n) : null;
    }

    public String getProxyRequestProperty(String string) {
        if (this.proxyReqProperties != null) {
            return this.proxyReqProperties.getProperty(HttpUtils.toTitleCase((String)string));
        }
        return null;
    }

    public int getProxyResponseCode() {
        return this.usingProxy() ? ((SSLTunneledSocket)this.httpReq.getSocket()).getProxyResponseCode() : -1;
    }

    public String getProxyResponseMessage() {
        return this.usingProxy() ? ((SSLTunneledSocket)this.httpReq.getSocket()).getProxyResponseMessage() : null;
    }

    public String getRequestProperty(String string) {
        return this.reqProperties.getProperty(HttpUtils.toTitleCase((String)string));
    }

    public String getResponseVersion() throws IOException {
        this.getInputStream();
        return this.respVersion;
    }

    public SSLParams getSSLParams() {
        return this.params;
    }

    public SSLCertificate getServerCert() {
        SSLSocket sSLSocket;
        if (this.connected && this.httpReq != null && (sSLSocket = this.httpReq.getSocket()) != null) {
            return sSLSocket.getServerCert();
        }
        return null;
    }

    public SessionParams getSessionParams() {
        SSLSocket sSLSocket;
        if (this.connected && this.httpReq != null && (sSLSocket = this.httpReq.getSocket()) != null) {
            return sSLSocket.getSessionParams();
        }
        return null;
    }

    public int getSoTimeout() throws IOException {
        int n;
        if (this.connected && this.httpReq != null && (n = this.httpReq.getSoTimeout()) != -1) {
            this.soTimeout = n;
        }
        return this.soTimeout;
    }

    public boolean getTcpNoDelay() throws IOException {
        if (this.connected && this.httpReq != null) {
            this.tcpNoDelay = this.httpReq.getTcpNoDelay();
        }
        return this.tcpNoDelay;
    }

    public boolean isConnAlive() {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            this.connAlive = false;
        }
        return this.connAlive;
    }

    private String makeRequestHeader() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.method);
        stringBuffer.append(' ');
        String string = this.url.getFile();
        if (string != null) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append('/');
        }
        stringBuffer.append(' ');
        stringBuffer.append("HTTP/1.");
        stringBuffer.append(this.httpVersionMinor);
        stringBuffer.append(EOL);
        Enumeration enumeration = ((Hashtable)this.reqProperties).keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            stringBuffer.append(string2);
            stringBuffer.append(": ");
            stringBuffer.append(this.getRequestProperty(string2));
            stringBuffer.append(EOL);
        }
        stringBuffer.append(EOL);
        return stringBuffer.toString();
    }

    private void manageConnection() throws IOException {
        String string = this.getRequestProperty("Connection");
        if (string != null) {
            string = string.toLowerCase();
        }
        boolean bl = this.connAlive = this.httpVersionMinor == 0 && string != null && string.indexOf("keep-alive") != -1 || this.httpVersionMinor == 1 && (string == null || string.indexOf("close") == -1);
        if (this.connAlive) {
            string = (String)((Hashtable)this.respHeaders).get("Connection");
            if (string != null) {
                string = string.toLowerCase();
            }
            boolean bl2 = this.connAlive = this.respVersion.equalsIgnoreCase("HTTP/1.0") && string != null && string.indexOf("keep-alive") != -1 || this.respVersion.equalsIgnoreCase("HTTP/1.1") && (string == null || string.indexOf("close") == -1);
            if (this.connAlive && this.msgLen == -1) {
                this.connAlive = false;
            }
        }
        this.httpReq.setConnAlive(this.connAlive);
        if (!this.connAlive) {
            Vector vector = (Vector)httpReqs.get(String.valueOf(this.httpReq.getHost()) + ":" + this.httpReq.getPort());
            if (vector != null) {
                vector.removeElement(this.httpReq);
            }
        } else if (!this.httpReq.isDoingPipeline()) {
            String string2 = String.valueOf(this.httpReq.getHost()) + ":" + this.httpReq.getPort();
            Vector<HttpsRequest> vector = (Vector<HttpsRequest>)httpReqs.get(string2);
            if (vector == null) {
                vector = new Vector<HttpsRequest>();
                httpReqs.put(string2, vector);
            }
            vector.addElement(this.httpReq);
        }
    }

    private void readInputStream() throws IOException {
        String string = this.respHeaders.getProperty("Transfer-Encoding");
        String string2 = this.respHeaders.getProperty("Content-Length");
        int n = -1;
        if (string2 != null) {
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ProtocolException("Invalid Content-Length " + string2);
            }
        }
        if (this.method.equals("HEAD") || this.responseCode < 200 || this.responseCode == 204 || this.responseCode == 205 || this.responseCode == 304) {
            this.msgLen = 0;
            this.input = new EmptyInputStream();
        } else if (string != null && string.trim().toLowerCase().endsWith("chunked")) {
            this.decodeChunkedBody();
        } else if (n != -1) {
            this.msgLen = n;
            if (this.msgLen > 0) {
                byte[] byArray = new byte[this.msgLen];
                int n2 = 0;
                int n3 = 0;
                try {
                    while (n2 < this.msgLen) {
                        n3 = this.input.read(byArray, n2, this.msgLen - n2);
                        if (n3 == -1) break;
                        n2 += n3;
                    }
                    this.input = new ByteArrayInputStream(byArray, 0, n2);
                }
                catch (IOException iOException) {
                    this.disconnect();
                    throw iOException;
                }
            } else {
                this.input = new EmptyInputStream();
            }
        }
        this.manageConnection();
    }

    private void readRespHeaders(InputStream inputStream) throws IOException {
        if (this.readHeaders) {
            return;
        }
        if (this.respHeaders == null) {
            this.respHeaders = new Properties();
        }
        if (this.respHeaderKeys == null) {
            this.respHeaderKeys = new Vector();
        }
        this.clearRespHeaders();
        String string = null;
        while ((string = HttpUtils.readCanonicalLine((InputStream)inputStream)) != null) {
            if (string.length() == 0) continue;
            this.respStatusLine = string;
            break;
        }
        if (this.respStatusLine == null) {
            this.disconnect();
            throw new IOException("Missing HTTP response line, connection terminated");
        }
        if (!this.respStatusLine.startsWith("HTTP/") || this.respStatusLine.indexOf(32) == -1) {
            this.disconnect();
            throw new ProtocolException("Invalid HTTP response status line '" + this.respStatusLine + "'");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.respStatusLine);
        if (stringTokenizer.hasMoreTokens()) {
            this.respVersion = stringTokenizer.nextToken();
            if (!this.respVersion.startsWith("HTTP/1.")) {
                throw new ProtocolException("Invalid HTTP version '" + this.respVersion + "'");
            }
        } else {
            throw new ProtocolException("Invalid HTTP response status line '" + this.respStatusLine + "'");
        }
        if (!stringTokenizer.hasMoreTokens()) {
            throw new ProtocolException("Invalid HTTP response status line '" + this.respStatusLine + "'");
        }
        String string2 = stringTokenizer.nextToken();
        if (string2.length() != 3) {
            throw new ProtocolException("Invalid HTTP response code '" + string2 + "'");
        }
        try {
            this.responseCode = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProtocolException("Invalid HTTP response code '" + string2 + "'");
        }
        if (stringTokenizer.hasMoreTokens()) {
            this.responseMessage = stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens()) {
                this.responseMessage = String.valueOf(this.responseMessage) + " " + stringTokenizer.nextToken();
            }
        }
        try {
            HttpUtils.parseHeaderStream((InputStream)inputStream, (Hashtable)this.respHeaders, (Vector)this.respHeaderKeys);
        }
        catch (IOException iOException) {
            this.disconnect();
            throw iOException;
        }
        this.readHeaders = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendRequest() throws IOException {
        Object object;
        if (this.sentRequest) {
            return;
        }
        this.connect();
        if (this.getRequestProperty("Host") == null) {
            object = this.url.getHost();
            int n = this.url.getPort();
            if (n != -1 && n != 443) {
                object = String.valueOf(object) + ":" + n;
            }
            this.setHeaderIfNotSet("Host", (String)object);
        }
        if (this.ifModifiedSince > 0L) {
            object = DateFormat.getInstance();
            ((DateFormat)object).setTimeZone(TimeZone.getTimeZone("GMT"));
            this.setHeaderIfNotSet("If-Modified-Since", ((DateFormat)object).format(new Date(this.ifModifiedSince)));
        }
        if (!this.useCaches) {
            this.setHeaderIfNotSet("Pragma", "no-cache");
        }
        object = null;
        if (this.output != null) {
            object = ((UnsyncByteArrayOutputStream)this.output).toByteArray();
            if (this.method.equals("POST")) {
                this.setHeaderIfNotSet("Content-Type", "application/x-www-form-urlencoded");
            }
            if (this.method.equals("POST") || this.method.equals("PUT")) {
                this.setRequestProperty("Content-Length", String.valueOf(((Object)object).length));
            }
        }
        String string = this.makeRequestHeader();
        Object object2 = this.httpReq.getSendingLock();
        synchronized (object2) {
            String string2;
            this.httpReq.setHeaders(string);
            if (this.output != null) {
                this.httpReq.setContent((byte[])object);
            }
            boolean bl = false;
            if (!this.doPipelining && (string2 = this.getRequestProperty("Expect")) != null && string2.toLowerCase().indexOf("100-continue") != -1) {
                bl = true;
            }
            this.httpReq.sendHeaders(bl);
            if (bl) {
                int n;
                block19: {
                    n = this.getSoTimeout();
                    this.setSoTimeout(this.contTimeout);
                    try {
                        try {
                            this.readRespHeaders(this.httpReq.getInputStream());
                            if (this.responseCode == 100) {
                                this.clearRespHeaders();
                                break block19;
                            }
                            this.sentRequest = true;
                            Object var8_8 = null;
                        }
                        catch (InterruptedIOException interruptedIOException) {
                            break block19;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        this.setSoTimeout(n);
                        throw throwable;
                    }
                    this.setSoTimeout(n);
                    return;
                }
                Object var8_9 = null;
                this.setSoTimeout(n);
            }
            this.httpReq.sendBody();
            this.sentRequest = true;
            if (!this.doPipelining) return;
            if (this.method.equals("POST")) return;
            this.httpReq.addPLRequest(this);
            return;
        }
    }

    public void setContinueTimeout(int n) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        this.contTimeout = n;
    }

    private void setHeaderIfNotSet(String string, String string2) {
        if (this.getRequestProperty(string) == null) {
            this.setRequestProperty(string, string2);
        }
    }

    public void setHttpProxyVersionMinor(int n) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Unsupported HTTP 1.x minor version number, must be 0 or 1");
        }
        this.httpProxyVersionMinor = n;
    }

    public void setHttpVersionMinor(int n) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Unsupported HTTP 1.x minor version number, must be 0 or 1");
        }
        this.httpVersionMinor = n;
    }

    public void setPipelineRequests(boolean bl) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        this.doPipelining = bl;
    }

    public void setProxy(String string, int n) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        this.proxyHost = string;
        this.proxyPort = this.proxyHost != null ? n : -1;
    }

    public void setProxyRequestProperty(String string, String string2) {
        if (this.sentRequest) {
            throw new IllegalStateException("Already connected");
        }
        if (string2 == null) {
            ((Hashtable)this.proxyReqProperties).remove(string);
        } else {
            ((Hashtable)this.proxyReqProperties).put(HttpUtils.toTitleCase((String)string), string2);
        }
    }

    public void setRequestProperty(String string, String string2) {
        if (this.sentRequest) {
            throw new IllegalStateException("Already connected");
        }
        if (string2 == null) {
            ((Hashtable)this.reqProperties).remove(string);
        } else {
            ((Hashtable)this.reqProperties).put(HttpUtils.toTitleCase((String)string), string2);
        }
    }

    public void setSSLParams(SSLParams sSLParams) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        this.params = sSLParams;
    }

    public void setSoTimeout(int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal timeout value " + n);
        }
        this.soTimeout = n;
        this.soTimeoutSet = true;
        if (this.connected && this.httpReq != null) {
            this.httpReq.setSoTimeout(n);
        }
    }

    public void setTcpNoDelay(boolean bl) throws IOException {
        this.tcpNoDelay = bl;
        this.tcpNoDelaySet = true;
        if (this.connected && this.httpReq != null) {
            this.httpReq.setTcpNoDelay(bl);
        }
    }

    public boolean usingProxy() {
        if (this.httpReq != null) {
            return this.httpReq.usingProxy();
        }
        return false;
    }

    private static class EmptyInputStream
    extends InputStream {
        EmptyInputStream() {
        }

        public int available() {
            return 0;
        }

        public int read() {
            return -1;
        }
    }
}

