/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.jhelp;

import com.novell.application.jhelp.htmlBullets;
import com.novell.application.jhelp.htmlFormatDefaults;
import com.novell.application.jhelp.htmlTagConstants;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.util.Stack;
import java.util.Vector;

class htmlFormatControl
implements htmlFormatDefaults,
htmlTagConstants {
    public Vector links = new Vector();
    public Vector bookmarks = new Vector();
    public int X;
    public int Y;
    public int maxY;
    public int alignment = 4;
    public boolean lineBreak = false;
    public boolean newLine = false;
    public int indent;
    public int rightIndent;
    public boolean preFormatted = false;
    public boolean popFont = false;
    public boolean popColor = false;
    public boolean popFace = false;
    public boolean doBullet = false;
    public int inList;
    public Color fgColor = htmlFormatDefaults.DEFAULTCOLOR;
    public Color bgColor = htmlFormatDefaults.DEFAULTBACKGROUND;
    public Color linkColor = htmlFormatDefaults.DEFAULTLINK;
    public int fontSize = 14;
    public int fontAttribute = 0;
    public String fontFace = "SERIF";
    public Stack fontSizeStack = new Stack();
    public Stack fontAttributeStack = new Stack();
    public Stack fontFaceStack = new Stack();
    public Stack fontColorStack = new Stack();
    public Stack listBullets = new Stack();
    public Stack defListStack = new Stack();
    public Stack bulletType = new Stack();
    public Stack roundBulletCount = new Stack();
    public Stack numberBulletCount = new Stack();
    public Stack anchorStack = new Stack();
    public Stack bookmarkStack = new Stack();
    public boolean hyperLink = false;
    public String hyperLinkString;
    public String urlBase = "";
    public Font currentFont;
    public FontMetrics fm;
    public int fmHeight;
    public int fmMaxAscent;
    public int fmMaxDescent;
    private String letters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public Stack divAlign = new Stack();
    public Stack paraAlign = new Stack();
    public Stack headAlign = new Stack();
    public String defaultFontFace = "SERIF";
    public int defaultFontSize = 14;
    public int defaultFontStyle = 0;
    public Image[] bullets;
    public Container instance;
    public boolean underline = true;
    public boolean strikethrough = false;

    public htmlFormatControl(Container container) {
        this.instance = container;
        if (container != null) {
            this.bullets = htmlBullets.getImages(container);
        }
    }

    public int getBulletType() {
        if (!this.bulletType.empty()) {
            return (Integer)this.bulletType.peek();
        }
        return -1;
    }

    public String getNumberBullet() {
        String string = "";
        try {
            try {
                int n = this.numberBulletCount.size();
                int n2 = (Integer)this.numberBulletCount.pop();
                this.numberBulletCount.push(new Integer(n2 + 1));
                while (n > 3) {
                    n -= 3;
                }
                switch (n) {
                    case 1: {
                        string = String.valueOf(Integer.toString(n2)) + ".";
                        break;
                    }
                    case 2: {
                        string = String.valueOf(this.letters.substring(n2 - 1, n2)) + ".";
                        break;
                    }
                    case 3: {
                        string = String.valueOf(this.letters.substring(n2 - 1, n2).toLowerCase()) + ".";
                        break;
                    }
                    default: {
                        return string;
                    }
                }
            }
            catch (Exception exception) {
                string = "";
            }
        }
        catch (Throwable throwable) {}
        return string;
    }

    public int getRoundBullet() {
        int n = -1;
        try {
            try {
                int n2 = this.roundBulletCount.size();
                while (n2 > 4) {
                    n2 -= 4;
                }
                switch (n2) {
                    case 1: {
                        n = 0;
                        break;
                    }
                    case 2: {
                        n = 2;
                        break;
                    }
                    case 3: {
                        n = 1;
                        break;
                    }
                    case 4: {
                        n = 3;
                        break;
                    }
                    default: {
                        return n;
                    }
                }
            }
            catch (Exception exception) {
                n = -1;
            }
        }
        catch (Throwable throwable) {}
        return n;
    }

    private void clearStack(Stack stack) {
        while (!stack.empty()) {
            stack.pop();
        }
    }

    public void reset() {
        this.X = 0;
        this.Y = 0;
        this.maxY = 0;
        this.lineBreak = false;
        this.newLine = false;
        this.alignment = 4;
        this.indent = 0;
        this.rightIndent = 0;
        this.preFormatted = false;
        this.popFont = false;
        this.popColor = false;
        this.popFace = false;
        this.doBullet = false;
        this.inList = 0;
        this.hyperLink = false;
        this.clearStack(this.fontSizeStack);
        this.clearStack(this.fontAttributeStack);
        this.clearStack(this.fontFaceStack);
        this.clearStack(this.listBullets);
        this.clearStack(this.defListStack);
        this.clearStack(this.bulletType);
        this.clearStack(this.roundBulletCount);
        this.clearStack(this.numberBulletCount);
        this.clearStack(this.anchorStack);
        this.clearStack(this.bookmarkStack);
        this.fontSize = this.defaultFontSize;
        this.fontAttribute = this.defaultFontStyle;
        this.fontFace = this.defaultFontFace;
        this.currentFont = new Font(this.fontFace, this.fontAttribute, this.fontSize);
        this.fm = null;
        this.fmMaxDescent = 0;
        this.fmMaxAscent = 0;
        this.fmHeight = 0;
        this.clearStack(this.fontColorStack);
        this.fgColor = htmlFormatDefaults.DEFAULTCOLOR;
        this.bgColor = htmlFormatDefaults.DEFAULTBACKGROUND;
        this.urlBase = "";
        this.links.removeAllElements();
        this.bookmarks.removeAllElements();
        this.clearStack(this.divAlign);
        this.clearStack(this.paraAlign);
        this.clearStack(this.headAlign);
        this.underline = true;
        this.strikethrough = false;
    }

    protected void finalize() throws Throwable {
        if (this.links != null) {
            this.links.removeAllElements();
        }
        if (this.bookmarks != null) {
            this.bookmarks.removeAllElements();
        }
        this.links = null;
        this.bookmarks = null;
    }
}

