/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.jhelp;

import com.novell.application.jhelp.htmlCanvasEvent;
import com.novell.application.jhelp.htmlContext;
import com.novell.application.jhelp.htmlFoundText;
import com.novell.application.jhelp.htmlJhelpListener;
import com.novell.application.jhelp.htmlLineBreak;
import com.novell.application.jhelp.htmlLinkEvent;
import com.novell.application.jhelp.htmlLinkListener;
import com.novell.application.jhelp.htmlMessageBox;
import com.novell.application.jhelp.htmlObject;
import com.novell.application.jhelp.htmlOldImage;
import com.novell.application.jhelp.htmlPrintDialog;
import com.novell.application.jhelp.htmlStackManager;
import com.novell.application.jhelp.htmlStackObject;
import com.novell.application.jhelp.htmlVector;
import com.novell.application.jhelp.htmlWord;
import java.awt.AWTEventMulticaster;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.PrintJob;
import java.awt.Scrollbar;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.Vector;

class htmlHelpCanvas
extends Canvas
implements MouseMotionListener,
MouseListener {
    public static final String DYN_PREFIX = "dynamic:";
    public static final String DYN_NAME = "_$$DYNAMIC$$_";
    public static final String DYNAMIC = "dynamic:_$$DYNAMIC$$_";
    private Image image;
    private int Y = 0;
    private htmlVector htmlObjects;
    private boolean redraw = false;
    private boolean reshaped = false;
    private Scrollbar sb;
    private int topObj;
    private boolean isHit = false;
    private int lastSearchIndex;
    private Hashtable htmlVectors;
    private String pendingLink;
    private int pendingIndex = -1;
    private Object inst;
    private Container parent;
    private Stack oldImages;
    private Cursor waitCursor = new Cursor(3);
    private Cursor dfltCursor = new Cursor(0);
    private Cursor handCursor = new Cursor(12);
    private ActionListener actionListener;
    private int maxCache;
    private ResourceBundle resources;
    private Vector linkListeners;
    private String zipfile;
    private htmlStackManager hsm;
    boolean disableStack = false;
    htmlJhelpListener jhelpListener;

    public htmlHelpCanvas(Object object, String string, Scrollbar scrollbar, ResourceBundle resourceBundle) {
        this.sb = scrollbar;
        this.resources = resourceBundle;
        this.getHelpVectors(object, string);
        this.inst = object;
        this.oldImages = new Stack();
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.maxCache = 10;
        this.linkListeners = new Vector();
        this.hsm = null;
    }

    public htmlHelpCanvas(Object object, String string, Scrollbar scrollbar, Object object2, Object object3, ResourceBundle resourceBundle) {
        this.sb = scrollbar;
        this.resources = resourceBundle;
        this.getHelpVectors(object, string);
        this.inst = object;
        this.oldImages = new Stack();
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.maxCache = 10;
        this.linkListeners = new Vector();
        this.hsm = new htmlStackManager(object2, object3);
        if (string == null || string.toLowerCase().endsWith(".zip") || string.toLowerCase().endsWith(".jar")) {
            this.disableStack = true;
        }
    }

    public void enableStacks(Object object, Object object2) {
        this.hsm = new htmlStackManager(object, object2);
    }

    public void addLinkListener(htmlLinkListener htmlLinkListener2) {
        if (!this.linkListeners.contains(htmlLinkListener2)) {
            this.linkListeners.addElement(htmlLinkListener2);
        }
    }

    public void removeLinkListener(htmlLinkListener htmlLinkListener2) {
        this.linkListeners.removeElement(htmlLinkListener2);
    }

    private void getHelpVectors(Object object, String string) {
        Vector vector;
        this.htmlVectors = new Hashtable();
        if (string != null && (string.toLowerCase().endsWith(".jar") || string.toLowerCase().endsWith(".zip"))) {
            this.zipfile = new String(string);
            string = null;
        }
        if ((vector = htmlVector.parseHelpFiles(string)).size() == 0) {
            this.addHTMLString(object, "", null);
            return;
        }
        int n = 0;
        while (n < vector.size()) {
            String string2 = (String)vector.elementAt(n);
            this.htmlVectors.put(string2, new htmlVector(this.zipfile, object, string2, this.resources));
            ++n;
        }
        this.setText((htmlVector)this.htmlVectors.get((String)vector.elementAt(0)));
    }

    public void setText(htmlVector htmlVector2) {
        if (this.htmlVectors.get(htmlVector2.getFileName()) == null) {
            this.htmlVectors.put(htmlVector2.getFileName(), htmlVector2);
        }
        this.htmlObjects = htmlVector2;
        this.redraw = true;
        this.Y = 0;
        this.repaint();
    }

    public void addFile(Object object, String string, String string2) {
        if (this.htmlVectors.get(string) == null) {
            this.htmlVectors.put(string, new htmlVector(string2, object, string, this.resources));
        }
        if (this.maxCache > 0 && this.htmlVectors.size() > this.maxCache) {
            Enumeration enumeration = this.htmlVectors.keys();
            while (enumeration.hasMoreElements() && this.htmlVectors.size() > this.maxCache) {
                String string3 = (String)enumeration.nextElement();
                if (string3.equals(string)) continue;
                this.htmlVectors.remove(string3);
                try {
                    Runtime.getRuntime().gc();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void addFile(Object object, String string) {
        this.addFile(object, string, this.zipfile);
    }

    public void addHTMLString(Object object, String string, String string2) {
        if (string2 == null || string2.equals(DYNAMIC)) {
            string2 = DYN_NAME;
        }
        if (this.htmlVectors.get(string2) != null) {
            this.htmlVectors.remove(string2);
        }
        if (this.htmlObjects == null || this.htmlObjects.getFileName().equals(string2)) {
            this.setText(new htmlVector(object, string, string2, this.resources));
        } else {
            this.htmlVectors.put(string2, new htmlVector(object, string, string2, this.resources));
        }
        if (this.maxCache > 0 && this.htmlVectors.size() > this.maxCache) {
            Enumeration enumeration = this.htmlVectors.keys();
            while (enumeration.hasMoreElements() && this.htmlVectors.size() > this.maxCache) {
                String string3 = (String)enumeration.nextElement();
                if (string3.equals(string2)) continue;
                this.htmlVectors.remove(string3);
                try {
                    Runtime.getRuntime().gc();
                }
                catch (Exception exception) {}
            }
        }
    }

    public synchronized void paint(Graphics graphics) {
        if (this.redraw && this.htmlObjects != null) {
            this.setCursor(this.waitCursor);
            if (this.reshaped) {
                this.topObj = this.htmlObjects.getTopObject(this.Y);
            }
            if (this.image != null) {
                this.image.flush();
                this.image = null;
            }
            try {
                Runtime.getRuntime().gc();
            }
            catch (Exception exception) {}
            try {
                this.image = this.htmlObjects.draw(graphics, this.getSize().width, this.getSize().height);
            }
            catch (Exception exception) {
                if (this.jhelpListener != null) {
                    this.jhelpListener.handleJhelpImageException(exception);
                }
                return;
            }
            if (this.image == null) {
                return;
            }
            int n = this.getSize().height / 12;
            int n2 = (this.image.getHeight(this) - 12) / 12;
            if (this.reshaped) {
                this.reshaped = false;
                this.Y = Math.max(0, Math.min((n2 - n) * 12, this.htmlObjects.getTopPosition(this.topObj)));
            }
            this.sb.setValues(this.Y / 12, n, 0, n2);
            this.redraw = false;
            this.setCursor(this.dfltCursor);
        }
        if (this.image != null) {
            graphics.drawImage(this.image, 0, -this.Y, this);
        }
        if (this.pendingLink != null) {
            this.goTo(this.pendingLink);
            this.pendingLink = null;
        }
        if (this.pendingIndex != -1) {
            this.goTo(this.pendingIndex);
            this.pendingIndex = -1;
        }
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new htmlCanvasEvent(this, 0, this.htmlObjects.getTitle()));
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void setPosition(int n) {
        this.Y = n * 12;
        this.sb.setValue(n);
        this.repaint();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.redraw = true;
        this.reshaped = true;
        super.setBounds(n, n2, n3, n4);
        this.repaint();
    }

    public int getYPos() {
        return this.Y;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.htmlObjects != null) {
            boolean bl;
            if (n >= this.getSize().width - 1) {
                n = -1;
            }
            if (!(bl = this.htmlObjects.isHyperLink(n, n2 + this.Y)) && this.isHit) {
                this.isHit = !this.isHit;
                this.setCursor(this.dfltCursor);
                return;
            }
            if (bl && !this.isHit) {
                this.isHit = !this.isHit;
                this.setCursor(this.handCursor);
            }
        }
    }

    private void setWaitCursor() {
        this.setCursor(this.waitCursor);
    }

    private void setDefaultCursor() {
        this.setCursor(this.dfltCursor);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        String string;
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = mouseEvent.getModifiers();
        this.getParent().requestFocus();
        if (this.htmlObjects != null && this.htmlObjects.isHyperLink(n, n2 + this.Y) && (n3 & 4) == 0 && (n3 & 8) == 0 && (string = this.htmlObjects.getHyperLink(n, n2 + this.Y)) != null) {
            if (this.linkListeners.size() > 0) {
                int n4 = 0;
                while (n4 < this.linkListeners.size()) {
                    ((htmlLinkListener)this.linkListeners.elementAt(n4)).handleLink(new htmlLinkEvent(this, 0, string));
                    ++n4;
                }
                return;
            }
            this.defaultLinkHandler(string);
        }
    }

    public void defaultLinkHandler(String string) {
        if (string.startsWith("#")) {
            if (string.length() < 2) {
                return;
            }
            int n = this.htmlObjects.getHyperLinkPosition(string = string.substring(1, string.length()));
            if (n != -1) {
                this.manageStack();
                int n2 = this.getSize().height / 12;
                int n3 = (this.image.getHeight(this) - 12) / 12;
                this.Y = Math.max(0, Math.min((n3 - n2) * 12, n));
                this.sb.setValues(this.Y / 12, n2, 0, n3);
                this.repaint();
                return;
            }
        } else {
            this.goTo(string);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    private void goTo(int n) {
        int n2 = this.getSize().height / 12;
        int n3 = (this.image.getHeight(this) - 12) / 12;
        this.Y = Math.max(0, Math.min((n3 - n2) * 12, this.htmlObjects.getTopPosition(n)));
        this.sb.setValues(this.Y / 12, n2, 0, n3);
        this.repaint();
    }

    private void manageStack() {
        if (this.hsm != null) {
            if (!this.disableStack) {
                htmlStackObject htmlStackObject2 = new htmlStackObject(this.htmlObjects.getFileName(), this.htmlObjects.getTopObject(this.Y));
                this.hsm.addURL(htmlStackObject2);
                return;
            }
            this.disableStack = false;
        }
    }

    public synchronized void goTo(String string) {
        this.clearHighlights();
        if (string.startsWith(DYN_PREFIX)) {
            string = string.substring(DYN_PREFIX.length(), string.length());
        }
        if (string != null && string.length() >= 2) {
            if ((string = string.trim()).startsWith("#")) {
                int n;
                if (this.image == null) {
                    this.pendingLink = string;
                    this.repaint();
                    return;
                }
                if (this.pendingLink == null) {
                    this.manageStack();
                }
                if ((n = this.htmlObjects.getHyperLinkPosition(string = string.substring(1, string.length()))) != -1) {
                    int n2 = this.getSize().height / 12;
                    int n3 = (this.image.getHeight(this) - 12) / 12;
                    this.Y = Math.max(0, Math.min((n3 - n2) * 12, n));
                    this.sb.setValues(this.Y / 12, n2, 0, n3);
                    this.repaint();
                    return;
                }
                int n4 = this.getSize().height / 12;
                int n5 = (this.image.getHeight(this) - 12) / 12;
                this.Y = 0;
                this.sb.setValues(0, n4, 0, n5);
                this.repaint();
                return;
            }
            htmlContext htmlContext2 = this.getContext(string);
            if (htmlContext2.getFileName().equals(this.htmlObjects.getFileName())) {
                if (htmlContext2.getContext() != null) {
                    this.goTo(htmlContext2.getContext());
                    return;
                }
                this.Y = 0;
                this.sb.setValue(0);
                this.repaint();
                return;
            }
            if (this.htmlVectors.get(htmlContext2.getFileName()) != null) {
                this.manageStack();
                this.htmlObjects = (htmlVector)this.htmlVectors.get(htmlContext2.getFileName());
                this.redraw = true;
                if (htmlContext2.getContext() != null) {
                    this.pendingLink = htmlContext2.getContext();
                    this.repaint();
                    return;
                }
                this.Y = 0;
                this.sb.setValue(0);
                this.repaint();
                return;
            }
            this.manageStack();
            this.disableStack = true;
            this.setCursor(this.waitCursor);
            this.addFile(this.inst, htmlContext2.getFileName(), this.zipfile);
            this.goTo(string);
            return;
        }
        this.repaint();
    }

    public void goTo(String string, int n) {
        this.clearHighlights();
        this.manageStack();
        this.htmlObjects = (htmlVector)this.htmlVectors.get(string);
        if (this.htmlObjects == null) {
            this.addFile(this.inst, string, this.zipfile);
            this.htmlObjects = (htmlVector)this.htmlVectors.get(string);
        }
        this.redraw = true;
        this.pendingIndex = n;
        this.repaint();
    }

    public void goBack() {
        if (this.hsm == null) {
            return;
        }
        this.clearHighlights();
        int n = this.htmlObjects.getTopObject(this.Y);
        String string = this.htmlObjects.getFileName();
        htmlStackObject htmlStackObject2 = new htmlStackObject(string, n);
        htmlStackObject2 = this.hsm.goBack(htmlStackObject2);
        if (htmlStackObject2 == null) {
            return;
        }
        string = htmlStackObject2.getFileName();
        n = htmlStackObject2.getIndex();
        this.disableStack = true;
        if (string.equals(this.htmlObjects.getFileName())) {
            this.goTo(n);
            return;
        }
        this.goTo(string, n);
    }

    public void goForward() {
        if (this.hsm == null) {
            return;
        }
        this.clearHighlights();
        int n = this.htmlObjects.getTopObject(this.Y);
        String string = this.htmlObjects.getFileName();
        htmlStackObject htmlStackObject2 = new htmlStackObject(string, n);
        htmlStackObject2 = this.hsm.goForward(htmlStackObject2);
        if (htmlStackObject2 == null) {
            return;
        }
        string = htmlStackObject2.getFileName();
        n = htmlStackObject2.getIndex();
        this.disableStack = true;
        if (string.equals(this.htmlObjects.getFileName())) {
            this.goTo(n);
            return;
        }
        this.goTo(string, n);
    }

    public void find(Container container, String string, boolean bl, boolean bl2) {
        this.findText(container, string, bl, bl2, 0);
    }

    public void findNext(Container container, String string, boolean bl, boolean bl2) {
        this.findText(container, string, bl, bl2, this.lastSearchIndex);
    }

    public void clearHighlights() {
        try {
            while (!this.oldImages.isEmpty()) {
                htmlOldImage htmlOldImage2 = (htmlOldImage)this.oldImages.pop();
                Graphics graphics = this.image.getGraphics();
                htmlOldImage2.draw(graphics, this);
                graphics.dispose();
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private void findText(Container container, String string, boolean bl, boolean bl2, int n) {
        Object object;
        Object object2;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Vector<String> vector = new Vector<String>();
        Stack<htmlFoundText> stack = new Stack<htmlFoundText>();
        htmlObject htmlObject2 = null;
        String string2 = null;
        Cursor cursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.clearHighlights();
        if (string == null || string.trim().length() == 0) {
            htmlMessageBox.showMessage(container, this.resources.getString("k17"), this.resources.getString("k20"), this.resources.getString("k53"));
            return;
        }
        if (this.htmlObjects.size() == 0) {
            htmlMessageBox.showMessage(container, this.resources.getString("k18"), this.resources.getString("k20"), this.resources.getString("k53"));
            return;
        }
        if (n >= this.htmlObjects.size()) {
            n = 0;
        }
        htmlLineBreak htmlLineBreak2 = new htmlLineBreak(string);
        n2 = htmlLineBreak2.first();
        n3 = htmlLineBreak2.next();
        while (n3 != -1) {
            String string3 = string.substring(n2, n3);
            if (!string3.equals(" ")) {
                vector.addElement(string3);
            }
            n2 = n3;
            n3 = htmlLineBreak2.next();
        }
        int n5 = n;
        while (n5 < this.htmlObjects.size()) {
            n4 = 0;
            while (n4 < vector.size() && n5 + n4 < this.htmlObjects.size()) {
                object2 = (String)vector.elementAt(n4);
                string2 = null;
                do {
                    if (!((htmlObject2 = (htmlObject)this.htmlObjects.elementAt(n5 + n4)) instanceof htmlWord)) continue;
                    string2 = ((htmlWord)htmlObject2).toString();
                    break;
                } while (++n5 + n4 < this.htmlObjects.size());
                if (string2 != null) {
                    boolean bl3 = bl ? (!bl2 ? string2.indexOf((String)object2) != -1 : string2.trim().equals(((String)object2).trim())) : (!bl2 ? string2.toLowerCase().indexOf(((String)object2).toLowerCase()) != -1 : string2.toLowerCase().trim().equals(((String)object2).toLowerCase().trim()));
                    if (!bl3) {
                        while (!stack.isEmpty()) {
                            stack.pop();
                        }
                        break;
                    }
                    object = (htmlWord)this.htmlObjects.elementAt(n5 + n4);
                    stack.push(new htmlFoundText(n5 + n4, ((htmlObject)object).xy.x, ((htmlObject)object).xy.y + ((htmlObject)object).height - ((htmlWord)object).getRealSize().height + ((htmlWord)object).getMaxDescent(), ((htmlWord)object).getRealSize().width, ((htmlWord)object).getRealSize().height));
                }
                ++n4;
            }
            if (n4 == vector.size()) break;
            ++n5;
        }
        if (n5 == this.htmlObjects.size()) {
            htmlMessageBox.showMessage(container, this.resources.getString("k16"), this.resources.getString("k20"), this.resources.getString("k53"));
        } else {
            try {
                while (!stack.isEmpty()) {
                    htmlFoundText htmlFoundText2 = (htmlFoundText)stack.pop();
                    object2 = this.image.getGraphics();
                    object = this.createImage(htmlFoundText2.getWidth(), htmlFoundText2.getHeight());
                    Graphics graphics = ((Image)object).getGraphics();
                    graphics.drawImage(this.image, 0, 0, htmlFoundText2.getWidth(), htmlFoundText2.getHeight(), htmlFoundText2.getX(), htmlFoundText2.getY(), htmlFoundText2.getX() + htmlFoundText2.getWidth(), htmlFoundText2.getY() + htmlFoundText2.getHeight(), this);
                    this.oldImages.push(new htmlOldImage((Image)object, htmlFoundText2.getX(), htmlFoundText2.getY(), htmlFoundText2.getWidth(), htmlFoundText2.getHeight()));
                    ((Graphics)object2).setXORMode(Color.black);
                    ((Graphics)object2).setColor(Color.white);
                    ((Graphics)object2).fillRect(htmlFoundText2.getX(), htmlFoundText2.getY(), htmlFoundText2.getWidth(), htmlFoundText2.getHeight());
                    n5 = htmlFoundText2.getIndex();
                }
            }
            catch (Exception exception) {}
            this.goTo(n5);
            this.lastSearchIndex = n5 + n4;
        }
        this.setCursor(cursor);
    }

    private htmlContext getContext(String string) {
        int n = string.indexOf("#");
        htmlContext htmlContext2 = n != -1 ? new htmlContext(string.substring(0, n), string.substring(n, string.length())) : new htmlContext(string, null);
        return htmlContext2;
    }

    public void printHelpFile(Frame frame) {
        Properties properties = new Properties();
        PrintJob printJob = this.getToolkit().getPrintJob((Frame)this.inst, this.htmlObjects.getFileName(), properties);
        if (printJob != null) {
            new htmlPrintDialog(printJob, frame, this.htmlObjects.getFileName(), this.inst, this.zipfile, this.resources).setVisible(true);
        }
    }

    public String getCurrentFileName() {
        return this.htmlObjects.getFileName();
    }

    public void setMaxCache(int n) {
        this.maxCache = Math.max(0, n);
    }

    public int getMaxCache() {
        return this.maxCache;
    }

    public void resetStacks() {
        if (this.hsm != null) {
            this.hsm.resetStacks();
        }
    }

    public void setJhelpListener(htmlJhelpListener htmlJhelpListener2) {
        this.jhelpListener = htmlJhelpListener2;
    }

    protected void finalize() {
        if (this.image != null) {
            this.image.flush();
            this.image = null;
        }
        try {
            Runtime.getRuntime().gc();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }
}

