/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.jhelp.tabs;

import java.awt.AWTEventMulticaster;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

class Tab
extends Canvas {
    static final int ROUND = 8;
    static final int HALFROUND = 4;
    String caption;
    int width;
    int height;
    boolean hasFocus;
    Image image;
    Graphics ig;
    FontMetrics fm;
    Font plainfont;
    Font boldfont;
    ActionListener actionListener;

    public Tab(String string, int n) {
        this.caption = string;
        this.plainfont = new Font("sansserif", 0, 12);
        this.boldfont = new Font("sansserif", 1, 12);
        this.setBackground(Color.lightGray);
        this.fm = this.getToolkit().getFontMetrics(this.plainfont);
        this.width = n;
        this.height = this.fm.getHeight() * 4 / 3;
        1 var3_3 = new 1();
        this.addMouseListener(var3_3);
    }

    public void setFocus(boolean bl) {
        this.hasFocus = bl;
        this.repaint();
    }

    public void sendActionEvent() {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.caption));
            this.hasFocus = true;
            this.repaint();
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void paint(Graphics graphics) {
        if (this.image == null) {
            this.image = this.createImage(this.width, this.height);
            this.ig = this.image.getGraphics();
        }
        Color color = this.getBackground();
        this.ig.setColor(color);
        this.ig.fillRect(0, 0, this.width, this.height);
        if (this.hasFocus) {
            this.ig.setColor(color.brighter().brighter());
            this.ig.drawRoundRect(0, 0, this.width, this.height + 4, 8, 8);
            this.ig.drawRoundRect(1, 1, this.width - 2, this.height + 4, 8, 8);
            this.ig.setColor(color.darker().darker());
            this.ig.drawLine(this.width - 1, 4, this.width - 1, 4 + this.height);
            this.ig.drawLine(this.width - 2, 4, this.width - 2, 4 + this.height);
            this.ig.setFont(this.boldfont);
            int n = this.fm.getHeight() / 2 + (this.fm.getAscent() + 4) / 2;
            int n2 = (this.width - this.fm.stringWidth(this.caption)) / 2;
            this.ig.setColor(Color.black);
            this.ig.drawString(this.caption, n2, n);
        } else {
            this.ig.setColor(color.darker());
            this.ig.fillRoundRect(0, 0, this.width, this.height + 4, 8, 8);
            this.ig.setColor(color.brighter().brighter());
            this.ig.drawRoundRect(0, 0, this.width, this.height + 4, 8, 8);
            this.ig.setColor(color.darker().darker());
            this.ig.drawLine(this.width - 1, 4, this.width - 1, 4 + this.height);
            this.ig.setFont(this.plainfont);
            int n = this.fm.getHeight() / 2 + (this.fm.getAscent() + 4) / 2;
            int n3 = (this.width - this.fm.stringWidth(this.caption)) / 2;
            this.ig.setColor(Color.black);
            this.ig.drawString(this.caption, n3, n);
        }
        graphics.drawImage(this.image, 0, 0, this);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public String getText() {
        return this.caption;
    }

    private final class 1
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            Tab.this.sendActionEvent();
        }

        /* synthetic */ 1() {
        }
    }
}

