/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.jhelp.tabs;

import com.novell.application.jhelp.tabs.Tab;
import java.awt.AWTEventMulticaster;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

class TabManager
extends Panel
implements ActionListener {
    static final int TABWIDTH = 65;
    Vector tabs = new Vector();
    ActionListener actionListener;
    GridBagLayout gridbag;
    GridBagConstraints c;
    Point p;
    int x;
    int y;

    public TabManager() {
        this.setLayout(null);
    }

    public Insets getInsets() {
        return new Insets(0, 0, 2, 0);
    }

    public Tab add(String string) {
        Tab tab = new Tab(string, 65);
        tab.addActionListener(this);
        super.add(tab);
        this.y = tab.getPreferredSize().height;
        tab.setBounds(this.x, 0, 65, this.y);
        this.x += 65;
        this.tabs.addElement(tab);
        if (this.tabs.size() == 1) {
            tab.setFocus(true);
            this.p = tab.getLocation();
        }
        return tab;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        int n = 0;
        while (n < this.tabs.size()) {
            if (!object.equals(this.tabs.elementAt(n))) {
                ((Tab)this.tabs.elementAt(n)).setFocus(false);
            }
            ++n;
        }
        this.p = ((Tab)object).getLocation();
        this.repaint();
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(actionEvent);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.p != null) {
            graphics.setColor(this.getBackground().brighter().brighter());
            int n = this.getSize().height - 2;
            int n2 = this.getSize().width - 1;
            graphics.drawLine(0, n, this.p.x + 1, n);
            graphics.drawLine(this.p.x + 65, n, n2, n);
            graphics.drawLine(0, ++n, this.p.x + 1, n);
            graphics.drawLine(this.p.x + 65, n, n2, n);
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.x, this.y + 2);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }
}

