/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.util;

import com.novell.ldap.LDAPDN;
import com.novell.ldap.util.RDN;
import java.util.ArrayList;
import java.util.Vector;

public class DN {
    private static final int LOOK_FOR_RDN_ATTR_TYPE = 1;
    private static final int ALPHA_ATTR_TYPE = 2;
    private static final int OID_ATTR_TYPE = 3;
    private static final int LOOK_FOR_RDN_VALUE = 4;
    private static final int QUOTED_RDN_VALUE = 5;
    private static final int HEX_RDN_VALUE = 6;
    private static final int UNQUOTED_RDN_VALUE = 7;
    private ArrayList rdnList = new ArrayList();

    public DN() {
    }

    public DN(String dnString) {
        int currIndex;
        if (dnString.length() == 0) {
            return;
        }
        char[] tokenBuf = new char[dnString.length()];
        int trailingSpaceCount = 0;
        String attrType = "";
        String attrValue = "";
        String rawValue = "";
        int hexDigitCount = 0;
        RDN currRDN = new RDN();
        boolean firstDigitZero = false;
        int tokenIndex = 0;
        int valueStart = 0;
        int state = 1;
        int lastIndex = dnString.length() - 1;
        block9: for (currIndex = 0; currIndex <= lastIndex; ++currIndex) {
            char currChar = dnString.charAt(currIndex);
            switch (state) {
                case 1: {
                    while (currChar == ' ' && currIndex < lastIndex) {
                        currChar = dnString.charAt(++currIndex);
                    }
                    if (this.isAlpha(currChar)) {
                        if (dnString.startsWith("oid.", currIndex) || dnString.startsWith("OID.", currIndex)) {
                            if ((currIndex += 4) > lastIndex) {
                                throw new IllegalArgumentException(dnString);
                            }
                            currChar = dnString.charAt(currIndex);
                            if (this.isDigit(currChar)) {
                                tokenBuf[tokenIndex++] = currChar;
                                state = 3;
                                continue block9;
                            }
                            throw new IllegalArgumentException(dnString);
                        }
                        tokenBuf[tokenIndex++] = currChar;
                        state = 2;
                        continue block9;
                    }
                    if (this.isDigit(currChar)) {
                        --currIndex;
                        state = 3;
                        continue block9;
                    }
                    if (Character.isSpaceChar(currChar)) continue block9;
                    throw new IllegalArgumentException(dnString);
                }
                case 2: {
                    if (this.isAlpha(currChar) || this.isDigit(currChar) || currChar == '-') {
                        tokenBuf[tokenIndex++] = currChar;
                        continue block9;
                    }
                    while (currChar == ' ' && currIndex < lastIndex) {
                        currChar = dnString.charAt(++currIndex);
                    }
                    if (currChar == '=') {
                        attrType = new String(tokenBuf, 0, tokenIndex);
                        tokenIndex = 0;
                        state = 4;
                        continue block9;
                    }
                    throw new IllegalArgumentException(dnString);
                }
                case 3: {
                    if (!this.isDigit(currChar)) {
                        throw new IllegalArgumentException(dnString);
                    }
                    firstDigitZero = currChar == '0';
                    tokenBuf[tokenIndex++] = currChar;
                    if (this.isDigit(currChar = dnString.charAt(++currIndex)) && firstDigitZero || currChar == '.' && firstDigitZero) {
                        throw new IllegalArgumentException(dnString);
                    }
                    while (this.isDigit(currChar) && currIndex < lastIndex) {
                        tokenBuf[tokenIndex++] = currChar;
                        currChar = dnString.charAt(++currIndex);
                    }
                    if (currChar == '.') {
                        tokenBuf[tokenIndex++] = currChar;
                        continue block9;
                    }
                    while (currChar == ' ' && currIndex < lastIndex) {
                        currChar = dnString.charAt(++currIndex);
                    }
                    if (currChar == '=') {
                        attrType = new String(tokenBuf, 0, tokenIndex);
                        tokenIndex = 0;
                        state = 4;
                        continue block9;
                    }
                    throw new IllegalArgumentException(dnString);
                }
                case 4: {
                    while (currChar == ' ') {
                        if (currIndex < lastIndex) {
                            currChar = dnString.charAt(++currIndex);
                            continue;
                        }
                        throw new IllegalArgumentException(dnString);
                    }
                    if (currChar == '\"') {
                        state = 5;
                        valueStart = currIndex;
                        continue block9;
                    }
                    if (currChar == '#') {
                        hexDigitCount = 0;
                        tokenBuf[tokenIndex++] = currChar;
                        valueStart = currIndex;
                        state = 6;
                        continue block9;
                    }
                    valueStart = currIndex--;
                    state = 7;
                    continue block9;
                }
                case 7: {
                    char tmpc;
                    char nextChar;
                    if (currChar == '\\') {
                        if (currIndex >= lastIndex) {
                            throw new IllegalArgumentException(dnString);
                        }
                        if (DN.isHexDigit(currChar = dnString.charAt(++currIndex))) {
                            if (currIndex >= lastIndex) {
                                throw new IllegalArgumentException(dnString);
                            }
                            if (DN.isHexDigit(nextChar = dnString.charAt(++currIndex))) {
                                tmpc = DN.hexToChar(currChar, nextChar);
                                if (this.needsEscape(tmpc)) {
                                    tokenBuf[tokenIndex++] = 92;
                                    tokenBuf[tokenIndex++] = tmpc;
                                } else {
                                    tokenBuf[tokenIndex++] = tmpc;
                                }
                                trailingSpaceCount = 0;
                                continue block9;
                            }
                            throw new IllegalArgumentException(dnString);
                        }
                        if (this.needsEscape(currChar) || currChar == '#' || currChar == '=' || currChar == ' ') {
                            tokenBuf[tokenIndex++] = currChar;
                            trailingSpaceCount = 0;
                            continue block9;
                        }
                        throw new IllegalArgumentException(dnString);
                    }
                    if (currChar == ' ') {
                        ++trailingSpaceCount;
                        tokenBuf[tokenIndex++] = currChar;
                        continue block9;
                    }
                    if (currChar == ',' || currChar == ';' || currChar == '+') {
                        attrValue = new String(tokenBuf, 0, tokenIndex - trailingSpaceCount);
                        rawValue = dnString.substring(valueStart, currIndex - trailingSpaceCount);
                        currRDN.add(attrType, attrValue, rawValue);
                        if (currChar != '+') {
                            this.rdnList.add(currRDN);
                            currRDN = new RDN();
                        }
                        trailingSpaceCount = 0;
                        tokenIndex = 0;
                        state = 1;
                        continue block9;
                    }
                    if (this.needsEscape(currChar)) {
                        throw new IllegalArgumentException(dnString);
                    }
                    trailingSpaceCount = 0;
                    tokenBuf[tokenIndex++] = currChar;
                    continue block9;
                }
                case 5: {
                    char tmpc;
                    char nextChar;
                    if (currChar == '\"') {
                        rawValue = dnString.substring(valueStart, currIndex + 1);
                        if (currIndex < lastIndex) {
                            currChar = dnString.charAt(++currIndex);
                        }
                        while (currChar == ' ' && currIndex < lastIndex) {
                            currChar = dnString.charAt(++currIndex);
                        }
                        if (currChar == ',' || currChar == ';' || currChar == '+' || currIndex == lastIndex) {
                            attrValue = new String(tokenBuf, 0, tokenIndex);
                            currRDN.add(attrType, attrValue, rawValue);
                            if (currChar != '+') {
                                this.rdnList.add(currRDN);
                                currRDN = new RDN();
                            }
                            trailingSpaceCount = 0;
                            tokenIndex = 0;
                            state = 1;
                            continue block9;
                        }
                        throw new IllegalArgumentException(dnString);
                    }
                    if (currChar == '\\') {
                        if (DN.isHexDigit(currChar = dnString.charAt(++currIndex))) {
                            if (DN.isHexDigit(nextChar = dnString.charAt(++currIndex))) {
                                tmpc = DN.hexToChar(currChar, nextChar);
                                if (this.needsEscape(tmpc)) {
                                    tokenBuf[tokenIndex++] = 92;
                                }
                                tokenBuf[tokenIndex++] = tmpc;
                                trailingSpaceCount = 0;
                                continue block9;
                            }
                            throw new IllegalArgumentException(dnString);
                        }
                        if (this.needsEscape(currChar) || currChar == '#' || currChar == '=' || currChar == ' ') {
                            tokenBuf[tokenIndex++] = currChar;
                            trailingSpaceCount = 0;
                            continue block9;
                        }
                        throw new IllegalArgumentException(dnString);
                    }
                    tokenBuf[tokenIndex++] = currChar;
                    continue block9;
                }
                case 6: {
                    if (!DN.isHexDigit(currChar) || currIndex > lastIndex) {
                        if (hexDigitCount % 2 != 0 || hexDigitCount == 0) {
                            throw new IllegalArgumentException(dnString);
                        }
                        rawValue = dnString.substring(valueStart, currIndex);
                        while (currChar == ' ' && currIndex < lastIndex) {
                            currChar = dnString.charAt(++currIndex);
                        }
                        if (currChar == ',' || currChar == ';' || currChar == '+' || currIndex == lastIndex) {
                            attrValue = new String(tokenBuf, 0, tokenIndex);
                            currRDN.add(attrType, attrValue, rawValue);
                            if (currChar != '+') {
                                this.rdnList.add(currRDN);
                                currRDN = new RDN();
                            }
                            tokenIndex = 0;
                            state = 1;
                            continue block9;
                        }
                        throw new IllegalArgumentException(dnString);
                    }
                    tokenBuf[tokenIndex++] = currChar;
                    ++hexDigitCount;
                }
            }
        }
        if (state == 7 || state == 6 && hexDigitCount % 2 == 0 && hexDigitCount != 0) {
            attrValue = new String(tokenBuf, 0, tokenIndex - trailingSpaceCount);
            rawValue = dnString.substring(valueStart, currIndex - trailingSpaceCount);
            currRDN.add(attrType, attrValue, rawValue);
            this.rdnList.add(currRDN);
        } else if (state == 4) {
            attrValue = "";
            rawValue = dnString.substring(valueStart);
            currRDN.add(attrType, attrValue, rawValue);
            this.rdnList.add(currRDN);
        } else {
            throw new IllegalArgumentException(dnString);
        }
    }

    private boolean isAlpha(char ch) {
        return ch < '[' && ch > '@' || ch < '{' && ch > '`';
    }

    private boolean isDigit(char ch) {
        return ch < ':' && ch > '/';
    }

    private static boolean isHexDigit(char ch) {
        return ch < ':' && ch > '/' || ch < 'G' && ch > '@' || ch < 'g' && ch > '`';
    }

    private boolean needsEscape(char ch) {
        return ch == ',' || ch == '+' || ch == '\"' || ch == ';' || ch == '<' || ch == '>' || ch == '\\';
    }

    /*
     * WARNING - void declaration
     */
    private static char hexToChar(char hex1, char hex0) throws IllegalArgumentException {
        void var2_2;
        int result;
        if (hex1 < ':' && hex1 > '/') {
            result = (hex1 - 48) * 16;
        } else if (hex1 < 'G' && hex1 > '@') {
            result = (hex1 - 55) * 16;
        } else if (hex1 < 'g' && hex1 > '`') {
            result = (hex1 - 87) * 16;
        } else {
            throw new IllegalArgumentException("Not hex digit");
        }
        if (hex0 < ':' && hex0 > '/') {
            result += hex0 - 48;
        } else if (hex0 < 'G' && hex0 > '@') {
            result += hex0 - 55;
        } else if (hex0 < 'g' && hex0 > '`') {
            result += hex0 - 87;
        } else {
            throw new IllegalArgumentException("Not hex digit");
        }
        return (char)var2_2;
    }

    public String toString() {
        int length = this.rdnList.size();
        String dn = "";
        if (length < 1) {
            return null;
        }
        dn = LDAPDN.escapeRDN(this.rdnList.get(0).toString());
        for (int i = 1; i < length; ++i) {
            dn = dn + "," + LDAPDN.escapeRDN(this.rdnList.get(i).toString());
        }
        return dn;
    }

    public boolean equals(DN toDN) {
        int length = toDN.rdnList.size();
        if (this.rdnList.size() != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (((RDN)this.rdnList.get(i)).equals((RDN)toDN.rdnList.get(i))) continue;
            return false;
        }
        return true;
    }

    public String[] explodeDN(boolean noTypes) {
        int length = this.rdnList.size();
        String[] rdns = new String[length];
        for (int i = 0; i < length; ++i) {
            rdns[i] = ((RDN)this.rdnList.get(i)).toString(noTypes);
        }
        return rdns;
    }

    public int countRDNs() {
        return this.rdnList.size();
    }

    public Vector getRDNs() {
        int size = this.rdnList.size();
        Vector v = new Vector(size);
        for (int i = 0; i < size; ++i) {
            v.addElement(this.rdnList.get(i));
        }
        return v;
    }

    public boolean isDescendantOf(DN containerDN) {
        int j;
        int i = containerDN.rdnList.size() - 1;
        if (i > (j = this.rdnList.size() - 1)) {
            return false;
        }
        while (!((RDN)this.rdnList.get(j--)).equals((RDN)containerDN.rdnList.get(i))) {
            if (j > 0) continue;
            return false;
        }
        --i;
        while (i >= 0 && j >= 0) {
            if (!((RDN)this.rdnList.get(j)).equals((RDN)containerDN.rdnList.get(i))) {
                return false;
            }
            --i;
            --j;
        }
        return j != 0 || i != 0;
    }

    public DN getParent() {
        DN parent = new DN();
        parent.rdnList = (ArrayList)this.rdnList.clone();
        if (parent.rdnList.size() >= 1) {
            parent.rdnList.remove(0);
        }
        return parent;
    }

    public void addRDN(RDN rdn) {
        this.rdnList.add(0, rdn);
    }

    public void addRDNToFront(RDN rdn) {
        this.rdnList.add(0, rdn);
    }

    public void addRDNToBack(RDN rdn) {
        this.rdnList.add(rdn);
    }
}

