/*
 * Decompiled with CFR 0.152.
 */
package com.novell.java.io;

import com.novell.java.io.DataAccessable;
import com.novell.java.io.spi.DataAccessor;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;

public class RandomAccess
implements DataInput,
DataOutput {
    private DataAccessor accessor;
    private long position;

    public RandomAccess(DataAccessable dataAccessable) throws IOException {
        this.accessor = dataAccessable.openStream(3);
        this.position = 0L;
    }

    public RandomAccess(DataAccessable dataAccessable, Object object) throws IOException {
        this.accessor = dataAccessable.openStream(3, object);
    }

    public RandomAccess(String string, DataAccessable dataAccessable) throws IOException {
        this.accessor = dataAccessable.openStream(string, 3);
    }

    public RandomAccess(String string, DataAccessable dataAccessable, Object object) throws IOException {
        this.accessor = dataAccessable.openStream(string, 3, object);
    }

    protected RandomAccess() {
    }

    public int read() throws IOException {
        int n = this.accessor.read();
        if (n >= 0) {
            ++this.position;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.accessor.read(byArray, n, n2);
        if (n3 >= 0) {
            this.position += (long)n3;
        }
        return n3;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.read(byArray, n + n3, n2 - n3);
            if (n4 < 0) {
                throw new EOFException();
            }
            n3 += n4;
        }
    }

    public void write(int n) throws IOException {
        this.accessor.write(n);
        ++this.position;
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.accessor.write(byArray, n, n2);
        this.position += (long)n2;
    }

    public long getPosition() throws IOException {
        return this.position;
    }

    public void setPosition(long l) throws IOException {
        this.accessor.seek(l);
        this.position = l;
    }

    public void close() throws IOException {
        this.accessor.close();
    }

    public long length() throws IOException {
        return this.accessor.length();
    }

    public void setLength(long l) throws IOException {
        if (l >= 0L) {
            this.accessor.setLength(l);
        }
    }

    public final boolean readBoolean() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n != 0;
    }

    public final byte readByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    public final int readUnsignedByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    public final short readShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((n2 << 8) + n);
    }

    public final int readUnsignedShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n2 << 8) + n;
    }

    public final char readChar() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((n2 << 8) + n);
    }

    public final int readInt() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.read();
        if ((n4 | (n3 = this.read()) | (n2 = this.read()) | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + n;
    }

    public final long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final String readLine() throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = this.read()) != -1 && n != 10) {
            stringBuffer.append((char)n);
        }
        if (n == -1 && stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public int skipBytes(int n) throws IOException {
        this.accessor.seek(this.getPosition() + (long)n);
        this.position += (long)n;
        return n;
    }

    public final void writeBoolean(boolean bl) throws IOException {
        this.write(bl ? 1 : 0);
    }

    public final void writeByte(int n) throws IOException {
        this.write(n);
    }

    public final void writeShort(int n) throws IOException {
        this.write(n >>> 8 & 0xFF);
        this.write(n & 0xFF);
    }

    public final void writeChar(int n) throws IOException {
        this.write(n >>> 8 & 0xFF);
        this.write(n & 0xFF);
    }

    public final void writeInt(int n) throws IOException {
        this.write(n >>> 24 & 0xFF);
        this.write(n >>> 16 & 0xFF);
        this.write(n >>> 8 & 0xFF);
        this.write(n & 0xFF);
    }

    public final void writeLong(long l) throws IOException {
        this.write((int)(l >>> 56) & 0xFF);
        this.write((int)(l >>> 48) & 0xFF);
        this.write((int)(l >>> 40) & 0xFF);
        this.write((int)(l >>> 32) & 0xFF);
        this.write((int)(l >>> 24) & 0xFF);
        this.write((int)(l >>> 16) & 0xFF);
        this.write((int)(l >>> 8) & 0xFF);
        this.write((int)l & 0xFF);
    }

    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public final void writeBytes(String string) throws IOException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            this.write((byte)string.charAt(n2));
            ++n2;
        }
    }

    public final void writeChars(String string) throws IOException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            this.write(c >>> 8 & 0xFF);
            this.write(c & 0xFF);
            ++n2;
        }
    }

    public final void writeUTF(String string) throws IOException {
        int n;
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n = string.charAt(n4);
            n3 = n >= 1 && n <= 127 ? ++n3 : (n > 2047 ? (n3 += 3) : (n3 += 2));
            ++n4;
        }
        if (n3 > 65535) {
            throw new UTFDataFormatException();
        }
        this.write(n3 >>> 8 & 0xFF);
        this.write(n3 & 0xFF);
        n = 0;
        while (n < n2) {
            char c = string.charAt(n);
            if (c >= '\u0001' && c <= '\u007f') {
                this.write(c);
            } else if (c > '\u07ff') {
                this.write(0xE0 | c >> 12 & 0xF);
                this.write(0x80 | c >> 6 & 0x3F);
                this.write(0x80 | c & 0x3F);
            } else {
                this.write(0xC0 | c >> 6 & 0x1F);
                this.write(0x80 | c & 0x3F);
            }
            ++n;
        }
    }

    protected void setDataAccessor(DataAccessor dataAccessor) {
        this.accessor = dataAccessor;
    }
}

