/*
 * Decompiled with CFR 0.152.
 */
package com.novell.java.security;

import com.novell.java.security.AuthenticatorProtocol;
import com.novell.java.security.CreateTokensException;
import com.novell.java.security.GetIdentitiesException;
import com.novell.java.security.I2L;
import com.novell.java.security.Identity;
import com.novell.java.security.IdentityScope;
import com.novell.java.security.LoginException;
import com.novell.java.security.LogoutException;
import com.novell.java.security.ModifyTokensException;
import com.novell.java.security.Vault;
import com.novell.java.security.VerifyTokensException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class Authenticator {
    private static Vault vault = new Vault();
    private static Hashtable LastUsernames;
    private static Hashtable LastDomains;

    private Authenticator() {
    }

    public static void login(Identity identity) throws LoginException {
        AuthenticatorProtocol[] authenticatorProtocolArray = vault.getProtocols(identity);
        int n = 0;
        while (n < authenticatorProtocolArray.length) {
            authenticatorProtocolArray[n].login(identity);
            ++n;
        }
    }

    public static void modifyTokens(Identity identity) throws ModifyTokensException {
        AuthenticatorProtocol[] authenticatorProtocolArray = vault.getProtocols(identity);
        int n = 0;
        while (n < authenticatorProtocolArray.length) {
            authenticatorProtocolArray[n].modifyTokens(identity);
            ++n;
        }
    }

    public static void createTokens(Identity identity) throws CreateTokensException {
        Authenticator.createTokens(identity, identity);
    }

    public static void createTokens(Identity identity, Identity identity2) throws CreateTokensException {
        AuthenticatorProtocol[] authenticatorProtocolArray = vault.getProtocols(identity2);
        int n = 0;
        while (n < authenticatorProtocolArray.length) {
            authenticatorProtocolArray[n].createTokens(identity, identity2);
            ++n;
        }
    }

    public static synchronized void verifyTokens(Identity identity) throws VerifyTokensException {
        AuthenticatorProtocol[] authenticatorProtocolArray = vault.getProtocols(identity);
        int n = 0;
        while (n < authenticatorProtocolArray.length) {
            authenticatorProtocolArray[n].verifyTokens(identity);
            ++n;
        }
    }

    public static void logout(Identity identity) throws LogoutException {
        AuthenticatorProtocol[] authenticatorProtocolArray = vault.getProtocols(identity);
        int n = 0;
        while (n < authenticatorProtocolArray.length) {
            authenticatorProtocolArray[n].logout(identity);
            ++n;
        }
    }

    public static Identity[] getIdentities() throws GetIdentitiesException {
        Identity identity = null;
        Identity[] identityArray = vault.getConfiguredIdentities();
        if (identityArray == null || identityArray.length == 0) {
            throw new GetIdentitiesException(I2L.getString("NO_DEFAULT_IDENTITY_EXISTS"));
        }
        identity = identityArray[0];
        try {
            return Authenticator.getIdentities((IdentityScope)identity);
        }
        catch (ClassCastException classCastException) {
            throw new GetIdentitiesException(I2L.getString("NO_DEFAULT_SCOPE_EXISTS"), classCastException);
        }
    }

    public static Identity[] getIdentities(IdentityScope identityScope) throws GetIdentitiesException {
        Object[] objectArray;
        AuthenticatorProtocol[] authenticatorProtocolArray = vault.getProtocols(identityScope);
        Vector<Object> vector = new Vector<Object>();
        int n = 0;
        while (n < authenticatorProtocolArray.length) {
            objectArray = authenticatorProtocolArray[n].getIdentities(identityScope);
            int n2 = 0;
            while (n2 < objectArray.length) {
                vector.addElement(objectArray[n2]);
                ++n2;
            }
            ++n;
        }
        objectArray = new Identity[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static String getLastUsername() {
        return (String)LastUsernames.get(Thread.currentThread());
    }

    public static String getLastUserDomain() {
        return (String)LastDomains.get(Thread.currentThread());
    }

    public static void putLast(String string, String string2, Thread thread) {
        if (thread == null) {
            thread = Thread.currentThread();
        }
        if (string == null) {
            LastUsernames.remove(thread);
        } else {
            LastUsernames.put(thread, string);
        }
        if (string2 == null) {
            LastDomains.remove(thread);
        } else {
            LastDomains.put(thread, string2);
        }
        Hashtable hashtable = LastUsernames;
        synchronized (hashtable) {
            Object object;
            Vector<Object> vector = new Vector<Object>();
            Enumeration enumeration = LastUsernames.keys();
            while (enumeration.hasMoreElements()) {
                object = (Thread)enumeration.nextElement();
                if (((Thread)object).isAlive()) continue;
                vector.addElement(object);
            }
            object = LastDomains.keys();
            while (object.hasMoreElements()) {
                Thread thread2 = (Thread)object.nextElement();
                if (thread2.isAlive()) continue;
                vector.addElement(thread2);
            }
            int n = 0;
            while (n < vector.size()) {
                LastUsernames.remove(vector.elementAt(n));
                LastDomains.remove(vector.elementAt(n));
                ++n;
            }
            return;
        }
    }

    static {
        Identity[] identityArray = vault.getConfiguredIdentities();
        int n = 0;
        while (n < identityArray.length) {
            if (!(identityArray[n] instanceof IdentityScope)) {
                Authenticator.login(identityArray[n]);
            }
            ++n;
        }
        LastUsernames = new Hashtable(23);
        LastDomains = new Hashtable(23);
    }
}

