/*
 * Decompiled with CFR 0.152.
 */
package com.novell.java.util;

import com.novell.java.lang.HasRootCause;
import com.novell.java.lang.HasRootCauses;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NamingException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Debug {
    public static boolean debug;
    public static boolean assert;
    public static boolean exitOnAssert;
    public static boolean threads;
    public static boolean quiet;
    public static boolean outputToFile;
    private static boolean traceInstructions;
    private static boolean traceMethods;
    private static PrintStream oriout;
    private static PrintStream orierr;

    public static synchronized void setOutput(String string) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string, true);
        }
        catch (IOException iOException) {
            Debug.ignoreException("DEBUG.setOutput()", iOException);
            return;
        }
        System.setOut(new PrintStream(fileOutputStream));
        System.setErr(new PrintStream(fileOutputStream));
        outputToFile = true;
    }

    public static synchronized void clearOutput() {
        System.setOut(oriout);
        System.setErr(orierr);
        outputToFile = false;
    }

    public static synchronized void assert(boolean bl, String string) {
        if (assert && !bl) {
            Debug.println("ASSERT FAILURE: " + string);
            if (exitOnAssert) {
                Thread.dumpStack();
                System.exit(-1);
            }
        }
    }

    public static synchronized void traceOff() {
        if (traceInstructions) {
            Runtime.getRuntime().traceInstructions(false);
        }
        if (traceMethods) {
            Runtime.getRuntime().traceMethodCalls(false);
        }
    }

    public static synchronized void traceOn() {
        if (traceInstructions) {
            Runtime.getRuntime().traceInstructions(true);
        }
        if (traceMethods) {
            Runtime.getRuntime().traceMethodCalls(true);
        }
    }

    public static synchronized void traceInstructions(boolean bl) {
        traceInstructions = bl;
        Runtime.getRuntime().traceInstructions(traceInstructions);
    }

    public static synchronized void traceMethods(boolean bl) {
        traceMethods = bl;
        Runtime.getRuntime().traceMethodCalls(traceMethods);
    }

    public static synchronized boolean traceInstructionsOn() {
        return traceInstructions;
    }

    public static synchronized boolean traceMethodsOn() {
        return traceMethods;
    }

    public static synchronized void writeDebugProperties(String string) {
        try {
            Properties properties = new Properties();
            ((Hashtable)properties).put("debug", new Boolean(debug).toString());
            ((Hashtable)properties).put("assert", new Boolean(assert).toString());
            ((Hashtable)properties).put("exitOnAssert", new Boolean(exitOnAssert).toString());
            ((Hashtable)properties).put("threads", new Boolean(threads).toString());
            ((Hashtable)properties).put("quiet", new Boolean(quiet).toString());
            ((Hashtable)properties).put("traceInstructions", new Boolean(traceInstructions).toString());
            ((Hashtable)properties).put("traceMethods", new Boolean(traceMethods).toString());
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            properties.save(fileOutputStream, "Debug properties");
            fileOutputStream.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public static synchronized void readDebugProperties(String string) {
        try {
            Properties properties = new Properties();
            FileInputStream fileInputStream = new FileInputStream(string);
            properties.load(fileInputStream);
            fileInputStream.close();
            debug = new Boolean(properties.getProperty("debug", "false"));
            assert = new Boolean(properties.getProperty("assert", "false"));
            exitOnAssert = new Boolean(properties.getProperty("exitOnAssert", "false"));
            threads = new Boolean(properties.getProperty("threads", "false"));
            quiet = new Boolean(properties.getProperty("quiet", "false"));
            boolean bl = new Boolean(properties.getProperty("traceInstructions", "false"));
            boolean bl2 = new Boolean(properties.getProperty("traceMethods", "false"));
            Debug.traceInstructions(bl);
            Debug.traceMethods(bl2);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public static synchronized void dumpParents(Class clazz, int n) {
        if (debug) {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(' ');
                ++n2;
            }
            Class<?>[] classArray = clazz.getClasses();
            int n3 = 0;
            while (n3 < classArray.length) {
                Class<?> clazz2 = classArray[n3];
                Debug.println(String.valueOf(stringBuffer) + clazz2.getName());
                Debug.dumpParents(clazz2, n + 1);
                ++n3;
            }
        }
    }

    public static synchronized void dumpMembers(Class clazz, int n) {
        if (debug) {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(' ');
                ++n2;
            }
            Class<?>[] classArray = clazz.getDeclaredClasses();
            int n3 = 0;
            while (n3 < classArray.length) {
                Class<?> clazz2 = classArray[n3];
                Debug.println(String.valueOf(stringBuffer) + clazz2.getName());
                Debug.dumpMembers(clazz2, n + 1);
                ++n3;
            }
        }
    }

    public static synchronized void ignoreException(Throwable throwable) {
        Debug.ignoreException("", throwable);
    }

    public static synchronized void ignoreException(String string, Throwable throwable) {
        if (debug) {
            if (quiet) {
                Debug.ignoreExceptionQuietly(string, throwable);
                return;
            }
            Debug.println("IGNORING EXCEPTION:" + string + ":");
            Debug.dumpException(throwable);
        }
    }

    public static synchronized void ignoreExceptionQuietly(Throwable throwable) {
        Debug.ignoreExceptionQuietly("", throwable);
    }

    public static synchronized void ignoreExceptionQuietly(String string, Throwable throwable) {
        if (debug) {
            Debug.println("IGNORING EXCEPTION:" + string + ":");
            Debug.println(throwable.toString());
        }
    }

    public static synchronized void printlnBeep(String string) {
        Debug.println("\u0007" + string);
    }

    public static synchronized void dumpException(Throwable throwable) {
        System.out.flush();
        System.err.flush();
        System.out.println("\nException...");
        throwable.printStackTrace();
        while (throwable != null) {
            if (throwable instanceof HasRootCauses) {
                Debug.println("\nRoot causes...");
                Enumeration enumeration = ((HasRootCauses)((Object)throwable)).getRootCauses();
                while (enumeration.hasMoreElements()) {
                    Debug.dumpException((Throwable)enumeration.nextElement());
                }
            }
            if ((throwable = throwable instanceof HasRootCause ? ((HasRootCause)((Object)throwable)).getRootCause() : (throwable instanceof NamingException ? ((NamingException)throwable).getRootCause() : null)) == null) continue;
            Debug.println("\nRoot cause...");
            throwable.printStackTrace();
        }
        System.err.flush();
        System.out.flush();
    }

    public static synchronized void dumpThreads() {
        if (debug) {
            Debug.println("Current threads:");
            ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
            while (threadGroup.getParent() != null) {
                threadGroup = threadGroup.getParent();
            }
            Thread[] threadArray = new Thread[threadGroup.activeCount()];
            int n = threadGroup.enumerate(threadArray, true);
            int n2 = 0;
            while (n2 < n) {
                Thread thread = threadArray[n2];
                Debug.println("   " + thread.getName());
                ++n2;
            }
        }
    }

    public static synchronized String getShortThreadID() {
        String string = "0x" + Integer.toHexString(Thread.currentThread().hashCode());
        return string;
    }

    public static synchronized void print(String string) {
        if (debug) {
            System.out.println(string);
        }
    }

    public static synchronized void println(String string) {
        if (debug) {
            if (threads) {
                System.out.println(String.valueOf(Debug.getShortThreadID()) + ":" + string);
                return;
            }
            System.out.println(string);
        }
    }

    static {
        threads = true;
        oriout = System.out;
        orierr = System.err;
    }
}

