/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.file.nw.calls;

import com.novell.service.file.nw.EAEnumerator;
import com.novell.service.file.nw.ExtendedAttribute;
import com.novell.service.file.nw.NFileInputStream;
import com.novell.service.file.nw.NFileOutputStream;
import com.novell.service.file.nw.NameSpace;
import com.novell.service.file.nw.calls.LoadedEAEnumerator;
import com.novell.service.file.nw.naming.DirEntryDirContext;
import com.novell.service.file.nw.naming.ExtendedAttributeLock;
import com.novell.service.file.nw.naming.FSAttribute;
import com.novell.service.file.nw.naming.FSEnvironment;
import com.novell.service.file.nw.naming.SchemaAttrDef;
import com.novell.service.file.nw.naming.SchemaSyntaxDef;
import com.novell.service.jncp.NSIException;
import com.novell.service.rfc1960.SearchStringComponent;
import com.novell.service.session.SessionException;
import com.novell.service.session.xplat.CallsService;
import com.novell.utility.naming.directory.StaticAttributeValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.NoSuchElementException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.AttributeModificationException;
import javax.naming.directory.InvalidSearchFilterException;

public class EAEnumeratorImpl
implements StaticAttributeValue,
EAEnumerator {
    private FSEnvironment environment;
    private String fullNodeName;
    private String fullUrlName;
    private String nameSpace;
    private CallsService callsService;
    private DirEntryDirContext dataAccessable;
    private int eaHandle;
    private StringBuffer eaName;
    private int eaFFStruct;
    private boolean foundFirst = false;
    private boolean foundLast = false;
    private boolean nextOk = false;
    private EAEnumeratorImpl attributeValue;

    public EAEnumeratorImpl(FSEnvironment fSEnvironment, DirEntryDirContext dirEntryDirContext, boolean bl) throws NSIException {
        this.environment = fSEnvironment;
        this.fullNodeName = fSEnvironment.getFullNodeName();
        this.fullUrlName = fSEnvironment.getFullUrlName();
        this.nameSpace = fSEnvironment.getNameSpace();
        this.dataAccessable = dirEntryDirContext;
        try {
            this.callsService = fSEnvironment.getCallsService();
        }
        catch (NamingException namingException) {
            throw new NSIException(String.valueOf(namingException), namingException);
        }
        try {
            if (bl) {
                this.eaHandle = this.callsService.allocEAHandle();
                this.eaFFStruct = this.callsService.allocEAFFStruct();
                if (this.eaHandle == 0 || this.eaFFStruct == 0) {
                    throw new OutOfMemoryError();
                }
            }
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public EAEnumeratorImpl(FSEnvironment fSEnvironment, DirEntryDirContext dirEntryDirContext) throws NSIException {
        this(fSEnvironment, dirEntryDirContext, false);
    }

    public void finalize() {
        try {
            if (this.eaHandle != 0) {
                this.callsService.freePtr(this.eaHandle);
                this.eaHandle = 0;
            }
        }
        catch (SessionException sessionException) {}
        try {
            if (this.eaFFStruct != 0) {
                this.callsService.freePtr(this.eaFFStruct);
                this.eaFFStruct = 0;
                return;
            }
        }
        catch (SessionException sessionException) {}
    }

    public boolean hasMoreElements() {
        if (this.nextOk) {
            return true;
        }
        if (this.foundLast) {
            return false;
        }
        this.eaName = new StringBuffer();
        if (!this.foundFirst) {
            this.foundFirst = true;
            try {
                this.callsService.findFirstEA(0, this.fullNodeName, NameSpace.nameToNumber(this.nameSpace), this.eaFFStruct, this.eaHandle, this.eaName);
            }
            catch (NSIException nSIException) {
                this.finalize();
                int n = nSIException.getCCode();
                if (n == 1 || n == 35212) {
                    this.foundLast = true;
                }
                throw nSIException;
            }
            catch (SessionException sessionException) {
                this.finalize();
                throw new NSIException(sessionException.getMessage(), 0, sessionException);
            }
        } else {
            try {
                this.callsService.findNextEA(this.eaFFStruct, this.eaHandle, this.eaName);
            }
            catch (NSIException nSIException) {
                this.foundLast = true;
                this.finalize();
            }
            catch (SessionException sessionException) {
                this.finalize();
                throw new NSIException(sessionException.getMessage(), 0, sessionException);
            }
        }
        if (this.foundLast) {
            return false;
        }
        this.nextOk = true;
        return true;
    }

    public boolean hasMore() {
        return this.hasMoreElements();
    }

    public Object nextElement() {
        return this.next();
    }

    public ExtendedAttribute next() {
        if (!this.nextOk && !this.hasMoreElements()) {
            throw new NoSuchElementException();
        }
        if (this.foundLast) {
            throw new NoSuchElementException();
        }
        byte[] byArray = this.readExtendedAttribute();
        ExtendedAttribute extendedAttribute = new ExtendedAttribute(this.eaName.toString(), byArray);
        this.nextOk = false;
        return extendedAttribute;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Attribute buildAttribute() throws NamingException {
        Object object;
        EAEnumeratorImpl eAEnumeratorImpl = null;
        try {
            eAEnumeratorImpl = new EAEnumeratorImpl(this.environment, this.dataAccessable, true);
        }
        catch (NSIException nSIException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(nSIException);
            throw namingException;
        }
        Object object2 = object = ExtendedAttributeLock.getInstance(this.fullUrlName, "__JNDIReferences");
        synchronized (object2) {
            FSAttribute fSAttribute;
            try {
                try {
                    FSAttribute fSAttribute2 = new FSAttribute("Extended Attribute", eAEnumeratorImpl, new SchemaAttrDef(1, this.environment), new SchemaSyntaxDef(1, this.environment));
                    this.finalize();
                    fSAttribute = fSAttribute2;
                    Object var7_9 = null;
                }
                catch (Exception exception) {
                    NamingException namingException = new NamingException(String.valueOf(exception));
                    namingException.setRootCause(exception);
                    throw namingException;
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                ExtendedAttributeLock.releaseInstance(object);
                throw throwable;
            }
            ExtendedAttributeLock.releaseInstance(object);
            return fSAttribute;
        }
    }

    public void addAttribute(Attribute attribute) throws NamingException {
        this.modifyAttribute(attribute);
    }

    public void deleteAttribute(Attribute attribute) throws NamingException {
        throw new AttributeModificationException();
    }

    public void modifyAttribute(Attribute attribute) throws NamingException {
        NamingEnumeration<?> namingEnumeration = attribute.getAll();
        while (namingEnumeration.hasMoreElements()) {
            ExtendedAttribute extendedAttribute;
            ExtendedAttribute extendedAttribute2 = extendedAttribute = (ExtendedAttribute)namingEnumeration.nextElement();
            synchronized (extendedAttribute2) {
                this.writeExtendedAttribute(extendedAttribute.getName(), extendedAttribute.getData());
            }
        }
    }

    public String getID() {
        return "Extended Attribute";
    }

    public boolean compare(SearchStringComponent searchStringComponent) throws NamingException {
        try {
            return this.equals(searchStringComponent);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            InvalidSearchFilterException invalidSearchFilterException = new InvalidSearchFilterException();
            invalidSearchFilterException.setRootCause(illegalArgumentException);
            throw invalidSearchFilterException;
        }
    }

    public boolean equals(SearchStringComponent searchStringComponent) {
        if (searchStringComponent == null) {
            return false;
        }
        int n = searchStringComponent.getOperationType();
        if (n == 4) {
            return true;
        }
        if (n != 0 && n != 5) {
            return false;
        }
        ExtendedAttribute extendedAttribute = null;
        boolean bl = true;
        if (searchStringComponent.operandReplacement()) {
            extendedAttribute = (ExtendedAttribute)searchStringComponent.getReplacementObject();
            bl = false;
            if (extendedAttribute == null) {
                throw new IllegalArgumentException(searchStringComponent.getOperation());
            }
        } else {
            extendedAttribute = new ExtendedAttribute(searchStringComponent.getOperand());
        }
        if (n == 0) {
            Object object = extendedAttribute;
            synchronized (object) {
                this.eaName = new StringBuffer(extendedAttribute.getName());
            }
            object = null;
            try {
                object = this.readExtendedAttribute();
            }
            catch (NSIException nSIException) {
                return false;
            }
            boolean bl2 = false;
            if (bl) {
                bl2 = true;
            } else {
                try {
                    ExtendedAttribute extendedAttribute2 = extendedAttribute;
                    synchronized (extendedAttribute2) {
                        bl2 = extendedAttribute.equals(object);
                    }
                }
                catch (Exception exception) {
                    bl2 = false;
                }
            }
            return bl2;
        }
        if (n == 5) {
            EAEnumeratorImpl eAEnumeratorImpl = null;
            eAEnumeratorImpl = new EAEnumeratorImpl(this.environment, this.dataAccessable, true);
            while (eAEnumeratorImpl.hasMoreElements()) {
                ExtendedAttribute extendedAttribute3 = eAEnumeratorImpl.next();
                ExtendedAttribute extendedAttribute4 = extendedAttribute;
                synchronized (extendedAttribute4) {
                    if (SearchStringComponent.compareSubString(extendedAttribute.getName(), extendedAttribute3.getName(), true)) {
                        boolean bl3 = true;
                        Object var9_12 = null;
                        return bl3;
                    }
                }
            }
            return false;
        }
        return false;
    }

    public Object getStaticInterface() {
        EAEnumeratorImpl eAEnumeratorImpl = new EAEnumeratorImpl(this.environment, this.dataAccessable, true);
        Object object = ExtendedAttributeLock.getInstance(this.fullUrlName, "__JNDIReferences");
        LoadedEAEnumerator loadedEAEnumerator = null;
        Object object2 = object;
        synchronized (object2) {
            try {
                loadedEAEnumerator = new LoadedEAEnumerator(eAEnumeratorImpl);
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                ExtendedAttributeLock.releaseInstance(object);
                throw throwable;
            }
            ExtendedAttributeLock.releaseInstance(object);
        }
        return loadedEAEnumerator;
    }

    private void writeExtendedAttribute(String string, byte[] byArray) throws NamingException {
        OutputStream outputStream = null;
        boolean bl = false;
        try {
            outputStream = new NFileOutputStream(string, this.dataAccessable, 0, 255);
            bl = true;
            outputStream.write(byArray);
            outputStream.close();
            bl = false;
            return;
        }
        catch (IOException iOException) {
            if (bl) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException2) {}
            }
            throw new NSIException(iOException.getMessage(), iOException);
        }
    }

    private byte[] readExtendedAttribute() {
        InputStream inputStream = null;
        boolean bl = false;
        byte[] byArray = new byte[4096];
        byte[] byArray2 = null;
        int n = 0;
        try {
            int n2;
            inputStream = new NFileInputStream(this.eaName.toString(), this.dataAccessable, 0, 255);
            bl = true;
            byte[] byArray3 = null;
            do {
                int n3;
                if ((n2 = inputStream.read(byArray)) == -1) continue;
                if (n2 == byArray.length && byArray2 == null) {
                    byArray2 = new byte[byArray.length];
                    n3 = 0;
                    while (n3 < byArray.length) {
                        byArray2[n3] = byArray[n3];
                        ++n3;
                    }
                } else if (byArray2 != null) {
                    byArray3 = byArray2;
                    byArray2 = new byte[byArray3.length + n2];
                    n3 = 0;
                    while (n3 < byArray3.length) {
                        byArray2[n3] = byArray3[n3];
                        ++n3;
                    }
                    int n4 = 0;
                    while (n4 < n2) {
                        byArray2[n3 + n4] = byArray[n4];
                        ++n4;
                    }
                } else {
                    n = n2;
                }
            } while (n2 != -1);
            inputStream.close();
            bl = false;
        }
        catch (IOException iOException) {
            if (bl) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException2) {}
            }
            throw new NSIException(iOException.getMessage(), iOException);
        }
        if (byArray2 != null) {
            return byArray2;
        }
        byArray2 = new byte[n];
        int n5 = 0;
        while (n5 < n) {
            byArray2[n5] = byArray[n5];
            ++n5;
        }
        return byArray2;
    }
}

