/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.file.nw.calls;

import com.novell.java.io.spi.DataAccessor;
import com.novell.service.session.Session;
import com.novell.service.session.SessionException;
import com.novell.service.session.xplat.DeviceAccessService;
import java.io.IOException;

public class NativeDeviceAccessor
implements DataAccessor {
    private static final int SEEK_SET = 0;
    private static final int SEEK_CUR = 1;
    private static final int SEEK_END = 2;
    private static final String serviceKey = "com.novell.service.session.xplat.DeviceAccessService.4461766964";
    protected boolean closed;
    protected int handle;
    private boolean doNotFlush;
    private DeviceAccessService service;

    public NativeDeviceAccessor(int n, Session session, boolean bl) throws IOException {
        try {
            this.closed = false;
            this.service = (DeviceAccessService)session.getService(serviceKey);
            this.handle = n;
            this.doNotFlush = bl;
            return;
        }
        catch (SessionException sessionException) {
            throw new IOException(sessionException.getMessage());
        }
    }

    protected synchronized void finalize() throws IOException {
        if (!this.closed) {
            this.close();
        }
    }

    public synchronized int available() throws IOException {
        if (this.closed) {
            throw new IOException("NativeDeviceAccessor::available-closed");
        }
        try {
            int n = this.service.getLength(this.handle);
            int n2 = this.service.getPosition(this.handle);
            return n - n2;
        }
        catch (SessionException sessionException) {
            throw new IOException(sessionException.getMessage());
        }
    }

    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.flush();
        try {
            try {
                this.service.close(this.handle);
            }
            catch (SessionException sessionException) {
                throw new IOException(sessionException.getMessage());
            }
            Object var2_2 = null;
            this.closed = true;
            return;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.closed = true;
            throw throwable;
        }
    }

    public synchronized void flush() throws IOException {
        if (this.closed) {
            throw new IOException("NativeDeviceAccessor::flush-closed");
        }
        if (this.doNotFlush) {
            return;
        }
        try {
            this.service.flush(this.handle);
            return;
        }
        catch (SessionException sessionException) {
            throw new IOException(sessionException.getMessage());
        }
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int n) {
    }

    public synchronized int read() throws IOException {
        if (this.closed) {
            throw new IOException("NativeDeviceAccessor::read-closed");
        }
        try {
            byte[] byArray = this.service.read(this.handle, 1);
            if (byArray.length == 0) {
                return -1;
            }
            return byArray[0] & 0xFF;
        }
        catch (SessionException sessionException) {
            throw new IOException(sessionException.getMessage());
        }
    }

    public synchronized int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException("NativeDeviceAccessor::read-closed");
        }
        if (n2 <= 0) {
            return 0;
        }
        try {
            byte[] byArray2 = this.service.read(this.handle, n2);
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
            if (byArray2.length == 0) {
                return -1;
            }
            return byArray2.length;
        }
        catch (SessionException sessionException) {
            throw new IOException(sessionException.getMessage());
        }
    }

    public synchronized void write(int n) throws IOException {
        if (this.closed) {
            throw new IOException("NativeDeviceAccessor::write-closed");
        }
        try {
            this.service.write(this.handle, new byte[]{(byte)n});
            return;
        }
        catch (SessionException sessionException) {
            throw new IOException(sessionException.getMessage());
        }
    }

    public synchronized void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException("NativeDeviceAccessor::write-closed");
        }
        try {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            this.service.write(this.handle, byArray2);
            return;
        }
        catch (SessionException sessionException) {
            throw new IOException(sessionException.getMessage());
        }
    }

    public synchronized void reset() throws IOException {
        throw new IOException();
    }

    public synchronized long skip(long l) throws IOException {
        if (this.closed) {
            throw new IOException("NativeDeviceAccessor::skip-closed");
        }
        try {
            int n = this.service.getPosition(this.handle);
            this.service.setPosition(this.handle, 1, (int)l);
            int n2 = this.service.getPosition(this.handle);
            return n2 - n;
        }
        catch (SessionException sessionException) {
            throw new IOException(sessionException.getMessage());
        }
    }

    public synchronized long length() throws IOException {
        if (this.closed) {
            throw new IOException("NativeDeviceAccessor::length-closed");
        }
        this.flush();
        try {
            int n = this.service.getLength(this.handle);
            return n;
        }
        catch (SessionException sessionException) {
            throw new IOException(sessionException.getMessage());
        }
    }

    public synchronized long seek(long l) throws IOException {
        if (this.closed) {
            throw new IOException("NativeDeviceAccessor::seek-closed");
        }
        try {
            this.service.setPosition(this.handle, 0, (int)l);
            return l;
        }
        catch (SessionException sessionException) {
            throw new IOException(sessionException.getMessage());
        }
    }

    public synchronized void setLength(long l) throws IOException {
        if (this.closed) {
            throw new IOException("NativeDeviceAccessor::setLength-closed");
        }
        try {
            this.service.setLength(this.handle, (int)l);
            return;
        }
        catch (SessionException sessionException) {
            throw new IOException(sessionException.getMessage());
        }
    }
}

