/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.file.nw.calls;

import com.novell.service.file.nw.VolumeRestriction;
import com.novell.service.file.nw.VolumeRestrictionEnumerator;
import com.novell.service.file.nw.calls.ObjectName;
import com.novell.service.file.nw.calls.ObjectNameImpl;
import com.novell.service.file.nw.naming.FSAttribute;
import com.novell.service.file.nw.naming.FSEnvironment;
import com.novell.service.file.nw.naming.SchemaAttrDef;
import com.novell.service.file.nw.naming.SchemaSyntaxDef;
import com.novell.service.jncp.NSIException;
import com.novell.service.jncpv2.net.NetService;
import com.novell.service.rfc1960.SearchStringComponent;
import com.novell.service.session.SessionException;
import com.novell.service.session.xplat.CallsService;
import com.novell.utility.naming.directory.StaticAttributeValue;
import java.util.NoSuchElementException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.AttributeModificationException;
import javax.naming.directory.InvalidSearchFilterException;

public class VolumeRestrictionEnumeratorImpl
implements VolumeRestrictionEnumerator,
StaticAttributeValue {
    private FSEnvironment environment;
    private String fullNodeName;
    private String nameSpace;
    private String volumeName;
    private NetService netService;
    private CallsService callsService;
    private boolean sessionIsNDS;
    private boolean userIsSet = false;
    private String user;
    private int runningIteration;
    private int iterHandle;
    private int entryCount;
    private boolean nextOk = false;
    private int numberOfEntries;
    private VolumeRestriction[] vRestrictions = new VolumeRestriction[16];
    private int volumeNumber = -1;
    private boolean realThing = false;
    private boolean startedEnum = false;
    private boolean finished = false;
    private int entryPos;
    private VolumeRestriction nextRestriction;
    private VolumeRestrictionEnumeratorImpl attributeValue;

    public VolumeRestrictionEnumeratorImpl(FSEnvironment fSEnvironment, boolean bl) throws NSIException {
        this.environment = fSEnvironment;
        this.fullNodeName = fSEnvironment.getFullNodeName();
        this.nameSpace = fSEnvironment.getNameSpace();
        this.volumeName = fSEnvironment.getVolumeName();
        try {
            this.callsService = fSEnvironment.getCallsService();
            this.netService = fSEnvironment.getNetService();
            this.sessionIsNDS = fSEnvironment.sessionIsNDS();
        }
        catch (NamingException namingException) {
            throw new NSIException(String.valueOf(namingException), namingException);
        }
        this.realThing = bl;
        if (!bl) {
            this.finished = true;
        }
    }

    public VolumeRestrictionEnumeratorImpl(FSEnvironment fSEnvironment) throws NSIException {
        this(fSEnvironment, false);
    }

    public boolean hasMoreElements() {
        if (this.finished) {
            return false;
        }
        if (this.userIsSet) {
            return true;
        }
        if (this.nextOk) {
            return true;
        }
        if (this.entryPos < this.entryCount) {
            this.nextRestriction = this.vRestrictions[this.entryPos++];
            this.nextRestriction.setObjectId(ObjectNameImpl.swap32(this.nextRestriction.getObjectId()));
            this.nextOk = true;
            return true;
        }
        boolean bl = this.finished = !this.scanNextRestrictionGroup();
        if (!this.finished) {
            this.nextRestriction = this.vRestrictions[this.entryPos++];
            this.nextRestriction.setObjectId(ObjectNameImpl.swap32(this.nextRestriction.getObjectId()));
            this.nextOk = true;
            return true;
        }
        return false;
    }

    public boolean hasMore() {
        return this.hasMoreElements();
    }

    public Object nextElement() {
        return this.next();
    }

    public VolumeRestriction next() {
        if (!this.startedEnum) {
            this.hasMoreElements();
        }
        if (this.finished) {
            throw new NoSuchElementException();
        }
        if (this.userIsSet) {
            this.finished = true;
            int n = ObjectNameImpl.nameToObjectId(this.user, this.callsService, this.netService, this.sessionIsNDS);
            this.nextRestriction = new VolumeRestriction();
            this.nextRestriction.setName(this.user);
            this.nextRestriction.setObjectId(n);
        } else {
            if (!this.nextOk) {
                throw new NoSuchElementException();
            }
            ObjectName objectName = ObjectNameImpl.objectIdToObjectName(this.nextRestriction.getObjectId(), this.callsService, this.netService, this.sessionIsNDS);
            this.nextRestriction.setName(objectName.getName());
        }
        try {
            this.callsService.getObjDiskRestrictions(this.getVolumeNumber(), this.nextRestriction.getObjectId(), this.nextRestriction);
        }
        catch (SessionException sessionException) {
            throw new NSIException(sessionException.getMessage(), 0, sessionException);
        }
        VolumeRestriction volumeRestriction = this.nextRestriction;
        this.nextOk = false;
        this.hasMoreElements();
        return volumeRestriction;
    }

    public void setUser(String string) {
        this.user = string;
        this.userIsSet = true;
        if (this.realThing) {
            this.finished = false;
        }
    }

    public Attribute buildAttribute() throws NamingException {
        VolumeRestrictionEnumeratorImpl volumeRestrictionEnumeratorImpl = null;
        try {
            volumeRestrictionEnumeratorImpl = new VolumeRestrictionEnumeratorImpl(this.environment, true);
        }
        catch (NSIException nSIException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(nSIException);
            throw namingException;
        }
        return new FSAttribute("Volume Restriction", volumeRestrictionEnumeratorImpl, new SchemaAttrDef(6, this.environment), new SchemaSyntaxDef(6, this.environment));
    }

    public void addAttribute(Attribute attribute) throws NamingException {
        NamingEnumeration<?> namingEnumeration = attribute.getAll();
        while (namingEnumeration.hasMoreElements()) {
            VolumeRestriction volumeRestriction;
            VolumeRestriction volumeRestriction2 = volumeRestriction = (VolumeRestriction)namingEnumeration.nextElement();
            synchronized (volumeRestriction2) {
                int n;
                try {
                    n = ObjectNameImpl.nameToObjectId(volumeRestriction.getName(), this.callsService, this.netService, this.sessionIsNDS);
                }
                catch (NSIException nSIException) {
                    AttributeModificationException attributeModificationException = new AttributeModificationException(nSIException.getMessage());
                    attributeModificationException.setRootCause(nSIException);
                    throw attributeModificationException;
                }
                try {
                    this.callsService.setObjectVolSpaceLimit(this.getVolumeNumber(), n, volumeRestriction.getRestriction());
                }
                catch (NSIException nSIException) {
                    AttributeModificationException attributeModificationException = new AttributeModificationException(nSIException.getMessage());
                    attributeModificationException.setRootCause(nSIException);
                    throw attributeModificationException;
                }
                catch (SessionException sessionException) {
                    AttributeModificationException attributeModificationException = new AttributeModificationException(sessionException.getMessage());
                    attributeModificationException.setRootCause(sessionException);
                    throw attributeModificationException;
                }
            }
        }
    }

    public void deleteAttribute(Attribute attribute) throws NamingException {
        NamingEnumeration<?> namingEnumeration = attribute.getAll();
        while (namingEnumeration.hasMoreElements()) {
            VolumeRestriction volumeRestriction;
            VolumeRestriction volumeRestriction2 = volumeRestriction = (VolumeRestriction)namingEnumeration.nextElement();
            synchronized (volumeRestriction2) {
                int n;
                try {
                    n = ObjectNameImpl.nameToObjectId(volumeRestriction.getName(), this.callsService, this.netService, this.sessionIsNDS);
                }
                catch (NSIException nSIException) {
                    AttributeModificationException attributeModificationException = new AttributeModificationException(nSIException.getMessage());
                    attributeModificationException.setRootCause(nSIException);
                    throw attributeModificationException;
                }
                try {
                    this.callsService.removeObjectDiskRestrictions(this.getVolumeNumber(), n);
                }
                catch (NSIException nSIException) {
                    AttributeModificationException attributeModificationException = new AttributeModificationException(nSIException.getMessage());
                    attributeModificationException.setRootCause(nSIException);
                    throw attributeModificationException;
                }
                catch (SessionException sessionException) {
                    AttributeModificationException attributeModificationException = new AttributeModificationException(sessionException.getMessage());
                    attributeModificationException.setRootCause(sessionException);
                    throw attributeModificationException;
                }
            }
        }
    }

    public void modifyAttribute(Attribute attribute) throws NamingException {
        this.addAttribute(attribute);
    }

    public String getID() {
        return "Volume Restriction";
    }

    public boolean compare(SearchStringComponent searchStringComponent) throws NamingException {
        try {
            return this.equals(searchStringComponent);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            InvalidSearchFilterException invalidSearchFilterException = new InvalidSearchFilterException();
            invalidSearchFilterException.setRootCause(illegalArgumentException);
            throw invalidSearchFilterException;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(SearchStringComponent searchStringComponent) {
        if (searchStringComponent == null) {
            return false;
        }
        int n = searchStringComponent.getOperationType();
        if (n == 4) {
            return true;
        }
        if (n != 0 && n != 5) {
            return false;
        }
        VolumeRestriction volumeRestriction = null;
        boolean bl = true;
        if (searchStringComponent.operandReplacement()) {
            volumeRestriction = (VolumeRestriction)searchStringComponent.getReplacementObject();
            bl = false;
            if (volumeRestriction == null) {
                throw new IllegalArgumentException(searchStringComponent.getOperation());
            }
        } else {
            volumeRestriction = new VolumeRestriction(searchStringComponent.getOperand());
        }
        VolumeRestrictionEnumeratorImpl volumeRestrictionEnumeratorImpl = null;
        volumeRestrictionEnumeratorImpl = new VolumeRestrictionEnumeratorImpl(this.environment, true);
        while (volumeRestrictionEnumeratorImpl.hasMoreElements()) {
            VolumeRestriction volumeRestriction2;
            VolumeRestriction volumeRestriction3 = volumeRestrictionEnumeratorImpl.next();
            if (n == 0) {
                volumeRestriction2 = volumeRestriction;
                synchronized (volumeRestriction2) {
                    if (bl && volumeRestriction3.getName().equalsIgnoreCase(volumeRestriction.getName())) {
                        return false;
                    }
                    try {
                        if (volumeRestriction3.equals(volumeRestriction)) {
                            return true;
                        }
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
            }
            if (n != 5) return false;
            volumeRestriction2 = volumeRestriction;
            synchronized (volumeRestriction2) {
                if (SearchStringComponent.compareSubString(volumeRestriction.getName(), volumeRestriction3.getName(), true)) {
                    return true;
                }
            }
        }
        return false;
    }

    public Object getStaticInterface() {
        VolumeRestrictionEnumeratorImpl volumeRestrictionEnumeratorImpl = new VolumeRestrictionEnumeratorImpl(this.environment, true);
        return volumeRestrictionEnumeratorImpl;
    }

    private boolean scanNextRestrictionGroup() {
        this.startedEnum = true;
        int n = this.getVolumeNumber();
        this.iterHandle = this.runningIteration;
        int n2 = 0;
        while (n2 < this.vRestrictions.length) {
            this.vRestrictions[n2] = new VolumeRestriction();
            ++n2;
        }
        try {
            this.callsService.scanVolDiskRestrictions2(n, this);
        }
        catch (SessionException sessionException) {
            throw new NSIException(sessionException.getMessage(), 0, sessionException);
        }
        if (this.entryCount == 0) {
            return false;
        }
        this.entryPos = 0;
        this.runningIteration += this.entryCount;
        return true;
    }

    private int getVolumeNumber() throws NSIException {
        if (this.volumeNumber != -1) {
            return this.volumeNumber;
        }
        int[] nArray = new int[1];
        try {
            this.callsService.getVolumeNumber(this.volumeName, nArray);
        }
        catch (SessionException sessionException) {
            throw new NSIException(sessionException.getMessage(), 0, sessionException);
        }
        this.volumeNumber = nArray[0];
        return nArray[0];
    }
}

