/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.file.nw.naming;

import com.novell.service.file.nw.NameSpace;
import com.novell.service.file.nw.calls.DirectoryEntryInfoImpl;
import com.novell.service.file.nw.naming.DirectoryDirContext;
import com.novell.service.file.nw.naming.FSEnvironment;
import com.novell.service.jncp.NSIException;
import com.novell.service.session.SessionException;
import com.novell.service.session.xplat.CallsService;
import java.util.NoSuchElementException;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

class DirEntryNCEnumerator
implements NamingEnumeration {
    public static final String fileClass = "com.novell.service.file.nw.naming.FileDirContext";
    public static final String dirClass = "com.novell.service.file.nw.naming.DirectoryDirContext";
    private String fullNodePattern;
    private int nameSpaceNumber;
    private NameClassPair save;
    private boolean finished = false;
    private int[] scanAttrs = new int[]{23, 7};
    private int currAttr = -1;
    private int[] volNumber = new int[1];
    private int[] dirNumber = new int[1];
    private int[] searchDirNumber = new int[1];
    private DirectoryEntryInfoImpl info;
    private CallsService callsService;

    public DirEntryNCEnumerator(DirectoryDirContext directoryDirContext, FSEnvironment fSEnvironment) throws NSIException {
        String string = fSEnvironment.getListFilter();
        this.nameSpaceNumber = NameSpace.nameToNumber(fSEnvironment.getNameSpace());
        if (this.nameSpaceNumber == 0) {
            string = string.toUpperCase();
        }
        this.fullNodePattern = directoryDirContext.addPath(string);
        this.info = new DirectoryEntryInfoImpl(fSEnvironment);
        try {
            this.callsService = fSEnvironment.getCallsService();
        }
        catch (NamingException namingException) {
            throw new NSIException(String.valueOf(namingException), namingException);
        }
        this.scanNextAttr();
        this.save = this.scanNextDirEntry();
        if (this.save == null) {
            this.finished = true;
        }
    }

    public boolean hasMoreElements() {
        return !this.finished;
    }

    public boolean hasMore() throws NamingException {
        return !this.finished;
    }

    public Object nextElement() {
        try {
            return this.next();
        }
        catch (NamingException namingException) {
            Throwable throwable = namingException.getRootCause();
            if (throwable instanceof NSIException) {
                throw (NSIException)throwable;
            }
            throw new RuntimeException(namingException.getMessage());
        }
    }

    public Object next() throws NamingException {
        if (this.finished) {
            throw new NoSuchElementException();
        }
        NameClassPair nameClassPair = this.save;
        try {
            this.save = this.scanNextDirEntry();
        }
        catch (NSIException nSIException) {
            throw new NoSuchElementException();
        }
        if (this.save == null) {
            this.finished = true;
        }
        return nameClassPair;
    }

    private NameClassPair scanNextDirEntry() throws NSIException {
        try {
            this.callsService.scanNSEntryInfo(0, this.nameSpaceNumber, this.scanAttrs[this.currAttr], this.volNumber, this.dirNumber, this.searchDirNumber, this.fullNodePattern, 5, this.info);
        }
        catch (NSIException nSIException) {
            int n = nSIException.getCCode();
            if (n == 35327) {
                if (!this.scanNextAttr()) {
                    return null;
                }
                return this.scanNextDirEntry();
            }
            throw nSIException;
        }
        catch (SessionException sessionException) {
            throw new NSIException(sessionException.getMessage(), 0, sessionException);
        }
        int n = 16;
        return new NameClassPair(this.info.getEntryName(), (this.info.getAttributes() & n) != 0 ? dirClass : fileClass, true);
    }

    private boolean scanNextAttr() {
        if (this.currAttr + 1 >= this.scanAttrs.length) {
            return false;
        }
        this.searchDirNumber[0] = -1;
        ++this.currAttr;
        return true;
    }

    public void close() throws NamingException {
    }
}

