/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.file.nw.naming;

import com.novell.service.file.nw.DirectoryEntryInformation;
import com.novell.service.file.nw.DirectorySpaceInformation;
import com.novell.service.file.nw.EffectiveRights;
import com.novell.service.file.nw.ExtendedAttribute;
import com.novell.service.file.nw.Trustee;
import com.novell.service.file.nw.VolumeInformation;
import com.novell.service.file.nw.VolumeRestriction;
import com.novell.service.file.nw.VolumeUtilization;
import com.novell.service.file.nw.naming.FSEnvironment;
import com.novell.service.file.nw.naming.FileSystemNameParser;
import com.novell.service.file.nw.naming.SchemaSDBindingEnumerator;
import com.novell.service.file.nw.naming.SchemaSDNCEnumerator;
import com.novell.utility.naming.NamingEnumerator;
import com.novell.utility.naming.directory.NAttributes;
import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.AttributeModificationException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;

public class SchemaSyntaxDef
implements DirContext {
    private String[] nodesAttrIds;
    private boolean staticSchemaTree = true;
    private int contextType = -1;
    private String syntaxName;
    private String[] customId;
    private String[] customValue;
    private String distinguishedName = "Syntaxes";
    private FSEnvironment environment;

    public SchemaSyntaxDef(FSEnvironment fSEnvironment) {
        this.environment = fSEnvironment;
    }

    public SchemaSyntaxDef(int n, FSEnvironment fSEnvironment) {
        this(fSEnvironment);
        this.staticSchemaTree = false;
        this.contextType = n;
        switch (this.contextType) {
            case 0: {
                this.syntaxName = "Entry Information Definition";
                this.customId = new String[1];
                this.customValue = new String[1];
                this.customId[0] = "compares";
                this.customValue[0] = DirectoryEntryInformation.COMPARE_SYNTAX_STRING;
                break;
            }
            case 1: {
                this.syntaxName = "Extended Attribute Definition";
                this.customId = new String[1];
                this.customValue = new String[1];
                this.customId[0] = "compares";
                this.customValue[0] = ExtendedAttribute.COMPARE_SYNTAX_STRING;
                break;
            }
            case 2: {
                this.syntaxName = "Trustee Definition";
                this.customId = new String[1];
                this.customValue = new String[1];
                this.customId[0] = "compares";
                this.customValue[0] = Trustee.COMPARE_SYNTAX_STRING;
                break;
            }
            case 3: {
                this.syntaxName = "Directory Space Information Definition";
                this.customId = new String[1];
                this.customValue = new String[1];
                this.customId[0] = "compares";
                this.customValue[0] = DirectorySpaceInformation.COMPARE_SYNTAX_STRING;
                break;
            }
            case 4: {
                this.syntaxName = "Volume Information Definition";
                this.customId = new String[1];
                this.customValue = new String[1];
                this.customId[0] = "compares";
                this.customValue[0] = VolumeInformation.COMPARE_SYNTAX_STRING;
                break;
            }
            case 5: {
                this.syntaxName = "Volume Utilization Definition";
                this.customId = new String[1];
                this.customValue = new String[1];
                this.customId[0] = "compares";
                this.customValue[0] = VolumeUtilization.COMPARE_SYNTAX_STRING;
                break;
            }
            case 6: {
                this.syntaxName = "Volume Restriction Definition";
                this.customId = new String[1];
                this.customValue = new String[1];
                this.customId[0] = "compares";
                this.customValue[0] = VolumeRestriction.COMPARE_SYNTAX_STRING;
                break;
            }
            case 7: {
                this.syntaxName = "Effective Rights Definition";
                this.customId = new String[1];
                this.customValue = new String[1];
                this.customId[0] = "compares";
                this.customValue[0] = EffectiveRights.COMPARE_SYNTAX_STRING;
                break;
            }
        }
        this.distinguishedName = "Syntaxes/" + this.syntaxName;
    }

    public int getContextType() {
        return this.contextType;
    }

    public String getNameInNamespace() throws NamingException {
        return this.distinguishedName;
    }

    public NamingEnumeration list(String string) throws NamingException {
        if (string == null || string.length() == 0) {
            NamingEnumeration namingEnumeration = null;
            namingEnumeration = this.staticSchemaTree ? new SchemaSDNCEnumerator() : new NamingEnumerator();
            return namingEnumeration;
        }
        return (NamingEnumeration)this.objectFromName(string, 0);
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        if (string == null || string.length() == 0) {
            NamingEnumeration namingEnumeration = null;
            namingEnumeration = this.staticSchemaTree ? new SchemaSDBindingEnumerator(this.environment) : new NamingEnumerator();
            return namingEnumeration;
        }
        return (NamingEnumeration)this.objectFromName(string, 1);
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public Object lookup(String string) throws NamingException {
        if (string == null || string.length() == 0) {
            return this;
        }
        return this.objectFromName(string, 2);
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public NameParser getNameParser(String string) throws NamingException {
        if (string == null || string.length() == 0) {
            return new FileSystemNameParser(this.environment.getServerName(), true);
        }
        return (NameParser)this.objectFromName(string, 4);
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    public String composeName(String string, String string2) throws NamingException {
        Name name = this.composeName(new CompositeName(string), new CompositeName(string2));
        return name.toString();
    }

    public Name composeName(Name name, Name name2) throws NamingException {
        Name name3 = (Name)name2.clone();
        if (name == null) {
            return name3;
        }
        name3.addAll(name);
        return name3;
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.environment.getEnvironment(true);
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        return this.environment.addToEnvironment(string, object);
    }

    public Object removeFromEnvironment(String string) throws NamingException {
        return this.environment.removeFromEnvironment(string);
    }

    public void bind(String string, Object object) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void bind(Name name, Object object) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rebind(String string, Object object) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rebind(Name name, Object object) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void unbind(String string) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void unbind(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rename(String string, String string2) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rename(Name name, Name name2) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void destroySubcontext(String string) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void destroySubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Context createSubcontext(String string) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Context createSubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Object lookupLink(String string) throws NamingException {
        return this.lookup(string);
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    public void close() throws NamingException {
    }

    public Attributes getAttributes(String string) throws NamingException {
        return this.getAttributes(string, null);
    }

    public Attributes getAttributes(Name name) throws NamingException {
        return this.getAttributes(name.toString(), null);
    }

    public Attributes getAttributes(String string, String[] stringArray) throws NamingException {
        if (string == null || string.length() == 0) {
            NAttributes nAttributes = new NAttributes(true);
            if (this.staticSchemaTree) {
                return nAttributes;
            }
            if (stringArray == null) {
                if (this.customId != null) {
                    int n = 0;
                    while (n < this.customId.length) {
                        BasicAttribute basicAttribute = new BasicAttribute(this.customId[n]);
                        basicAttribute.add(new String(this.customValue[n]));
                        nAttributes.put(basicAttribute);
                        ++n;
                    }
                }
            } else {
                int n = 0;
                while (n < stringArray.length) {
                    int n2 = 0;
                    while (n2 < this.customId.length) {
                        if (stringArray[n].equalsIgnoreCase(this.customId[n2])) {
                            BasicAttribute basicAttribute = new BasicAttribute(this.customId[n2]);
                            basicAttribute.add(new String(this.customValue[n2]));
                            nAttributes.put(basicAttribute);
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
            return nAttributes;
        }
        return (Attributes)this.objectFromName(string, 3);
    }

    public Attributes getAttributes(Name name, String[] stringArray) throws NamingException {
        return this.getAttributes(name.toString(), stringArray);
    }

    public void modifyAttributes(String string, int n, Attributes attributes) throws NamingException {
        throw new AttributeModificationException();
    }

    public void modifyAttributes(Name name, int n, Attributes attributes) throws NamingException {
        throw new AttributeModificationException();
    }

    public void modifyAttributes(String string, ModificationItem[] modificationItemArray) throws NamingException {
        throw new AttributeModificationException();
    }

    public void modifyAttributes(Name name, ModificationItem[] modificationItemArray) throws NamingException {
        throw new AttributeModificationException();
    }

    public void bind(String string, Object object, Attributes attributes) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void bind(Name name, Object object, Attributes attributes) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rebind(String string, Object object, Attributes attributes) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rebind(Name name, Object object, Attributes attributes) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public DirContext createSubcontext(String string, Attributes attributes) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public DirContext createSubcontext(Name name, Attributes attributes) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public DirContext getSchema(String string) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public DirContext getSchema(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public DirContext getSchemaClassDefinition(String string) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration search(String string, Attributes attributes) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration search(Name name, Attributes attributes) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration search(String string, Attributes attributes, String[] stringArray) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration search(Name name, Attributes attributes, String[] stringArray) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration search(String string, String string2, SearchControls searchControls) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration search(Name name, String string, SearchControls searchControls) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration search(String string, String string2, Object[] objectArray, SearchControls searchControls) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration search(Name name, String string, Object[] objectArray, SearchControls searchControls) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public static int typeFromName(String string) {
        int n = 0;
        while (n < SchemaSDNCEnumerator.names.length) {
            if (SchemaSDNCEnumerator.names[n].equalsIgnoreCase(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static Object getEnumeration(int n, FSEnvironment fSEnvironment) throws NamingException {
        if (n == 0) {
            return new SchemaSDNCEnumerator();
        }
        if (n == 1) {
            return new SchemaSDBindingEnumerator(fSEnvironment);
        }
        throw new InvalidNameException();
    }

    private Object objectFromName(String string, int n) throws NamingException {
        int n2 = SchemaSyntaxDef.typeFromName(string);
        if (n2 == -1) {
            throw new NameNotFoundException();
        }
        switch (n) {
            case 0: {
                return new NamingEnumerator();
            }
            case 1: {
                return new NamingEnumerator();
            }
            case 2: 
            case 3: {
                SchemaSyntaxDef schemaSyntaxDef = new SchemaSyntaxDef(n2, this.environment);
                if (n == 2) {
                    return schemaSyntaxDef;
                }
                return schemaSyntaxDef.getAttributes("");
            }
            case 4: {
                return new FileSystemNameParser(this.environment.getServerName(), true);
            }
        }
        throw new InvalidNameException();
    }
}

