/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.jncp;

import com.novell.service.jncp.ClientException;
import com.novell.service.jncp.NDSException;
import com.novell.service.jncp.NSIException;
import com.novell.service.jncp.ServerException;
import com.novell.service.jncp.ServerRequesterException;

public class NSIExceptionBuilder {
    private static boolean isNetWare;

    public static NSIException build(int n) {
        String string = "ccode = " + n + " (0x" + Integer.toHexString(n) + ")";
        NSIException nSIException = (n & 0xFF00) == 34816 ? new ClientException(string) : ((n & 0xFF00) == 35072 ? (isNetWare && n > 35072 && n < 35096 ? new ServerRequesterException(string) : new ServerException(string)) : (n < 0 ? new NDSException(string) : new NSIException(string)));
        nSIException.setCCode(n);
        return nSIException;
    }

    public static NSIException build(Throwable throwable) {
        String string = "Caught exception";
        NSIException nSIException = throwable instanceof ClientException ? new ClientException(string) : (throwable instanceof ServerRequesterException ? new ServerRequesterException(string) : (throwable instanceof ServerException ? new ServerException(string) : (throwable instanceof NDSException ? new NDSException(string) : new NSIException(string))));
        nSIException.setRootCause(throwable);
        return nSIException;
    }

    public static NSIException build(int n, Throwable throwable) {
        NSIException nSIException = NSIExceptionBuilder.build(n);
        nSIException.setRootCause(throwable);
        return nSIException;
    }

    static {
        try {
            String string = System.getProperty("os.name", "");
            if (string.startsWith("NetWare")) {
                isNetWare = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }
}

