/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.jncpv2.net;

import com.novell.java.io.EndianInputStream;
import com.novell.service.jncp.NSIException;
import com.novell.service.jncpv2.net.NetAsn1ID;
import com.novell.service.nds.NdsClassDefinitionInfo;
import java.io.IOException;
import java.io.Serializable;

public final class NetClassInfo
implements NdsClassDefinitionInfo,
Serializable {
    private int type;
    private String className;
    private int classFlags;
    private byte[] id;
    private String[] superClasses;
    private String[] containmentClasses;
    private String[] namingAttributes;
    private String[] mandatoryAttributes;
    private String[] optionalAttributes;
    private int flags;
    private NetAsn1ID asn1ID;

    public NetClassInfo() {
        this.asn1ID = new NetAsn1ID();
    }

    public NetClassInfo(int n, NetAsn1ID netAsn1ID) {
        this.flags = n;
        this.asn1ID = netAsn1ID;
    }

    public NetClassInfo(EndianInputStream endianInputStream, int n) throws NSIException {
        this.type = n;
        try {
            int n2;
            endianInputStream.align32();
            endianInputStream.readLoHiInt();
            this.className = endianInputStream.readLoHiChars();
            if (n == 0) {
                return;
            }
            endianInputStream.align32();
            this.classFlags = endianInputStream.readLoHiInt();
            int n3 = endianInputStream.readLoHiInt();
            this.id = new byte[n3];
            endianInputStream.readFully(this.id);
            if (n == 3) {
                return;
            }
            endianInputStream.align32();
            int n4 = endianInputStream.readLoHiInt();
            if (n4 > 0) {
                this.superClasses = new String[n4];
                n2 = 0;
                while (n2 < n4) {
                    endianInputStream.align32();
                    endianInputStream.readLoHiInt();
                    this.superClasses[n2] = endianInputStream.readLoHiChars();
                    ++n2;
                }
            }
            endianInputStream.align32();
            n4 = endianInputStream.readLoHiInt();
            if (n4 > 0) {
                this.containmentClasses = new String[n4];
                n2 = 0;
                while (n2 < n4) {
                    endianInputStream.align32();
                    endianInputStream.readLoHiInt();
                    this.containmentClasses[n2] = endianInputStream.readLoHiChars();
                    ++n2;
                }
            }
            endianInputStream.align32();
            n4 = endianInputStream.readLoHiInt();
            if (n4 > 0) {
                this.namingAttributes = new String[n4];
                n2 = 0;
                while (n2 < n4) {
                    endianInputStream.align32();
                    endianInputStream.readLoHiInt();
                    this.namingAttributes[n2] = endianInputStream.readLoHiChars();
                    ++n2;
                }
            }
            endianInputStream.align32();
            n4 = endianInputStream.readLoHiInt();
            if (n4 > 0) {
                this.mandatoryAttributes = new String[n4];
                n2 = 0;
                while (n2 < n4) {
                    endianInputStream.align32();
                    endianInputStream.readLoHiInt();
                    this.mandatoryAttributes[n2] = endianInputStream.readLoHiChars();
                    ++n2;
                }
            }
            endianInputStream.align32();
            n4 = endianInputStream.readLoHiInt();
            if (n4 > 0) {
                this.optionalAttributes = new String[n4];
                n2 = 0;
                while (n2 < n4) {
                    endianInputStream.align32();
                    endianInputStream.readLoHiInt();
                    this.optionalAttributes[n2] = endianInputStream.readLoHiChars();
                    ++n2;
                }
            }
            if (n == 1 || n == 2) {
                return;
            }
            throw new NSIException();
        }
        catch (IOException iOException) {
            throw new NSIException();
        }
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.className;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getClassFlags() {
        return this.classFlags;
    }

    public byte[] getASN1ID() {
        return this.id;
    }

    public String[] getSuperClasses() {
        return this.superClasses;
    }

    public String[] getContainmentClasses() {
        return this.containmentClasses;
    }

    public String[] getNamingAttributes() {
        return this.namingAttributes;
    }

    public String[] getMandatoryAttributes() {
        return this.mandatoryAttributes;
    }

    public String[] getOptionalAttributes() {
        return this.optionalAttributes;
    }

    public NetAsn1ID getAsn1ID() {
        return this.asn1ID;
    }

    protected void setFlags(int n) {
        this.flags = n;
    }

    protected void setAsn1IDData(byte[] byArray) {
        this.asn1ID.setData(byArray);
    }
}

