/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds;

import com.novell.service.nds.NdsAttributeValue;
import com.novell.service.nds.NdsInteger;
import com.novell.service.nds.NdsString;
import com.novell.service.schema.SchemaComposite;
import com.novell.service.schema.SchemaValue;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class NdsHold
implements NdsAttributeValue,
SchemaComposite,
Cloneable,
Serializable {
    private static final int matchingRules = 1;
    private static String[] compositeIds = new String[2];
    protected String objectName;
    protected int amount;
    private String name;

    public NdsHold(String string, long l) {
        this("", string, l);
    }

    protected NdsHold() {
        this.objectName = null;
        this.amount = -1;
        this.name = null;
    }

    private NdsHold(String string, String string2, long l) {
        this.objectName = string2;
        this.amount = (int)(l & 0xFFFFFFFFL);
        this.name = string;
    }

    protected NdsHold(NdsHold ndsHold) {
        this.objectName = ndsHold.objectName;
        this.amount = ndsHold.amount;
        this.name = ndsHold.name;
    }

    public int compareTo(Object object) throws Exception {
        throw new Exception();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof NdsHold) {
            NdsHold ndsHold = (NdsHold)object;
            if (!this.objectName.equals(ndsHold.objectName)) {
                return false;
            }
            return this.amount != ndsHold.amount;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getSyntaxId() {
        return "Hold";
    }

    public int count() {
        return compositeIds.length;
    }

    public SchemaValue getValue(String string) {
        if (string.equalsIgnoreCase(compositeIds[0])) {
            return new NdsString(compositeIds[0], this.objectName);
        }
        if (string.equalsIgnoreCase(compositeIds[1])) {
            return new NdsInteger(compositeIds[1], this.amount);
        }
        return null;
    }

    public Enumeration getValueIds() {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < compositeIds.length) {
            vector.addElement(compositeIds[n]);
            ++n;
        }
        return vector.elements();
    }

    public Enumeration getValues() {
        Vector<SchemaValue> vector = new Vector<SchemaValue>();
        vector.addElement(new NdsString(compositeIds[0], this.objectName));
        vector.addElement(new NdsInteger(compositeIds[1], this.amount));
        return vector.elements();
    }

    public boolean approximate(Object object) throws Exception {
        throw new Exception();
    }

    public int getNdsSyntaxId() {
        return 26;
    }

    public boolean supportsMatchingRules(int n) {
        return (n & 1) == n;
    }

    public Object clone() {
        try {
            NdsHold ndsHold = (NdsHold)super.clone();
            ndsHold.objectName = this.objectName;
            ndsHold.amount = this.amount;
            ndsHold.name = this.name;
            return ndsHold;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        return String.valueOf(this.objectName) + ";" + String.valueOf(this.amount);
    }

    public String getObjectName() {
        return this.objectName;
    }

    public long getAmount() {
        return (long)this.amount & 0xFFFFFFFFL;
    }

    static {
        NdsHold.compositeIds[0] = "objectName";
        NdsHold.compositeIds[1] = "amount";
    }
}

