/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds;

import com.novell.service.nds.NdsAttributeValue;
import com.novell.service.nds.NdsInteger;
import com.novell.service.schema.SchemaComposite;
import com.novell.service.schema.SchemaValue;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class NdsNetAddress
implements NdsAttributeValue,
SchemaComposite,
Cloneable,
Serializable {
    public static final int TYPE_NONE = 0;
    public static final int TYPE_IPX = 1;
    public static final int TYPE_DDP = 3;
    public static final int TYPE_ASP = 4;
    public static final int TYPE_UDP = 8;
    public static final int TYPE_TCP = 9;
    public static final int TYPE_UDP6 = 10;
    public static final int TYPE_TCP6 = 11;
    public static final int TYPE_WILD = 32768;
    private static final int matchingRules = 1;
    private static String[] compositeIds = new String[3];
    protected int type;
    protected byte[] address;
    private String name;

    public NdsNetAddress(long l, byte[] byArray) {
        this("", l, byArray);
    }

    protected NdsNetAddress() {
        this.type = -1;
    }

    private NdsNetAddress(String string, long l, byte[] byArray) {
        this.type = (int)(l & 0xFFFFFFFFL);
        this.address = (byte[])byArray.clone();
        this.name = string;
    }

    protected NdsNetAddress(NdsNetAddress ndsNetAddress) {
        this.type = ndsNetAddress.type;
        this.address = ndsNetAddress.address;
        this.name = ndsNetAddress.name;
    }

    public int compareTo(Object object) throws Exception {
        throw new Exception();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof NdsNetAddress) {
            NdsNetAddress ndsNetAddress = (NdsNetAddress)object;
            if ((long)this.type != ndsNetAddress.getType()) {
                return false;
            }
            if ((long)this.address.length != ndsNetAddress.getLength()) {
                return false;
            }
            byte[] byArray = ndsNetAddress.getAddress();
            int n = 0;
            while (n < this.address.length) {
                if (this.address[n] != byArray[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getSyntaxId() {
        return "Network Address";
    }

    public int count() {
        return compositeIds.length;
    }

    public SchemaValue getValue(String string) {
        if (string.equalsIgnoreCase(compositeIds[0])) {
            return new NdsInteger(compositeIds[0], this.type);
        }
        if (string.equalsIgnoreCase(compositeIds[1])) {
            return new NdsInteger(compositeIds[1], this.address.length);
        }
        string.equalsIgnoreCase(compositeIds[2]);
        return null;
    }

    public Enumeration getValueIds() {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < compositeIds.length) {
            vector.addElement(compositeIds[n]);
            ++n;
        }
        return vector.elements();
    }

    public Enumeration getValues() {
        Vector<NdsInteger> vector = new Vector<NdsInteger>();
        vector.addElement(new NdsInteger(compositeIds[0], this.type));
        vector.addElement(new NdsInteger(compositeIds[1], this.address.length));
        return vector.elements();
    }

    public boolean approximate(Object object) throws Exception {
        throw new Exception();
    }

    public int getNdsSyntaxId() {
        return 12;
    }

    public boolean supportsMatchingRules(int n) {
        return (n & 1) == n;
    }

    public Object clone() {
        try {
            NdsNetAddress ndsNetAddress = (NdsNetAddress)super.clone();
            ndsNetAddress.type = this.type;
            ndsNetAddress.address = (byte[])this.address.clone();
            ndsNetAddress.name = this.name;
            return ndsNetAddress;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        return String.valueOf(String.valueOf(this.type)) + ";" + this.address.length + ";";
    }

    public long getType() {
        return (long)this.type & 0xFFFFFFFFL;
    }

    public long getLength() {
        return (long)this.address.length & 0xFFFFFFFFL;
    }

    public byte[] getAddress() {
        return (byte[])this.address.clone();
    }

    static {
        NdsNetAddress.compositeIds[0] = "type";
        NdsNetAddress.compositeIds[1] = "length";
        NdsNetAddress.compositeIds[2] = "address";
    }
}

