/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds;

import com.novell.service.nds.NdsAttributeValue;
import com.novell.service.schema.SchemaSequence;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class NdsOctetList
implements NdsAttributeValue,
SchemaSequence,
Cloneable,
Serializable {
    private static final int matchingRules = 3;
    protected byte[][] values;
    private String name;

    public NdsOctetList(byte[][] byArray) {
        this("", byArray);
    }

    protected NdsOctetList() {
        this.values = null;
    }

    protected NdsOctetList(String string, byte[][] byArray) {
        this.values = new byte[byArray.length][];
        int n = 0;
        while (n < byArray.length) {
            this.values[n] = (byte[])byArray[n].clone();
            ++n;
        }
        this.name = string;
    }

    protected NdsOctetList(NdsOctetList ndsOctetList) {
        this.values = ndsOctetList.values;
        this.name = ndsOctetList.name;
    }

    public int compareTo(Object object) throws Exception {
        throw new Exception();
    }

    private boolean compareByteArray(byte[] byArray, byte[] byArray2) {
        if (byArray.length == byArray2.length) {
            int n = 0;
            while (n < byArray.length) {
                if (byArray[n] != byArray2[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof NdsOctetList && this.values.length == ((NdsOctetList)object).count()) {
            byte[][] byArray = ((NdsOctetList)object).getOctetList();
            int n = 0;
            while (n < this.values.length) {
                if (!this.compareByteArray(this.values[n], byArray[n])) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getSyntaxId() {
        return "Octet List";
    }

    public int count() {
        return this.values.length;
    }

    public Enumeration getValues() {
        Vector<byte[]> vector = new Vector<byte[]>();
        int n = 0;
        while (n < this.values.length) {
            vector.addElement(this.values[n]);
            ++n;
        }
        return vector.elements();
    }

    public boolean approximate(Object object) {
        if (object instanceof NdsOctetList) {
            int n = this.values.length;
            int n2 = ((NdsOctetList)object).count();
            byte[][] byArray = ((NdsOctetList)object).getOctetList();
            while (n > 0 && n2 > 0) {
                byte[] byArray2 = this.values[n];
                byte[] byArray3 = byArray[n2];
                if (this.compareByteArray(byArray2, byArray3)) {
                    --n;
                }
                --n2;
            }
            return n == 0;
        }
        return false;
    }

    public int getNdsSyntaxId() {
        return 13;
    }

    public boolean supportsMatchingRules(int n) {
        return (n & 3) == n;
    }

    public Object clone() {
        try {
            NdsOctetList ndsOctetList = (NdsOctetList)super.clone();
            ndsOctetList.values = (byte[][])this.values.clone();
            ndsOctetList.name = this.name;
            return ndsOctetList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        return this.values.toString();
    }

    public byte[][] getOctetList() {
        int n = this.values.length;
        byte[][] byArray = new byte[n][];
        int n2 = 0;
        while (n2 < n) {
            byte[] byArray2 = this.values[n2];
            byArray[n2] = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, byArray[n2], 0, byArray2.length);
            ++n2;
        }
        return byArray;
    }
}

