/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds;

import com.novell.service.nds.NdsAttributeValue;
import com.novell.service.nds.NdsInteger;
import java.io.Serializable;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class NdsTime
extends NdsInteger
implements NdsAttributeValue,
Cloneable,
Serializable {
    private static final int matchingRules = 5;

    public NdsTime(long l) {
        super(l);
    }

    public NdsTime(Date date) {
        super(date.getTime() / 1000L);
    }

    protected NdsTime() {
    }

    private NdsTime(String string, long l) {
        super(string, l);
    }

    protected NdsTime(NdsTime ndsTime) {
        this.value = ndsTime.value;
        this.name = ndsTime.name;
    }

    public int compareTo(Object object) throws Exception {
        if (object instanceof NdsTime) {
            int n = ((NdsTime)object).intValue();
            if (this.value > n) {
                return 1;
            }
            if (this.value < n) {
                return -1;
            }
            return 0;
        }
        throw new IllegalArgumentException();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof NdsTime) {
            return this.value == ((NdsTime)object).intValue();
        }
        return false;
    }

    public String getSyntaxId() {
        return "Time";
    }

    public int getNdsSyntaxId() {
        return 24;
    }

    public boolean supportsMatchingRules(int n) {
        return (n & 5) == n;
    }

    public Object clone() {
        NdsTime ndsTime = (NdsTime)super.clone();
        return ndsTime;
    }

    public long getTime() {
        return (long)this.value & 0xFFFFFFFFL;
    }

    public Date getDate() {
        Date date = new Date();
        date.setTime((long)this.value * 1000L);
        return date;
    }

    public GregorianCalendar getGregorianCalendar() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        gregorianCalendar.setTime(this.getDate());
        return gregorianCalendar;
    }
}

