/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds;

import com.novell.service.nds.NdsAttributeValue;
import com.novell.service.nds.NdsInteger;
import com.novell.service.nds.NdsLong;
import com.novell.service.schema.SchemaComposite;
import com.novell.service.schema.SchemaNumber;
import com.novell.service.schema.SchemaValue;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;

public class NdsTimestamp
implements NdsAttributeValue,
SchemaComposite,
Cloneable,
Serializable {
    private static final int matchingRules = 5;
    private static String[] compositeIds = new String[3];
    protected long wholeSeconds;
    protected int replicaNumber;
    protected int eventId;
    private String name;

    public NdsTimestamp(long l, int n, int n2) {
        this.wholeSeconds = l;
        this.replicaNumber = n2;
        this.eventId = n;
    }

    protected NdsTimestamp() {
        this.wholeSeconds = -1L;
        this.replicaNumber = -1;
        this.eventId = -1;
    }

    private NdsTimestamp(String string, long l, int n, int n2) {
        this.name = string;
        this.wholeSeconds = l;
        this.replicaNumber = n2;
        this.eventId = n;
    }

    protected NdsTimestamp(NdsTimestamp ndsTimestamp) {
        this.wholeSeconds = ndsTimestamp.wholeSeconds;
        this.replicaNumber = ndsTimestamp.replicaNumber;
        this.eventId = ndsTimestamp.eventId;
    }

    public int compareTo(Object object) throws Exception {
        throw new Exception();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof NdsTimestamp) {
            NdsTimestamp ndsTimestamp = (NdsTimestamp)object;
            if (this.wholeSeconds != ndsTimestamp.wholeSeconds) {
                return false;
            }
            if (this.replicaNumber != ndsTimestamp.replicaNumber) {
                return false;
            }
            return this.eventId == ndsTimestamp.eventId;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getSyntaxId() {
        return "Timestamp";
    }

    public int count() {
        return compositeIds.length;
    }

    public SchemaValue getValue(String string) {
        if (string.equalsIgnoreCase(compositeIds[0])) {
            return new NdsLong(compositeIds[0], this.wholeSeconds);
        }
        if (string.equalsIgnoreCase(compositeIds[1])) {
            return new NdsInteger(compositeIds[1], this.replicaNumber);
        }
        if (string.equalsIgnoreCase(compositeIds[2])) {
            return new NdsInteger(compositeIds[2], this.eventId);
        }
        return null;
    }

    public Enumeration getValueIds() {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < compositeIds.length) {
            vector.addElement(compositeIds[n]);
            ++n;
        }
        return vector.elements();
    }

    public Enumeration getValues() {
        Vector<SchemaNumber> vector = new Vector<SchemaNumber>();
        vector.addElement(new NdsLong(compositeIds[0], this.wholeSeconds));
        vector.addElement(new NdsInteger(compositeIds[1], this.replicaNumber));
        vector.addElement(new NdsInteger(compositeIds[2], this.eventId));
        return vector.elements();
    }

    public boolean approximate(Object object) throws Exception {
        throw new Exception();
    }

    public int getNdsSyntaxId() {
        return 19;
    }

    public boolean supportsMatchingRules(int n) {
        return (n & 5) == n;
    }

    public Object clone() {
        try {
            NdsTimestamp ndsTimestamp = (NdsTimestamp)super.clone();
            ndsTimestamp.wholeSeconds = this.wholeSeconds;
            ndsTimestamp.replicaNumber = this.replicaNumber;
            ndsTimestamp.eventId = this.eventId;
            ndsTimestamp.name = this.name;
            return ndsTimestamp;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        return String.valueOf(String.valueOf(this.wholeSeconds)) + ";" + String.valueOf(this.replicaNumber) + ";" + String.valueOf(this.eventId);
    }

    public long getWholeSeconds() {
        return this.wholeSeconds & 0xFFFFFFFFL;
    }

    public int getReplicaNumber() {
        return this.replicaNumber;
    }

    public int getEventId() {
        return this.eventId;
    }

    public Date getDate() {
        Date date = new Date();
        date.setTime(this.wholeSeconds * 1000L);
        return date;
    }

    public GregorianCalendar getGregorianCalendar() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        gregorianCalendar.setTime(this.getDate());
        return gregorianCalendar;
    }

    static {
        NdsTimestamp.compositeIds[0] = "wholeSeconds";
        NdsTimestamp.compositeIds[1] = "replicaNumber";
        NdsTimestamp.compositeIds[2] = "eventId";
    }
}

