/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds.naming;

import com.novell.service.nds.naming.NdsNameUtility;
import com.novell.utility.naming.Syntax;
import java.util.Enumeration;
import java.util.Vector;
import javax.naming.CompoundName;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingException;

public class NdsName
extends CompoundName {
    private Syntax syntax;

    protected NdsName(Enumeration enumeration, Syntax syntax) {
        super(enumeration, syntax.getProperties());
        this.syntax = syntax;
    }

    public NdsName(String string, Syntax syntax) throws InvalidNameException {
        super("", syntax.getProperties());
        int n = 0;
        int n2 = string.length();
        Vector vector = new Vector();
        NdsNameUtility ndsNameUtility = new NdsNameUtility(syntax);
        while (n < n2) {
            n = ndsNameUtility.stringToComponent(string, n, n2, vector);
        }
        this.addAll(new NdsName(vector.elements(), syntax));
        this.syntax = syntax;
    }

    public void setSyntax(Syntax syntax) throws NamingException {
        this.syntax = syntax;
    }

    public NdsName getTypelessName() throws NamingException {
        NdsName ndsName = new NdsName("", this.syntax);
        Enumeration<String> enumeration = this.getAll();
        char c = '\u0000';
        String string = this.syntax.getTypevalSeparator();
        if (string == null) {
            throw new InvalidNameException();
        }
        String string2 = this.syntax.getEscape();
        if (string2 != null) {
            c = string2.charAt(0);
        }
        while (enumeration.hasMoreElements()) {
            String string3 = enumeration.nextElement();
            int n = string3.indexOf(string);
            if (n != -1 && n > 0 && string3.charAt(n - 1) != c) {
                string3 = string3.substring(n + 1);
            }
            ndsName.add(string3);
        }
        return ndsName;
    }

    public String getCanonicalString() throws NamingException {
        if (this.isEmpty()) {
            return "[Root]";
        }
        int n = 0;
        int n2 = this.size();
        String string = this.syntax.getSeparator();
        StringBuffer stringBuffer = new StringBuffer(256);
        do {
            stringBuffer = stringBuffer.append(this.get(n2 - 1 - n++));
        } while (n < n2 && stringBuffer.append(string) != null);
        return new String(stringBuffer);
    }

    public int compareTo(Object object) {
        if (!(object instanceof NdsName)) {
            throw new ClassCastException("!(object instanceof NdsName)");
        }
        return super.compareTo(object);
    }

    public Name getPrefix(int n) {
        return new NdsName(super.getPrefix(n).getAll(), this.syntax);
    }

    public Name getSuffix(int n) {
        return new NdsName(super.getSuffix(n).getAll(), this.syntax);
    }

    public boolean startsWith(Name name) {
        if (name instanceof NdsName) {
            return super.startsWith(name);
        }
        return false;
    }

    public boolean endsWith(Name name) {
        if (name instanceof NdsName) {
            return super.endsWith(name);
        }
        return false;
    }

    public Name addAll(Name name) throws InvalidNameException {
        if (name instanceof NdsName) {
            return super.addAll(name);
        }
        throw new InvalidNameException(name.toString());
    }

    public Name addAll(int n, Name name) throws InvalidNameException {
        if (name instanceof NdsName) {
            return super.addAll(n, name);
        }
        throw new InvalidNameException(name.toString());
    }

    public Object clone() {
        return new NdsName(this.getAll(), this.syntax);
    }

    public boolean equals(Object object) {
        return object != null && object instanceof NdsName && super.equals(object);
    }

    public String toString() {
        int n = this.size();
        String string = new String("");
        if (n != 0) {
            int n2 = n - 1;
            while (n2 >= 0) {
                string = n2 != 0 ? String.valueOf(string) + this.get(n2) + "." : String.valueOf(string) + this.get(n2);
                --n2;
            }
        }
        return string;
    }
}

