/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds.naming;

import com.novell.service.jncp.NSIException;
import javax.naming.AuthenticationException;
import javax.naming.AuthenticationNotSupportedException;
import javax.naming.CommunicationException;
import javax.naming.ContextNotEmptyException;
import javax.naming.InsufficientResourcesException;
import javax.naming.InvalidNameException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.SizeLimitExceededException;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.directory.InvalidAttributesException;

public class NdsNamingExceptionFactory {
    public NamingException getNamingException(NSIException nSIException) {
        NamingException namingException;
        int n = nSIException.getCCode();
        switch (n) {
            case -669: 
            case -639: 
            case -339: {
                namingException = new AuthenticationException();
                break;
            }
            case -351: {
                namingException = new AuthenticationNotSupportedException();
                break;
            }
            case -625: 
            case -622: {
                namingException = new CommunicationException();
                break;
            }
            case -629: {
                namingException = new ContextNotEmptyException();
                break;
            }
            case -648: 
            case -301: 
            case -150: {
                namingException = new InsufficientResourcesException();
                break;
            }
            case -613: 
            case -612: {
                namingException = new InvalidAttributeValueException();
                break;
            }
            case -614: 
            case -609: 
            case -608: {
                namingException = new InvalidAttributesException();
                break;
            }
            case -623: 
            case -611: 
            case -610: 
            case -353: {
                namingException = new InvalidNameException();
                break;
            }
            case -679: 
            case -645: 
            case -606: {
                namingException = new NameAlreadyBoundException();
                break;
            }
            case -634: 
            case -626: 
            case -604: 
            case -601: {
                namingException = new NameNotFoundException();
                break;
            }
            case -672: {
                namingException = new NoPermissionException();
                break;
            }
            case -649: {
                namingException = new SizeLimitExceededException();
                break;
            }
            case -255: {
                namingException = new NamingException();
                break;
            }
            default: {
                namingException = new NamingException();
            }
        }
        namingException.setRootCause(nSIException);
        return namingException;
    }
}

