/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds.naming.local;

import com.novell.service.jncp.NSIException;
import com.novell.service.nds.naming.NdsDataAccessor;
import com.novell.service.nds.naming.NdsEnvironment;
import com.novell.service.nds.naming.TransportContextFactoryBuilder;
import com.novell.utility.naming.Environment;
import com.novell.utility.naming.spi.ContextFactory;
import com.novell.utility.naming.spi.ContextFactoryBuilder;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.CompositeName;
import javax.naming.CompoundName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;

public class SchemaContextFactory
implements ContextFactory {
    private static ContextFactoryBuilder builder = new TransportContextFactoryBuilder();
    private static String defaultClass = "com.novell.service.nds.naming.local.SchemaDirContext";
    private static Properties wrapperClasses = new Properties();

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        NdsEnvironment ndsEnvironment = new NdsEnvironment(hashtable);
        if (object instanceof Reference) {
            StringRefAddr stringRefAddr = (StringRefAddr)((Reference)object).get(0);
            CompositeName compositeName = new CompositeName((String)stringRefAddr.getContent());
            hashtable.put("java.naming.provider.url", compositeName.get(0));
            return this.getContextInstance(compositeName.get(1), ndsEnvironment);
        }
        if (object instanceof String) {
            return this.getContextInstance((String)object, ndsEnvironment);
        }
        if (object instanceof CompoundName) {
            return this.getContextInstance(object.toString(), ndsEnvironment);
        }
        throw new Exception();
    }

    public Context getContextInstance(String string, Environment environment) throws NamingException {
        return this.getContextInstance(string, null, environment);
    }

    public Context getContextInstance(String string, Object object, Environment environment) throws NamingException {
        NdsEnvironment ndsEnvironment = this.getEnvironmentInstance(environment);
        ContextFactory contextFactory = builder.createContextFactory(string, ndsEnvironment);
        Context context = contextFactory.getContextInstance(string, ndsEnvironment);
        return this.getContextInstance(context);
    }

    public Context getContextInstance(Object object) throws NamingException {
        if (!(object instanceof NdsDataAccessor)) {
            throw new NamingException();
        }
        NdsDataAccessor ndsDataAccessor = (NdsDataAccessor)object;
        try {
            Class[] classArray = new Class[2];
            Object[] objectArray = new Object[2];
            Class<?> clazz = Class.forName(this.getClassName(ndsDataAccessor));
            classArray[0] = Class.forName("com.novell.service.nds.naming.SchemaDirContextWrappable");
            classArray[1] = Class.forName("com.novell.service.nds.naming.NdsEnvironment");
            Constructor<?> constructor = clazz.getDeclaredConstructor(classArray);
            objectArray[0] = ndsDataAccessor;
            objectArray[1] = ndsDataAccessor.getEnvironmentInstance();
            return (Context)constructor.newInstance(objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(classNotFoundException);
            throw namingException;
        }
        catch (SecurityException securityException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(securityException);
            throw namingException;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(noSuchMethodException);
            throw namingException;
        }
        catch (InstantiationException instantiationException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(instantiationException);
            throw namingException;
        }
        catch (IllegalAccessException illegalAccessException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(illegalAccessException);
            throw namingException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(illegalArgumentException);
            throw namingException;
        }
        catch (InvocationTargetException invocationTargetException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(invocationTargetException);
            throw namingException;
        }
    }

    public String getClassName(Object object) throws NamingException {
        try {
            String string;
            if (object instanceof NdsDataAccessor) {
                string = ((NdsDataAccessor)object).getBaseClass();
            } else if (object instanceof String) {
                string = (String)object;
            } else {
                throw new NamingException();
            }
            return wrapperClasses.getProperty(string, defaultClass);
        }
        catch (NSIException nSIException) {
            throw new NamingException();
        }
    }

    private NdsEnvironment getEnvironmentInstance(Environment environment) throws NamingException {
        if (environment instanceof NdsEnvironment) {
            return (NdsEnvironment)environment;
        }
        return new NdsEnvironment(environment);
    }

    static {
        ((Hashtable)wrapperClasses).put("Attribute Container", "com.novell.service.nds.naming.local.AttributeContainerDirContext");
        ((Hashtable)wrapperClasses).put("Class Container", "com.novell.service.nds.naming.local.ClassContainerDirContext");
        ((Hashtable)wrapperClasses).put("Schema Attribute", "com.novell.service.nds.naming.local.SchemaAttributeDirContext");
        ((Hashtable)wrapperClasses).put("Schema Class", "com.novell.service.nds.naming.local.SchemaClassDirContext");
        ((Hashtable)wrapperClasses).put("Schema Container", "com.novell.service.nds.naming.local.SchemaContainerDirContext");
        ((Hashtable)wrapperClasses).put("Schema Syntax", "com.novell.service.nds.naming.local.SchemaSyntaxDirContext");
        ((Hashtable)wrapperClasses).put("Syntax Container", "com.novell.service.nds.naming.local.SyntaxContainerDirContext");
    }
}

