/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds.naming.net;

import com.novell.service.jncp.NSIException;
import com.novell.service.jncpv2.net.NetAttrRecord;
import com.novell.service.jncpv2.net.NetAttrRecordEnumerator;
import com.novell.service.jncpv2.net.NetBuffer;
import com.novell.service.jncpv2.net.NetIterationHandle;
import com.novell.service.jncpv2.net.NetService;
import com.novell.service.nds.naming.NdsNamingExceptionFactory;
import com.novell.service.nds.naming.net.NetAttribute;
import com.novell.service.nds.naming.net.NetEnvironment;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

class NetAttributeEnumerator
implements NamingEnumeration {
    private static NdsNamingExceptionFactory exceptionFactory = new NdsNamingExceptionFactory();
    private String objectName;
    private NetEnvironment environment;
    private NetService service;
    private int infoType;
    private boolean allAttributes;
    private NetBuffer attributeBuffer;
    private int attributeCount;
    private NetIterationHandle iterationHandle;
    private NetBuffer objectInfo;
    private Enumeration records;
    private NetAttrRecord nextAttrRecord;

    NetAttributeEnumerator(String string, NetEnvironment netEnvironment, String[] stringArray) throws NamingException {
        String string2 = netEnvironment.getObjectAttributeLevel();
        this.objectName = string;
        this.environment = netEnvironment;
        this.service = netEnvironment.getService();
        try {
            this.infoType = string2.equals("OBJECT_ATTR_NAMES") ? 0 : 1;
            if (stringArray == null) {
                this.allAttributes = true;
                this.attributeBuffer = new NetBuffer();
            } else {
                this.allAttributes = false;
                this.attributeBuffer = new NetBuffer(this.service, 3, netEnvironment.getBatchSize());
                int n = 0;
                while (n < stringArray.length) {
                    if (stringArray[n] != null) {
                        this.attributeBuffer.putAttributeName(stringArray[n]);
                    }
                    ++n;
                }
            }
            this.records = new NetAttrRecordEnumerator(this.service, string, this.infoType, this.attributeBuffer, netEnvironment.getBatchSize());
            this.nextAttrRecord = this.getNextAttrRecord();
            return;
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            throw namingException;
        }
    }

    private NetAttrRecord getNextAttrRecord() throws NamingException, NSIException {
        if (this.records.hasMoreElements()) {
            return (NetAttrRecord)this.records.nextElement();
        }
        return null;
    }

    public boolean hasMoreElements() {
        return this.nextAttrRecord != null;
    }

    public boolean hasMore() throws NamingException {
        return this.nextAttrRecord != null;
    }

    public Object nextElement() {
        try {
            return this.next();
        }
        catch (NamingException namingException) {
            throw new NoSuchElementException();
        }
    }

    public Object next() throws NamingException {
        try {
            NetAttribute netAttribute = new NetAttribute(this.objectName, this.environment, this.nextAttrRecord);
            this.nextAttrRecord = this.getNextAttrRecord();
            while (netAttribute.equalsApproximate(this.nextAttrRecord)) {
                netAttribute.add(this.nextAttrRecord);
                this.nextAttrRecord = this.getNextAttrRecord();
            }
            return netAttribute;
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            throw namingException;
        }
    }

    public void close() throws NamingException {
    }
}

