/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds.naming.net;

import com.novell.service.jncp.NSIException;
import com.novell.service.jncpv2.net.NetBuffer;
import com.novell.service.jncpv2.net.NetIterationHandle;
import com.novell.service.jncpv2.net.NetService;
import com.novell.service.nds.naming.NdsNamingExceptionFactory;
import com.novell.service.session.SessionException;
import com.novell.service.toolkit.jcl.NWInteger;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.naming.NamingException;

public class NetAttributeValueEnumerator
implements Enumeration {
    private String objectName;
    private String attrName;
    private NetService service;
    private NetIterationHandle iterationHandle;
    private NetBuffer rawValues;
    private NWInteger valueCount;
    private NWInteger syntaxId;
    private boolean moreValues;
    private static NdsNamingExceptionFactory exceptionFactory = new NdsNamingExceptionFactory();

    public NetAttributeValueEnumerator(NetService netService, String string, String string2) throws NSIException {
        this.service = netService;
        this.objectName = string;
        this.attrName = string2;
        this.iterationHandle = new NetIterationHandle(netService, 3);
        this.rawValues = new NetBuffer(netService);
        this.valueCount = new NWInteger(0);
        this.syntaxId = new NWInteger(0);
        this.moreValues = true;
    }

    private void getRawValues() throws NSIException {
        if (!this.moreValues) {
            return;
        }
        NetBuffer netBuffer = new NetBuffer(this.service, 3, 4096);
        netBuffer.putAttributeName(this.attrName);
        try {
            this.service.read(this.objectName, 1, false, netBuffer.getHandle(), this.iterationHandle, this.rawValues.getHandle());
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
        this.rawValues.getAttrCount();
        StringBuffer stringBuffer = new StringBuffer();
        this.rawValues.getAttrName(stringBuffer, this.valueCount, this.syntaxId);
        this.moreValues = this.iterationHandle.moreIterations();
    }

    public boolean hasMoreElements() {
        try {
            if (this.valueCount.getValue() == 0) {
                this.getRawValues();
            }
        }
        catch (NSIException nSIException) {
            this.valueCount.setValue(0);
        }
        return this.valueCount.getValue() != 0;
    }

    public Object nextElement() throws NoSuchElementException {
        try {
            if (this.valueCount.getValue() == 0) {
                this.getRawValues();
            }
        }
        catch (NSIException nSIException) {
            throw new NoSuchElementException(nSIException.getMessage());
        }
        if (this.valueCount.getValue() == 0) {
            throw new NoSuchElementException();
        }
        byte[] byArray = null;
        try {
            byArray = this.rawValues.getAttributeValue(this.syntaxId.getValue());
        }
        catch (NSIException nSIException) {
            throw new NoSuchElementException(nSIException.getMessage());
        }
        this.valueCount.setValue(this.valueCount.getValue() - 1);
        return byArray;
    }

    public void closeIteration() throws NamingException {
        try {
            this.iterationHandle.closeIteration();
            return;
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            throw namingException;
        }
    }
}

