/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds.naming.net;

import com.novell.service.jncp.NSIException;
import com.novell.service.jncpv2.net.NetAsn1ID;
import com.novell.service.jncpv2.net.NetBuffer;
import com.novell.service.jncpv2.net.NetClassInfo;
import com.novell.service.jncpv2.net.NetIterationHandle;
import com.novell.service.jncpv2.net.NetReadClassDefBuffer;
import com.novell.service.nds.NdsDistinguishedName;
import com.novell.service.nds.NdsInteger;
import com.novell.service.nds.NdsOctetString;
import com.novell.service.nds.naming.NdsNamingExceptionFactory;
import com.novell.service.nds.naming.net.ClassDefinitionsBindingEnumerator;
import com.novell.service.nds.naming.net.ClassDefinitionsNameClassEnumerator;
import com.novell.service.nds.naming.net.NetEnvironment;
import com.novell.service.nds.naming.net.NetSchemaContainerDirContext;
import com.novell.service.nds.naming.net.NetSchemaDirContext;
import com.sun.jndi.toolkit.ctx.Continuation;
import javax.naming.InvalidNameException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;

public class NetClassDefinitionsDirContext
extends NetSchemaContainerDirContext {
    private static NdsNamingExceptionFactory exceptionFactory = new NdsNamingExceptionFactory();

    protected NetClassDefinitionsDirContext(String string, String string2, NetEnvironment netEnvironment) throws NamingException {
        super(string, string2, netEnvironment);
    }

    protected NamingEnumeration schema_list(Continuation continuation) throws NamingException {
        continuation.setSuccess();
        return new ClassDefinitionsNameClassEnumerator(this);
    }

    protected NamingEnumeration schema_listBindings(Continuation continuation) throws NamingException {
        continuation.setSuccess();
        return new ClassDefinitionsBindingEnumerator(this);
    }

    protected void schema_destroySubcontext(String string, Continuation continuation) throws NamingException {
        String string2;
        String string3 = string2 = string.length() > 0 ? NetSchemaDirContext.nameParser.parse(string).get(0) : "";
        if (!this.exists(string2)) {
            continuation.setError((Object)this, string2);
            NameNotFoundException nameNotFoundException = new NameNotFoundException();
            throw continuation.fillInException(nameNotFoundException);
        }
        try {
            this.getService().removeClassDef(string2);
        }
        catch (Exception exception) {
            NamingException namingException = new NamingException();
            continuation.setError((Object)this, string2);
            namingException.setRootCause(exception);
            throw continuation.fillInException(namingException);
        }
        continuation.setSuccess();
    }

    protected DirContext schema_createSubcontext(String string, Attributes attributes, Continuation continuation) throws NamingException {
        if (this.isEmpty(string)) {
            continuation.setError((Object)this, string);
            throw continuation.fillInException(new InvalidNameException());
        }
        String string2 = NetSchemaDirContext.nameParser.parse(string).get(0);
        if (this.exists(string2)) {
            continuation.setError((Object)this, string);
            throw continuation.fillInException(new NameAlreadyBoundException());
        }
        if (attributes == null) {
            attributes = new BasicAttributes();
        }
        try {
            NetBuffer netBuffer = new NetBuffer(this.getService(), 14, this.environment.getBatchSize());
            this.storeClassItem(netBuffer, attributes.get("Object Super Classes"));
            this.storeClassItem(netBuffer, attributes.get("Object Containment Classes"));
            this.storeClassItem(netBuffer, attributes.get("Object Naming Attributes"));
            this.storeClassItem(netBuffer, attributes.get("Object Mandatory Attributes"));
            this.storeClassItem(netBuffer, attributes.get("Object Optional Attributes"));
            Attribute attribute = attributes.get("Flags");
            Attribute attribute2 = attributes.get("ASN1Name");
            long l = 0L;
            if (attribute != null) {
                l = ((NdsInteger)attribute.getAll().nextElement()).getInteger();
            }
            NetAsn1ID netAsn1ID = new NetAsn1ID();
            if (attribute2 != null) {
                netAsn1ID.setData(((NdsOctetString)attribute2.getAll().nextElement()).getOctetString());
            }
            NetClassInfo netClassInfo = new NetClassInfo((int)l, netAsn1ID);
            this.getService().defineClass(string2, netClassInfo, netBuffer.getHandle());
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            continuation.setError((Object)this, string);
            throw continuation.fillInException(namingException);
        }
        catch (Exception exception) {
            NamingException namingException = new NamingException();
            continuation.setError((Object)this, string);
            namingException.setRootCause(exception);
            throw continuation.fillInException(namingException);
        }
        return (DirContext)this.a_lookup(string, continuation);
    }

    protected boolean exists(String string) {
        try {
            NetIterationHandle netIterationHandle = new NetIterationHandle(this.getService(), 15);
            NetBuffer netBuffer = new NetBuffer(this.getService(), 15, this.environment.getBatchSize());
            NetReadClassDefBuffer netReadClassDefBuffer = new NetReadClassDefBuffer(this.getService(), 0, this.environment.getBatchSize());
            netBuffer.putClassName(string);
            this.getService().readClassDef(0, false, netBuffer.getHandle(), netIterationHandle, netReadClassDefBuffer);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private void storeClassItem(NetBuffer netBuffer, Attribute attribute) throws NamingException, NSIException {
        netBuffer.beginClassItem();
        if (attribute != null) {
            NamingEnumeration<?> namingEnumeration = attribute.getAll();
            int n = attribute.size();
            while (n-- > 0) {
                netBuffer.putClassItem(((NdsDistinguishedName)namingEnumeration.nextElement()).getDistinguishedName());
            }
        }
    }
}

