/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds.naming.net;

import com.novell.service.jncp.NSIException;
import com.novell.service.jncpv2.net.NetEntryInfo;
import com.novell.service.jncpv2.net.NetObjectInfo;
import com.novell.service.jncpv2.net.NetService;
import com.novell.service.nds.NdsObjectInfo;
import com.novell.service.nds.naming.NdsName;
import com.novell.service.nds.naming.NdsNamingExceptionFactory;
import com.novell.service.nds.naming.NetSyntax;
import com.novell.service.nds.naming.net.NetEnvironment;
import com.novell.service.session.SessionException;
import com.novell.utility.naming.Environment;
import com.novell.utility.naming.Syntax;
import com.novell.utility.naming.URLParser;
import com.novell.utility.naming.spi.ContextFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.AuthenticationException;
import javax.naming.CompoundName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;

public final class NetContextFactory
implements ContextFactory {
    private static NdsNamingExceptionFactory exceptionFactory = new NdsNamingExceptionFactory();
    private static String defaultContext = "com.novell.service.nds.naming.net.NetDirContext";
    private static Properties netContexts = new Properties();

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        NetEnvironment netEnvironment = new NetEnvironment(hashtable);
        if (object instanceof Reference) {
            StringRefAddr stringRefAddr = (StringRefAddr)((Reference)object).get(0);
            URLParser uRLParser = new URLParser((String)stringRefAddr.getContent());
            netEnvironment.addToEnvironment("java.naming.provider.url", uRLParser.getURL());
            return this.getContextInstance(this.getCanonicalName(uRLParser.getPath()), netEnvironment);
        }
        if (object instanceof String) {
            return this.getContextInstance((String)object, netEnvironment);
        }
        if (object instanceof CompoundName) {
            return this.getContextInstance(object.toString(), netEnvironment);
        }
        throw new Exception();
    }

    public Context getContextInstance(String string, Environment environment) throws NamingException {
        StringBuffer stringBuffer = new StringBuffer();
        NetEnvironment netEnvironment = this.getEnvironmentInstance(environment);
        NetObjectInfo netObjectInfo = this.getNetObjectInfo(string, stringBuffer, netEnvironment.getService());
        String string2 = stringBuffer.toString();
        NetEntryInfo netEntryInfo = this.getNetEntryInfo(string2, netEnvironment.getService(), netEnvironment.getBatchSize());
        String string3 = netEntryInfo.getFederationBoundary();
        if (string3 != null && string3.equalsIgnoreCase(string2)) {
            netObjectInfo.setManagementRoot(true);
        }
        return this.getContextInstance(string2, netObjectInfo, netEnvironment);
    }

    public Context getContextInstance(String string, Object object, Environment environment) throws NamingException {
        if (!(object instanceof NdsObjectInfo)) {
            throw new NamingException();
        }
        NdsObjectInfo ndsObjectInfo = (NdsObjectInfo)object;
        NetEnvironment netEnvironment = this.getEnvironmentInstance(environment);
        try {
            Class[] classArray = new Class[3];
            Object[] objectArray = new Object[3];
            Class<?> clazz = ndsObjectInfo.isManagementRoot() ? Class.forName("com.novell.service.nds.naming.net.NetTreeDirContext") : Class.forName(this.getClassName(ndsObjectInfo.getBaseClass()));
            classArray[0] = Class.forName("java.lang.String");
            classArray[1] = Class.forName("com.novell.service.nds.NdsObjectInfo");
            classArray[2] = Class.forName("com.novell.service.nds.naming.net.NetEnvironment");
            Constructor<?> constructor = clazz.getDeclaredConstructor(classArray);
            objectArray[0] = string;
            objectArray[1] = ndsObjectInfo;
            objectArray[2] = netEnvironment;
            return (Context)constructor.newInstance(objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(classNotFoundException);
            throw namingException;
        }
        catch (SecurityException securityException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(securityException);
            throw namingException;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(noSuchMethodException);
            throw namingException;
        }
        catch (InstantiationException instantiationException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(instantiationException);
            throw namingException;
        }
        catch (IllegalAccessException illegalAccessException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(illegalAccessException);
            throw namingException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(illegalArgumentException);
            throw namingException;
        }
        catch (InvocationTargetException invocationTargetException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(invocationTargetException);
            throw namingException;
        }
    }

    public Context getContextInstance(Object object) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public String getClassName(Object object) {
        return netContexts.getProperty((String)object, defaultContext);
    }

    private NetObjectInfo getNetObjectInfo(String string, StringBuffer stringBuffer, NetService netService) throws NamingException {
        NetObjectInfo netObjectInfo = new NetObjectInfo();
        try {
            netService.readObjectInfo(string, stringBuffer, netObjectInfo);
        }
        catch (SessionException sessionException) {
            AuthenticationException authenticationException = new AuthenticationException();
            authenticationException.setRootCause(sessionException);
            throw authenticationException;
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            throw namingException;
        }
        return netObjectInfo;
    }

    private NetEntryInfo getNetEntryInfo(String string, NetService netService, int n) throws NamingException {
        try {
            return netService.readEntry(string, n);
        }
        catch (SessionException sessionException) {
            AuthenticationException authenticationException = new AuthenticationException();
            authenticationException.setRootCause(sessionException);
            throw authenticationException;
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            throw namingException;
        }
    }

    private NetEnvironment getEnvironmentInstance(Environment environment) throws NamingException {
        if (environment instanceof NetEnvironment) {
            return (NetEnvironment)environment;
        }
        return new NetEnvironment(environment);
    }

    private String getCanonicalName(String string) throws NamingException {
        NdsName ndsName = new NdsName(string == null ? "" : string, (Syntax)new NetSyntax());
        return ndsName.getCanonicalString();
    }

    static {
        ((Hashtable)netContexts).put("Volume", "com.novell.service.nds.naming.net.NetVolumeDirContext");
        ((Hashtable)netContexts).put("NCP Server", "com.novell.service.nds.naming.net.NetServerDirContext");
        ((Hashtable)netContexts).put("Top", "com.novell.service.nds.naming.net.NetTreeDirContext");
        ((Hashtable)netContexts).put("Directory Map", "com.novell.service.nds.naming.net.NetDirectoryMapDirContext");
        ((Hashtable)netContexts).put("Queue", "com.novell.service.nds.naming.net.NetQueueDirContext");
        ((Hashtable)netContexts).put("Alias", "com.novell.service.nds.naming.net.NetAliasDirContext");
    }
}

