/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds.naming.net;

import com.novell.service.jncp.NSIException;
import com.novell.service.jncpv2.net.NetBuffer;
import com.novell.service.jncpv2.net.NetIterationHandle;
import com.novell.service.jncpv2.net.NetService;
import com.novell.service.nds.NdsAttributeRights;
import com.novell.service.nds.NdsAttributeValue;
import com.novell.service.nds.NdsClassName;
import com.novell.service.nds.NdsDistinguishedName;
import com.novell.service.nds.NdsIterator;
import com.novell.service.nds.NdsIteratorControls;
import com.novell.service.nds.NdsObject;
import com.novell.service.nds.NdsObjectInfo;
import com.novell.service.nds.NdsObjectRights;
import com.novell.service.nds.naming.NdsDataAccessor;
import com.novell.service.nds.naming.NdsDirContextWrappable;
import com.novell.service.nds.naming.NdsName;
import com.novell.service.nds.naming.NdsNameParser;
import com.novell.service.nds.naming.NdsNamingExceptionFactory;
import com.novell.service.nds.naming.Partitionable;
import com.novell.service.nds.naming.net.BasicNdsIterator;
import com.novell.service.nds.naming.net.JavaObject;
import com.novell.service.nds.naming.net.ListNdsIterator;
import com.novell.service.nds.naming.net.NetAttributeRightsEnumerator;
import com.novell.service.nds.naming.net.NetAttributes;
import com.novell.service.nds.naming.net.NetBindingEnumerator;
import com.novell.service.nds.naming.net.NetClassDefinitionsBindingEnumerator;
import com.novell.service.nds.naming.net.NetContextFactory;
import com.novell.service.nds.naming.net.NetEntryAttributes;
import com.novell.service.nds.naming.net.NetEnvironment;
import com.novell.service.nds.naming.net.NetFilteredBindingEnumerator;
import com.novell.service.nds.naming.net.NetFilteredNameClassEnumerator;
import com.novell.service.nds.naming.net.NetJavaContainerDirContext;
import com.novell.service.nds.naming.net.NetNameClassPairEnumerator;
import com.novell.service.nds.naming.net.NetSearchEnumerator;
import com.novell.service.nds.naming.net.PartitionContextFactory;
import com.novell.service.nds.naming.net.SchemaContextFactory;
import com.novell.service.nds.naming.net.SchemaStaticDirContext;
import com.novell.service.nds.net.NetAttributeValue;
import com.novell.service.nds.net.NetAttributeValueFactory;
import com.novell.service.nds.net.NetStream;
import com.novell.service.session.SessionException;
import com.novell.service.toolkit.jcl.NWInteger;
import com.novell.utility.naming.Environment;
import com.sun.jndi.toolkit.ctx.ComponentDirContext;
import com.sun.jndi.toolkit.ctx.Continuation;
import com.sun.jndi.toolkit.ctx.HeadTail;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.CompositeName;
import javax.naming.CompoundName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.SizeLimitExceededException;
import javax.naming.directory.Attribute;
import javax.naming.directory.AttributeModificationException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;

public class NetDirContext
extends ComponentDirContext
implements NdsObject,
NdsDataAccessor,
NdsDirContextWrappable {
    protected static NetContextFactory factory = new NetContextFactory();
    protected static SchemaContextFactory schemaFactory = new SchemaContextFactory();
    protected static PartitionContextFactory partitionFactory = new PartitionContextFactory();
    protected static NdsNamingExceptionFactory exceptionFactory = new NdsNamingExceptionFactory();
    protected String distinguishedName;
    protected NdsObjectInfo objectInfo;
    protected NetEnvironment environment;
    protected NameParser nameParser;
    protected NdsName components;

    protected NetDirContext(String string, NdsObjectInfo ndsObjectInfo, NetEnvironment netEnvironment) throws NamingException {
        this.distinguishedName = string;
        this.objectInfo = ndsObjectInfo;
        this.environment = (NetEnvironment)netEnvironment.clone();
        this.nameParser = new NdsNameParser(this.getTreeName());
    }

    public String getNameInNamespace() throws NamingException {
        return this.distinguishedName;
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        return this.environment.addToEnvironment(string, object);
    }

    public Object removeFromEnvironment(String string) throws NamingException {
        return this.environment.removeFromEnvironment(string);
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.environment.getEnvironment();
    }

    public void close() throws NamingException {
    }

    protected HeadTail p_parseComponent(Name name, Continuation continuation) throws NamingException {
        Name name2;
        Name name3;
        if (name.isEmpty()) {
            return new HeadTail(this.nameParser.parse(""), name.getSuffix(0));
        }
        if (name instanceof CompoundName) {
            return new HeadTail(name, new CompositeName());
        }
        if (name.get(0).equals("")) {
            name3 = this.nameParser.parse("");
            name2 = name.getSuffix(0);
        } else {
            name3 = this.nameParser.parse(name.get(0));
            name2 = name.getSuffix(1);
        }
        return new HeadTail(name3, name2);
    }

    protected Object c_resolveIntermediate_nns(Name name, Continuation continuation) throws NamingException {
        try {
            return this.c_lookup_nns(name, continuation);
        }
        catch (NamingException namingException) {
            namingException.appendRemainingComponent("");
            throw namingException;
        }
    }

    protected void c_bind(Name name, Object object, Continuation continuation) throws NamingException {
        if (object instanceof NdsObject) {
            NdsObject ndsObject = (NdsObject)object;
            if (this.getTreeName().equalsIgnoreCase(ndsObject.getTreeName())) {
                BasicAttributes basicAttributes = new BasicAttributes(true);
                try {
                    basicAttributes.put("Object Class", new NdsClassName("Alias"));
                    basicAttributes.put("Aliased Object Name", new NdsDistinguishedName(ndsObject.getDistinguishedName()));
                }
                catch (Exception exception) {
                    InvalidAttributeValueException invalidAttributeValueException = new InvalidAttributeValueException();
                    continuation.setError((Object)this, name.toString());
                    invalidAttributeValueException.setRootCause(exception);
                    throw continuation.fillInException(invalidAttributeValueException);
                }
                this.createSubcontext(name, (Attributes)basicAttributes);
                return;
            }
            continuation.setError((Object)this, name.toString());
            throw continuation.fillInException(new NamingException());
        }
        Attributes attributes = new BasicAttributes();
        attributes = JavaObject.encodeObject('#', object, attributes, false);
        this.c_createSubcontext(name, attributes, continuation);
    }

    protected Context c_createSubcontext(Name name, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name.toString());
        throw continuation.fillInException(new OperationNotSupportedException());
    }

    protected void c_destroySubcontext(Name name, Continuation continuation) throws NamingException {
        try {
            NetService netService = this.environment.getService();
            NdsName ndsName = (NdsName)name.clone();
            ndsName.addAll(0, this.getNameInstance());
            netService.removeObject(ndsName.getCanonicalString());
            continuation.setSuccess();
            return;
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            continuation.setError((Object)this, name.toString());
            throw continuation.fillInException(namingException);
        }
        catch (SessionException sessionException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(sessionException);
            continuation.setError((Object)this, name.toString());
            throw continuation.fillInException(namingException);
        }
    }

    protected NameParser c_getNameParser(Name name, Continuation continuation) throws NamingException {
        if (!this.valid_context(name, continuation)) {
            NameNotFoundException nameNotFoundException = new NameNotFoundException();
            continuation.setError((Object)this, name.toString());
            throw continuation.fillInException(nameNotFoundException);
        }
        continuation.setSuccess();
        return this.nameParser;
    }

    protected NamingEnumeration c_list(Name name, Continuation continuation) throws NamingException {
        NdsName ndsName = (NdsName)name.clone();
        ndsName.addAll(0, this.getNameInstance());
        return new NetNameClassPairEnumerator(ndsName.getCanonicalString(), this.environment);
    }

    protected NamingEnumeration c_listBindings(Name name, Continuation continuation) throws NamingException {
        NdsName ndsName = (NdsName)name.clone();
        ndsName.addAll(0, this.getNameInstance());
        return new NetBindingEnumerator(ndsName.getCanonicalString(), this.environment);
    }

    protected Object c_lookup(Name name, Continuation continuation) throws NamingException {
        try {
            Object object;
            if (name.isEmpty()) {
                object = factory.getContextInstance(this.getNameInstance().getCanonicalString(), this.objectInfo, this.environment);
            } else {
                NdsName ndsName = (NdsName)name.clone();
                ndsName.addAll(0, this.getNameInstance());
                object = factory.getContextInstance(ndsName.getCanonicalString(), this.environment);
            }
            if (object instanceof NetJavaContainerDirContext) {
                object = ((NetJavaContainerDirContext)object).decodeObject();
            }
            continuation.setSuccess();
            return object;
        }
        catch (NamingException namingException) {
            continuation.setError((Object)this, name.toString());
            throw continuation.fillInException(namingException);
        }
    }

    protected Object c_lookupLink(Name name, Continuation continuation) throws NamingException {
        try {
            Context context;
            NetEnvironment netEnvironment = (NetEnvironment)this.environment.clone();
            netEnvironment.setServiceKey("com.novell.service.jncpv2.net.AliasNetService.1049854532");
            if (name.isEmpty()) {
                context = factory.getContextInstance(this.getNameInstance().getCanonicalString(), this.objectInfo, netEnvironment);
            } else {
                NdsName ndsName = (NdsName)name.clone();
                ndsName.addAll(0, this.getNameInstance());
                context = factory.getContextInstance(ndsName.getCanonicalString(), netEnvironment);
            }
            continuation.setSuccess();
            return context;
        }
        catch (NamingException namingException) {
            continuation.setError((Object)this, name.toString());
            throw continuation.fillInException(namingException);
        }
    }

    protected void c_rebind(Name name, Object object, Continuation continuation) throws NamingException {
        try {
            this.c_unbind(name, continuation);
        }
        catch (NameNotFoundException nameNotFoundException) {}
        this.c_bind(name, object, continuation);
    }

    protected void c_rename(Name name, Name name2, Continuation continuation) throws NamingException {
        NetService netService = this.environment.getService();
        NdsName ndsName = !(name2 instanceof NdsName) ? (NdsName)this.nameParser.parse(name2.toString()) : (NdsName)name2.clone();
        NdsName ndsName2 = (NdsName)name.clone();
        if (name.isEmpty()) {
            InvalidNameException invalidNameException = new InvalidNameException();
            continuation.setError((Object)this, name.toString());
            throw continuation.fillInException(invalidNameException);
        }
        if (name2.isEmpty()) {
            InvalidNameException invalidNameException = new InvalidNameException();
            continuation.setError((Object)this, name2.toString());
            throw continuation.fillInException(invalidNameException);
        }
        ndsName2.addAll(0, this.getNameInstance());
        ndsName.addAll(0, this.getNameInstance());
        try {
            String string = ((NdsName)ndsName2.getPrefix(ndsName2.size() - 1)).getTypelessName().getCanonicalString();
            String string2 = ((NdsName)ndsName.getPrefix(ndsName.size() - 1)).getTypelessName().getCanonicalString();
            if (string.equalsIgnoreCase(string2)) {
                netService.modifyRDN(ndsName2.getCanonicalString(), ndsName.getCanonicalString(), true);
            } else {
                netService.modifyDN(ndsName2.getCanonicalString(), ndsName.getCanonicalString(), true);
            }
            continuation.setSuccess();
            return;
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            continuation.setError((Object)this, ndsName2.getCanonicalString());
            throw continuation.fillInException(namingException);
        }
        catch (SessionException sessionException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(sessionException);
            continuation.setError((Object)this, ndsName2.getCanonicalString());
            throw continuation.fillInException(namingException);
        }
    }

    protected void c_unbind(Name name, Continuation continuation) throws NamingException {
        NetService netService = this.environment.getService();
        NdsName ndsName = (NdsName)name.clone();
        ndsName.addAll(0, this.getNameInstance());
        try {
            netService.removeObject(ndsName.getCanonicalString());
            continuation.setSuccess();
            return;
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            continuation.setError((Object)this, name.toString());
            throw continuation.fillInException(namingException);
        }
        catch (SessionException sessionException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(sessionException);
            continuation.setError((Object)this, name.toString());
            throw continuation.fillInException(namingException);
        }
    }

    protected void c_bind_nns(Name name, Object object, Continuation continuation) throws NamingException {
        if (name.isEmpty()) {
            OperationNotSupportedException operationNotSupportedException = new OperationNotSupportedException();
            continuation.setErrorNNS((Object)this, name.toString());
            throw continuation.fillInException(operationNotSupportedException);
        }
        Object object2 = this.c_lookup_nns(name, continuation);
        if (object2 != null) {
            continuation.setContinue(object2, name, this);
        }
    }

    protected Context c_createSubcontext_nns(Name name, Continuation continuation) throws NamingException {
        if (name.isEmpty()) {
            OperationNotSupportedException operationNotSupportedException = new OperationNotSupportedException();
            continuation.setErrorNNS((Object)this, name.toString());
            throw continuation.fillInException(operationNotSupportedException);
        }
        Object object = this.c_lookup_nns(name, continuation);
        if (object != null) {
            continuation.setContinue(object, name, this);
        }
        return null;
    }

    protected void c_destroySubcontext_nns(Name name, Continuation continuation) throws NamingException {
        if (name.isEmpty()) {
            OperationNotSupportedException operationNotSupportedException = new OperationNotSupportedException();
            continuation.setErrorNNS((Object)this, name.toString());
            throw continuation.fillInException(operationNotSupportedException);
        }
        Object object = this.c_lookup_nns(name, continuation);
        if (object != null) {
            continuation.setContinue(object, name, this);
        }
    }

    protected NameParser c_getNameParser_nns(Name name, Continuation continuation) throws NamingException {
        Object object = this.c_lookup_nns(name, continuation);
        if (object != null) {
            continuation.setContinue(object, name, this);
        }
        return null;
    }

    protected NamingEnumeration c_list_nns(Name name, Continuation continuation) throws NamingException {
        Object object = this.c_lookup_nns(name, continuation);
        if (object != null) {
            continuation.setContinue(object, name, this);
        }
        return null;
    }

    protected NamingEnumeration c_listBindings_nns(Name name, Continuation continuation) throws NamingException {
        Object object = this.c_lookup_nns(name, continuation);
        if (object != null) {
            continuation.setContinue(object, name, this);
        }
        return null;
    }

    protected Object c_lookup_nns(Name name, Continuation continuation) throws NamingException {
        NetDirContext netDirContext = (NetDirContext)this.c_lookup(name, continuation);
        if (netDirContext.getNNSP() == null) {
            continuation.setErrorNNS((Object)this, name.toString());
            throw continuation.fillInException(new NameNotFoundException());
        }
        continuation.setSuccess();
        return netDirContext.getNNSP();
    }

    protected Object c_lookupLink_nns(Name name, Continuation continuation) throws NamingException {
        return this.c_lookup_nns(name, continuation);
    }

    protected void c_rebind_nns(Name name, Object object, Continuation continuation) throws NamingException {
        if (name.isEmpty()) {
            OperationNotSupportedException operationNotSupportedException = new OperationNotSupportedException();
            continuation.setErrorNNS((Object)this, name.toString());
            throw continuation.fillInException(operationNotSupportedException);
        }
        object = this.c_lookup_nns(name, continuation);
        if (object != null) {
            continuation.setContinue(object, name, this);
        }
    }

    protected void c_rename_nns(Name name, Name name2, Continuation continuation) throws NamingException {
        if (name.isEmpty()) {
            OperationNotSupportedException operationNotSupportedException = new OperationNotSupportedException();
            continuation.setErrorNNS((Object)this, name.toString());
            throw continuation.fillInException(operationNotSupportedException);
        }
        Object object = this.c_lookup_nns(name, continuation);
        if (object != null) {
            continuation.setContinue(object, name, this);
        }
    }

    protected void c_unbind_nns(Name name, Continuation continuation) throws NamingException {
        if (name.isEmpty()) {
            OperationNotSupportedException operationNotSupportedException = new OperationNotSupportedException();
            continuation.setErrorNNS((Object)this, name.toString());
            throw continuation.fillInException(operationNotSupportedException);
        }
        Object object = this.c_lookup_nns(name, continuation);
        if (object != null) {
            continuation.setContinue(object, name, this);
        }
    }

    protected void c_bind(Name name, Object object, Attributes attributes, Continuation continuation) throws NamingException {
        if (object instanceof NetDirContext) {
            this.createSubcontext(name, attributes);
            return;
        }
        if (object instanceof DirContext) {
            DirContext dirContext = (DirContext)object;
            this.c_bind(name, object, continuation);
            if (attributes != null) {
                try {
                    dirContext.modifyAttributes("", 2, attributes);
                    return;
                }
                catch (NamingException namingException) {
                    this.c_unbind(name, continuation);
                    throw namingException;
                }
            }
        }
    }

    protected DirContext c_createSubcontext(Name name, Attributes attributes, Continuation continuation) throws NamingException {
        NetBuffer netBuffer;
        Object object;
        Object object2;
        NetService netService = this.environment.getService();
        Vector<Object> vector = new Vector<Object>();
        NdsName ndsName = (NdsName)name.clone();
        ndsName.addAll(0, this.getNameInstance());
        try {
            object2 = attributes.getAll();
            object = new NetAttributeValueFactory();
            netBuffer = new NetBuffer(netService, 7, this.environment.getBatchSize());
            while (object2.hasMoreElements()) {
                Attribute attribute = object2.next();
                NamingEnumeration<?> namingEnumeration = attribute.getAll();
                netBuffer.putAttributeName(attribute.getID());
                while (namingEnumeration.hasMoreElements()) {
                    Object e = namingEnumeration.nextElement();
                    NetAttributeValue netAttributeValue = ((NetAttributeValueFactory)object).getValueInstance(e);
                    if (netAttributeValue instanceof NetStream) {
                        vector.addElement(netAttributeValue);
                        vector.addElement(attribute);
                        vector.addElement(new Integer(1));
                        netBuffer.putAttributeValue(netAttributeValue.getNdsSyntaxId(), null);
                        continue;
                    }
                    netBuffer.putAttributeValue(netAttributeValue.getNdsSyntaxId(), netAttributeValue.toByte());
                }
            }
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            continuation.setError((Object)this, name.toString());
            throw continuation.fillInException(namingException);
        }
        catch (Exception exception) {
            NamingException namingException = new NamingException();
            continuation.setError((Object)this, name.toString());
            namingException.setRootCause(exception);
            throw continuation.fillInException(namingException);
        }
        try {
            netService.addObject(ndsName.getCanonicalString(), null, false, netBuffer.getHandle());
        }
        catch (NSIException nSIException) {
            object = exceptionFactory.getNamingException(nSIException);
            continuation.setError((Object)this, name.toString());
            throw continuation.fillInException((NamingException)object);
        }
        catch (SessionException sessionException) {
            object = new NamingException();
            ((NamingException)object).setRootCause(sessionException);
            continuation.setError((Object)this, ndsName.toString());
            throw continuation.fillInException((NamingException)object);
        }
        this.transferStreamBytesAfterAttrPut(vector, this.environment, ndsName.getCanonicalString());
        object2 = this.c_lookup(name, continuation);
        if (object2 instanceof DirContext) {
            return (DirContext)object2;
        }
        return null;
    }

    protected Attributes c_getAttributes(Name name, String[] stringArray, Continuation continuation) throws NamingException {
        try {
            String string = this.environment.getObjectAttributeLevel();
            NdsName ndsName = (NdsName)name.clone();
            ndsName.addAll(0, this.getNameInstance());
            BasicAttributes basicAttributes = string.equals("OBJECT_ATTRS") ? new NetAttributes(ndsName.getCanonicalString(), this.environment, stringArray) : (string.equals("OBJECT_ATTR_NAMES") ? new NetAttributes(ndsName.getCanonicalString(), this.environment, stringArray) : (string.equals("DSI_OBJECT_ATTRS") ? new NetEntryAttributes(ndsName.getCanonicalString(), stringArray, this.environment) : new BasicAttributes(true)));
            return basicAttributes;
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            continuation.setError((Object)this, name.toString());
            throw continuation.fillInException(namingException);
        }
        catch (NamingException namingException) {
            continuation.setError((Object)this, name.toString());
            throw continuation.fillInException(namingException);
        }
    }

    protected DirContext c_getSchema(Name name, Continuation continuation) throws NamingException {
        try {
            NdsName ndsName = (NdsName)this.nameParser.parse("SC=Schema");
            Context context = schemaFactory.getContextInstance(ndsName.getCanonicalString(), "Schema Container", this.environment);
            continuation.setSuccess();
            return (DirContext)context;
        }
        catch (NamingException namingException) {
            continuation.setError((Object)this, name.toString());
            throw continuation.fillInException(namingException);
        }
    }

    protected DirContext c_getSchemaClassDefinition(Name name, Continuation continuation) throws NamingException {
        NetDirContext cfr_ignored_0 = (NetDirContext)this.c_lookup(name, continuation);
        try {
            Attributes attributes = this.c_getAttributes(name, new String[]{"Object Class"}, continuation);
            NetClassDefinitionsBindingEnumerator netClassDefinitionsBindingEnumerator = new NetClassDefinitionsBindingEnumerator(attributes.get("Object Class").getAll(), this.environment);
            SchemaStaticDirContext schemaStaticDirContext = new SchemaStaticDirContext("[Root]", netClassDefinitionsBindingEnumerator, this.environment);
            continuation.setSuccess();
            return schemaStaticDirContext;
        }
        catch (NamingException namingException) {
            continuation.setError((Object)this, name.toString());
            throw continuation.fillInException(namingException);
        }
    }

    protected void c_modifyAttributes(Name name, int n, Attributes attributes, Continuation continuation) throws NamingException {
        Object object;
        Object object2;
        NetBuffer netBuffer;
        NetService netService = this.environment.getService();
        Vector<Object> vector = new Vector<Object>();
        NdsName ndsName = (NdsName)name.clone();
        ndsName.addAll(0, this.getNameInstance());
        try {
            netBuffer = new NetBuffer(netService, 9, this.environment.getBatchSize());
            NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
            while (namingEnumeration.hasMoreElements()) {
                Attribute attribute = namingEnumeration.next();
                if (n == 3 && attribute.size() == 0) {
                    netBuffer.putChange(1, attribute.getID());
                    continue;
                }
                if (n == 2) {
                    netBuffer.putChange(6, attribute.getID());
                }
                object2 = attribute.getAll();
                while (object2.hasMoreElements()) {
                    if (n == 3) {
                        netBuffer.putChange(3, attribute.getID());
                    } else {
                        netBuffer.putChange(2, attribute.getID());
                    }
                    NdsAttributeValue ndsAttributeValue = (NdsAttributeValue)object2.nextElement();
                    object = ndsAttributeValue instanceof NetAttributeValue ? (NetAttributeValue)ndsAttributeValue : NetAttributeValueFactory.createValue(ndsAttributeValue);
                    if (object instanceof NetStream) {
                        vector.addElement(object);
                        vector.addElement(attribute);
                        vector.addElement(new Integer(n));
                        continue;
                    }
                    netBuffer.putAttributeValue(object.getNdsSyntaxId(), object.toByte());
                }
            }
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            continuation.setError((Object)this, name.toString());
            throw continuation.fillInException(namingException);
        }
        catch (Exception exception) {
            continuation.setError((Object)this, name.toString());
            throw new NamingException();
        }
        object2 = new NetIterationHandle(netService, 9);
        boolean bl = false;
        try {
            netService.modifyObject(ndsName.getCanonicalString(), (NetIterationHandle)object2, bl, netBuffer.getHandle());
        }
        catch (NSIException nSIException) {
            object = new AttributeModificationException();
            ((AttributeModificationException)object).setUnexecutedModifications(null);
            continuation.setError((Object)this, name.toString());
            ((NamingException)object).setRootCause(nSIException);
            throw continuation.fillInException((NamingException)object);
        }
        catch (SessionException sessionException) {
            object = new NamingException();
            ((NamingException)object).setRootCause(sessionException);
            continuation.setError((Object)this, ndsName.toString());
            throw continuation.fillInException((NamingException)object);
        }
        this.transferStreamBytesAfterAttrPut(vector, this.environment, ndsName.getCanonicalString());
        continuation.setSuccess();
    }

    protected void c_modifyAttributes(Name name, ModificationItem[] modificationItemArray, Continuation continuation) throws NamingException {
        NetBuffer netBuffer;
        NetService netService = this.environment.getService();
        Vector<Object> vector = new Vector<Object>();
        NdsName ndsName = (NdsName)name.clone();
        ndsName.addAll(0, this.getNameInstance());
        NetIterationHandle netIterationHandle = new NetIterationHandle(netService, 9);
        boolean bl = false;
        try {
            netBuffer = new NetBuffer(netService, 9, 64512);
            int n = 0;
            while (n < modificationItemArray.length) {
                int n2 = 0;
                ModificationItem modificationItem = modificationItemArray[n];
                Attribute attribute = modificationItem.getAttribute();
                int n3 = modificationItem.getModificationOp();
                if (n3 == 3 && attribute.size() == 0) {
                    netBuffer.putChange(1, attribute.getID());
                } else {
                    if (n3 == 2) {
                        netBuffer.putChange(6, attribute.getID());
                    }
                    NamingEnumeration<?> namingEnumeration = attribute.getAll();
                    while (namingEnumeration.hasMoreElements()) {
                        NdsAttributeValue ndsAttributeValue = (NdsAttributeValue)namingEnumeration.nextElement();
                        NetAttributeValue netAttributeValue = ndsAttributeValue instanceof NetAttributeValue ? (NetAttributeValue)ndsAttributeValue : NetAttributeValueFactory.createValue(ndsAttributeValue);
                        if (netAttributeValue instanceof NetStream) {
                            vector.addElement(netAttributeValue);
                            vector.addElement(attribute);
                            vector.addElement(new Integer(n3));
                            continue;
                        }
                        byte[] byArray = netAttributeValue.toByte();
                        int n4 = byArray.length;
                        if (n4 > 64512) {
                            throw new SizeLimitExceededException();
                        }
                        if (n2 + n4 > 64512) {
                            this.doModify(netService, ndsName, netIterationHandle, bl, netBuffer, name, continuation);
                            netBuffer = new NetBuffer(netService, 9, 64512);
                            n2 = 0;
                        }
                        n2 += n4;
                        if (n3 == 3) {
                            netBuffer.putChange(3, attribute.getID());
                        } else {
                            netBuffer.putChange(2, attribute.getID());
                        }
                        netBuffer.putAttributeValue(netAttributeValue.getNdsSyntaxId(), byArray);
                    }
                }
                ++n;
            }
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            continuation.setError((Object)this, name.toString());
            throw continuation.fillInException(namingException);
        }
        catch (Exception exception) {
            continuation.setError((Object)this, name.toString());
            throw new NamingException();
        }
        this.doModify(netService, ndsName, netIterationHandle, bl, netBuffer, name, continuation);
        this.transferStreamBytesAfterAttrPut(vector, this.environment, ndsName.getCanonicalString());
        continuation.setSuccess();
    }

    private void doModify(NetService netService, NdsName ndsName, NetIterationHandle netIterationHandle, boolean bl, NetBuffer netBuffer, Name name, Continuation continuation) throws NamingException {
        try {
            netService.modifyObject(ndsName.getCanonicalString(), netIterationHandle, bl, netBuffer.getHandle());
            return;
        }
        catch (NSIException nSIException) {
            AttributeModificationException attributeModificationException = new AttributeModificationException();
            attributeModificationException.setUnexecutedModifications(null);
            continuation.setError((Object)this, name.toString());
            attributeModificationException.setRootCause(nSIException);
            throw continuation.fillInException(attributeModificationException);
        }
        catch (SessionException sessionException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(sessionException);
            continuation.setError((Object)this, ndsName.toString());
            throw continuation.fillInException(namingException);
        }
    }

    protected void c_rebind(Name name, Object object, Attributes attributes, Continuation continuation) throws NamingException {
        if (this.valid_context(name, continuation)) {
            this.c_unbind(name, continuation);
        }
        this.c_bind(name, object, attributes, continuation);
    }

    protected NamingEnumeration c_search(Name name, Attributes attributes, String[] stringArray, Continuation continuation) throws NamingException {
        NdsName ndsName = (NdsName)name.clone();
        ndsName.addAll(0, this.getNameInstance());
        return new NetSearchEnumerator(ndsName.getCanonicalString(), this.environment, attributes, stringArray);
    }

    protected NamingEnumeration c_search(Name name, String string, SearchControls searchControls, Continuation continuation) throws NamingException {
        return this.c_search(name, string, null, searchControls, continuation);
    }

    protected NamingEnumeration c_search(Name name, String string, Object[] objectArray, SearchControls searchControls, Continuation continuation) throws NamingException {
        NdsName ndsName = (NdsName)name.clone();
        ndsName.addAll(0, this.getNameInstance());
        return new NetSearchEnumerator(ndsName.getCanonicalString(), this.c_getSchema(ndsName, continuation), this.environment, string, objectArray, searchControls);
    }

    protected void c_bind_nns(Name name, Object object, Attributes attributes, Continuation continuation) throws NamingException {
        Object object2 = this.c_lookup_nns(name, continuation);
        if (object2 != null) {
            continuation.setContinue(object2, name, this);
        }
    }

    protected DirContext c_createSubcontext_nns(Name name, Attributes attributes, Continuation continuation) throws NamingException {
        Object object = this.c_lookup_nns(name, continuation);
        if (object != null) {
            continuation.setContinue(object, name, this);
        }
        return null;
    }

    protected Attributes c_getAttributes_nns(Name name, String[] stringArray, Continuation continuation) throws NamingException {
        Object object = this.c_lookup_nns(name, continuation);
        if (object != null) {
            continuation.setContinue(object, name, this);
        }
        return null;
    }

    protected DirContext c_getSchema_nns(Name name, Continuation continuation) throws NamingException {
        Object object = this.c_lookup_nns(name, continuation);
        if (object != null) {
            continuation.setContinue(object, name, this);
        }
        return null;
    }

    protected DirContext c_getSchemaClassDefinition_nns(Name name, Continuation continuation) throws NamingException {
        Object object = this.c_lookup_nns(name, continuation);
        if (object != null) {
            continuation.setContinue(object, name, this);
        }
        return null;
    }

    protected void c_modifyAttributes_nns(Name name, int n, Attributes attributes, Continuation continuation) throws NamingException {
        Object object = this.c_lookup_nns(name, continuation);
        if (object != null) {
            continuation.setContinue(object, name, this);
        }
    }

    protected void c_modifyAttributes_nns(Name name, ModificationItem[] modificationItemArray, Continuation continuation) throws NamingException {
        Object object = this.c_lookup_nns(name, continuation);
        if (object != null) {
            continuation.setContinue(object, name, this);
        }
    }

    protected void c_rebind_nns(Name name, Object object, Attributes attributes, Continuation continuation) throws NamingException {
        Object object2 = this.c_lookup_nns(name, continuation);
        if (object2 != null) {
            continuation.setContinue(object2, name, this);
        }
    }

    protected NamingEnumeration c_search_nns(Name name, Attributes attributes, String[] stringArray, Continuation continuation) throws NamingException {
        Object object = this.c_lookup_nns(name, continuation);
        if (object != null) {
            continuation.setContinue(object, name, this);
        }
        return null;
    }

    protected NamingEnumeration c_search_nns(Name name, String string, SearchControls searchControls, Continuation continuation) throws NamingException {
        Object object = this.c_lookup_nns(name, continuation);
        if (object != null) {
            continuation.setContinue(object, name, this);
        }
        return null;
    }

    protected NamingEnumeration c_search_nns(Name name, String string, Object[] objectArray, SearchControls searchControls, Continuation continuation) throws NamingException {
        Object object = this.c_lookup_nns(name, continuation);
        if (object != null) {
            continuation.setContinue(object, name, this);
        }
        return null;
    }

    public Reference getReference() throws NamingException {
        return null;
    }

    public Context getPartitionRoot(String string) throws NamingException {
        return this.getPartitionRoot(new CompositeName(string));
    }

    public Context getPartitionRoot(Name name) throws NamingException {
        if (!name.isEmpty()) {
            Object object = this.lookup(name);
            if (object instanceof Partitionable) {
                return ((Partitionable)object).getPartitionRoot("");
            }
            throw new OperationNotSupportedException();
        }
        return partitionFactory.getContextInstance("", "Partition Root", this.environment);
    }

    public DirContext getPartition(String string) throws NamingException {
        return this.getPartition(new CompositeName(string));
    }

    public DirContext getPartition(Name name) throws NamingException {
        if (!name.isEmpty()) {
            Object object = this.lookup(name);
            if (object instanceof Partitionable) {
                return ((Partitionable)object).getPartition("");
            }
            throw new OperationNotSupportedException();
        }
        StringBuffer stringBuffer = new StringBuffer();
        NetService netService = this.environment.getService();
        try {
            netService.getPartitionRoot(this.distinguishedName, stringBuffer);
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            throw namingException;
        }
        catch (SessionException sessionException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(sessionException);
            throw namingException;
        }
        return (DirContext)partitionFactory.getContextInstance(new String(stringBuffer), "Partition", this.environment);
    }

    public NdsIterator createIterator(String string, Attributes attributes, String[] stringArray) throws NSIException {
        try {
            NdsName ndsName = (NdsName)this.nameParser.parse(string);
            ndsName.addAll(0, this.getNameInstance());
            return new BasicNdsIterator(ndsName.getCanonicalString(), this.environment, attributes, stringArray);
        }
        catch (NamingException namingException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(namingException);
            throw nSIException;
        }
    }

    public NdsIterator createIterator(String string, Attributes attributes) throws NSIException {
        return this.createIterator(string, attributes, null);
    }

    public NdsIterator createIterator(String string, String string2, NdsIteratorControls ndsIteratorControls) throws NSIException {
        return this.createIterator(string, string2, null, ndsIteratorControls);
    }

    public NdsIterator createIterator(String string, String string2, Object[] objectArray, NdsIteratorControls ndsIteratorControls) throws NSIException {
        try {
            NdsName ndsName = (NdsName)this.nameParser.parse(string);
            ndsName.addAll(0, this.getNameInstance());
            return new BasicNdsIterator(ndsName.getCanonicalString(), this.getSchema(ndsName), this.environment, string2, objectArray, ndsIteratorControls);
        }
        catch (NamingException namingException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(namingException);
            throw nSIException;
        }
    }

    public NdsIterator createIterator(String string, NdsIteratorControls ndsIteratorControls, String string2, String string3) throws NSIException {
        try {
            NdsName ndsName = (NdsName)this.nameParser.parse(string);
            ndsName.addAll(0, this.getNameInstance());
            return new ListNdsIterator(ndsName.getCanonicalString(), this.environment, string2, string3, ndsIteratorControls);
        }
        catch (NamingException namingException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(namingException);
            throw nSIException;
        }
    }

    public String getDistinguishedName() {
        return this.distinguishedName;
    }

    public int getObjectFlags() throws NSIException {
        return this.objectInfo.getObjectFlags();
    }

    public int getSubordinateCount() throws NSIException {
        return this.objectInfo.getSubordinateCount();
    }

    public Date getModificationTime() throws NSIException {
        Date date = new Date();
        date.setTime((long)this.objectInfo.getModificationTime() * 1000L);
        return date;
    }

    public String getBaseClass() throws NSIException {
        return this.objectInfo.getBaseClass();
    }

    public String getTreeName() {
        return this.environment.getHost();
    }

    public NdsObjectRights getObjectEffectiveRights(String string) throws NSIException {
        if (string.equalsIgnoreCase("[Public]") || string.equalsIgnoreCase("[Root]") || string.equalsIgnoreCase("[Creator]") || string.equalsIgnoreCase("[Self]")) {
            NetService netService;
            NWInteger nWInteger = new NWInteger(0);
            try {
                netService = this.environment.getService();
            }
            catch (NamingException namingException) {
                NSIException nSIException = new NSIException();
                nSIException.setRootCause(namingException);
                throw nSIException;
            }
            try {
                netService.getEffectiveRights(string, this.distinguishedName, "[Entry Rights]", nWInteger);
                return new NdsObjectRights(nWInteger.getValue());
            }
            catch (SessionException sessionException) {
                NSIException nSIException = new NSIException();
                nSIException.setRootCause(sessionException);
                throw nSIException;
            }
        }
        Context context = null;
        try {
            context = factory.getContextInstance(string, this.environment);
        }
        catch (NamingException namingException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(namingException);
            throw nSIException;
        }
        return this.getObjectEffectiveRights((NdsObject)context);
    }

    public NdsObjectRights getObjectEffectiveRights(NdsObject ndsObject) throws NSIException {
        try {
            NWInteger nWInteger = new NWInteger(0);
            NetService netService = this.environment.getService();
            netService.getEffectiveRights(ndsObject.getDistinguishedName(), this.distinguishedName, "[Entry Rights]", nWInteger);
            return new NdsObjectRights(nWInteger.getValue());
        }
        catch (NamingException namingException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(namingException);
            throw nSIException;
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public NdsAttributeRights getAttributeEffectiveRights(String string, String string2) throws NSIException {
        if (string.equalsIgnoreCase("[Public]") || string.equalsIgnoreCase("[Root]") || string.equalsIgnoreCase("[Creator]") || string.equalsIgnoreCase("[Self]")) {
            NetService netService;
            NWInteger nWInteger = new NWInteger(0);
            try {
                netService = this.environment.getService();
            }
            catch (NamingException namingException) {
                throw new NSIException();
            }
            try {
                netService.getEffectiveRights(string, this.distinguishedName, string2, nWInteger);
            }
            catch (SessionException sessionException) {
                NSIException nSIException = new NSIException();
                nSIException.setRootCause(sessionException);
                throw nSIException;
            }
            return new NdsAttributeRights(nWInteger.getValue());
        }
        NdsObject ndsObject = null;
        try {
            ndsObject = (NdsObject)this.lookup(string);
        }
        catch (NamingException namingException) {
            throw new NSIException();
        }
        return this.getAttributeEffectiveRights(ndsObject, string2);
    }

    public NdsAttributeRights getAttributeEffectiveRights(NdsObject ndsObject, String string) throws NSIException {
        NetService netService;
        NWInteger nWInteger = new NWInteger(0);
        try {
            netService = this.environment.getService();
        }
        catch (NamingException namingException) {
            throw new NSIException();
        }
        try {
            netService.getEffectiveRights(ndsObject.getDistinguishedName(), this.distinguishedName, string, nWInteger);
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
        return new NdsAttributeRights(nWInteger.getValue());
    }

    public NdsAttributeRights getAttributeEffectiveRights(String string) throws NSIException {
        if (string.equalsIgnoreCase("[Public]") || string.equalsIgnoreCase("[Root]") || string.equalsIgnoreCase("[Creator]") || string.equalsIgnoreCase("[Self]")) {
            NetService netService;
            NWInteger nWInteger = new NWInteger(0);
            try {
                netService = this.environment.getService();
            }
            catch (NamingException namingException) {
                throw new NSIException();
            }
            try {
                netService.getEffectiveRights(string, this.distinguishedName, "[All Attributes Rights]", nWInteger);
                return new NdsAttributeRights(nWInteger.getValue());
            }
            catch (SessionException sessionException) {
                NSIException nSIException = new NSIException();
                nSIException.setRootCause(sessionException);
                throw nSIException;
            }
        }
        NdsObject ndsObject = null;
        try {
            ndsObject = (NdsObject)this.lookup(string);
        }
        catch (NamingException namingException) {
            throw new NSIException();
        }
        return this.getAttributeEffectiveRights(ndsObject);
    }

    public NdsAttributeRights getAttributeEffectiveRights(NdsObject ndsObject) throws NSIException {
        return this.getAttributeEffectiveRights(ndsObject, "[All Attributes Rights]");
    }

    public NamingEnumeration getAttributesEffectiveRights(NdsObject ndsObject, String[] stringArray) throws NSIException {
        return this.getAttributesEffectiveRights(ndsObject.getDistinguishedName(), stringArray);
    }

    public NamingEnumeration getAttributesEffectiveRights(String string, String[] stringArray) throws NSIException {
        return new NetAttributeRightsEnumerator(string, this.distinguishedName, this.environment, stringArray);
    }

    public NamingEnumeration list(String string, boolean bl) throws NSIException, NamingException {
        if (bl) {
            return new NetFilteredNameClassEnumerator(string.length() == 0 ? this.distinguishedName : string, bl, this.environment);
        }
        return new NetNameClassPairEnumerator(string.length() == 0 ? this.distinguishedName : string, this.environment);
    }

    public NamingEnumeration list(String string, String string2, String string3) throws NSIException, NamingException {
        return new NetFilteredNameClassEnumerator(string.length() == 0 ? this.distinguishedName : string, string2, string3, this.environment);
    }

    public NamingEnumeration listBindings(String string, boolean bl) throws NSIException, NamingException {
        if (bl) {
            return new NetFilteredBindingEnumerator(string.length() == 0 ? this.distinguishedName : string, bl, this.environment);
        }
        return new NetBindingEnumerator(string.length() == 0 ? this.distinguishedName : string, this.environment);
    }

    public NamingEnumeration listBindings(String string, String string2, String string3) throws NSIException, NamingException {
        return new NetFilteredBindingEnumerator(string.length() == 0 ? this.distinguishedName : string, string2, string3, this.environment);
    }

    public Environment getEnvironmentInstance() throws NamingException {
        return this.environment;
    }

    protected boolean valid_context(Name name, Continuation continuation) throws NamingException {
        if (name.isEmpty()) {
            continuation.setSuccess();
            return true;
        }
        NetService netService = this.environment.getService();
        NdsName ndsName = (NdsName)name.clone();
        ndsName.addAll(0, this.getNameInstance());
        try {
            netService.resolveName(ndsName.getCanonicalString(), null, null);
            continuation.setSuccess();
            return true;
        }
        catch (NSIException nSIException) {
            if (nSIException.getCCode() == -601) {
                continuation.setSuccess();
                return false;
            }
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            continuation.setError((Object)this, name.toString());
            throw continuation.fillInException(namingException);
        }
        catch (SessionException sessionException) {
            NamingException namingException = new NamingException();
            continuation.setError((Object)this, name.toString());
            namingException.setRootCause(sessionException);
            throw continuation.fillInException(namingException);
        }
    }

    protected boolean valid_penultimate_context(Name name, Continuation continuation) throws NamingException {
        if (name.isEmpty()) {
            continuation.setSuccess();
            return false;
        }
        NdsName ndsName = (NdsName)name.clone();
        ndsName.remove(ndsName.size() - 1);
        return this.valid_context(ndsName, continuation);
    }

    protected Object getNNSP() throws NamingException {
        return null;
    }

    protected synchronized NdsName getNameInstance() throws NamingException {
        if (this.components == null) {
            this.components = (NdsName)this.nameParser.parse(this.distinguishedName);
        }
        return this.components;
    }

    protected void transferStreamBytesAfterAttrPut(Vector vector, NetEnvironment netEnvironment, String string) throws NamingException {
        Enumeration enumeration = vector.elements();
        boolean bl = false;
        Exception exception = null;
        Vector<ModificationItem> vector2 = null;
        while (enumeration.hasMoreElements()) {
            NetStream netStream = (NetStream)enumeration.nextElement();
            enumeration.hasMoreElements();
            Attribute attribute = (Attribute)enumeration.nextElement();
            enumeration.hasMoreElements();
            int n = (Integer)enumeration.nextElement();
            if (bl) {
                vector2.addElement(new ModificationItem(n, attribute));
                continue;
            }
            try {
                netStream.initialize(netEnvironment.getSession(), netEnvironment.getService(), string, attribute.getID(), netEnvironment.getBatchSize());
                netStream.transferStreamToWriteBytes();
            }
            catch (IOException iOException) {
                bl = true;
                exception = iOException;
            }
            catch (NSIException nSIException) {
                bl = true;
                exception = nSIException;
            }
            if (!bl) continue;
            vector2 = new Vector<ModificationItem>();
            vector2.addElement(new ModificationItem(n, attribute));
        }
        if (bl) {
            AttributeModificationException attributeModificationException = new AttributeModificationException();
            ModificationItem[] modificationItemArray = new ModificationItem[vector2.size()];
            int n = 0;
            while (n < modificationItemArray.length) {
                modificationItemArray[n] = (ModificationItem)vector2.elementAt(n);
                ++n;
            }
            attributeModificationException.setUnexecutedModifications(modificationItemArray);
            attributeModificationException.setRootCause(exception);
            throw attributeModificationException;
        }
    }
}

