/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds.naming.net;

import com.novell.service.jncp.NSIException;
import com.novell.service.jncpv2.net.NetBuffer;
import com.novell.service.jncpv2.net.NetIterationHandle;
import com.novell.service.jncpv2.net.NetObjectInfo;
import com.novell.service.jncpv2.net.NetService;
import com.novell.service.nds.naming.NdsNamingExceptionFactory;
import com.novell.service.nds.naming.net.NetFilter;
import com.novell.service.session.SessionException;
import com.novell.service.toolkit.jcl.NWInteger;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.naming.NamingException;

public class NetPartitionEnumerator
implements Enumeration {
    private String startObject;
    private NetService service;
    private NetIterationHandle iterationHandle;
    private NWInteger partCount;
    private NetBuffer partInfo;
    private boolean moreParts;
    private static NdsNamingExceptionFactory exceptionFactory = new NdsNamingExceptionFactory();

    protected NetPartitionEnumerator(NetService netService, String string) throws NSIException {
        this.startObject = string;
        this.service = netService;
        this.iterationHandle = new NetIterationHandle(netService, 6);
        this.partInfo = new NetBuffer(netService);
        this.partCount = new NWInteger(0);
        this.moreParts = true;
    }

    private void getPartitions() throws NSIException {
        if (!this.moreParts) {
            return;
        }
        NetBuffer netBuffer = new NetBuffer(this.service, 28, 4096);
        NetFilter netFilter = new NetFilter(this.service);
        netFilter.addFilterToken(14, "Object Class", 20);
        netFilter.addFilterToken(7);
        netFilter.addFilterToken(6, "Partition", 20);
        netFilter.addFilterToken(0);
        netFilter.putFilter(netBuffer);
        NWInteger nWInteger = new NWInteger(0);
        try {
            this.service.search(this.startObject, 2, false, netBuffer.getHandle(), 0, false, 0, this.iterationHandle, 0, nWInteger, this.partInfo.getHandle());
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
        this.moreParts = this.iterationHandle.moreIterations();
        this.partCount.setValue(this.partInfo.getObjectCount());
    }

    public boolean hasMoreElements() {
        try {
            if (this.partCount.getValue() == 0) {
                this.getPartitions();
            }
        }
        catch (NSIException nSIException) {
            this.partCount.setValue(0);
        }
        return this.partCount.getValue() != 0;
    }

    public Object nextElement() throws NoSuchElementException {
        try {
            if (this.partCount.getValue() == 0) {
                this.getPartitions();
            }
        }
        catch (NSIException nSIException) {
            throw new NoSuchElementException(nSIException.getMessage());
        }
        if (this.partCount.getValue() == 0) {
            throw new NoSuchElementException();
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            NetObjectInfo netObjectInfo = new NetObjectInfo();
            NWInteger nWInteger = new NWInteger(0);
            this.partInfo.getObjectName(stringBuffer, nWInteger, netObjectInfo);
        }
        catch (NSIException nSIException) {
            throw new NoSuchElementException(nSIException.getMessage());
        }
        this.partCount.setValue(this.partCount.getValue() - 1);
        return stringBuffer.toString();
    }

    public void closeIteration() throws NamingException {
        try {
            this.iterationHandle.closeIteration();
            return;
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            throw namingException;
        }
    }
}

