/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds.naming.net;

import com.novell.service.jncp.NSIException;
import com.novell.service.jncpv2.net.NetService;
import com.novell.service.nds.NdsBoolean;
import com.novell.service.nds.NdsTimestamp;
import com.novell.service.nds.naming.net.NetAttributeValueEnumerator;
import com.novell.service.nds.naming.net.NetEnvironment;
import com.novell.service.nds.naming.net.NetReplicaInfo;
import com.novell.service.nds.naming.net.NetReplicaInfoEnumerator;
import com.novell.service.nds.net.NetAttributeValueFactory;
import com.novell.service.session.SessionException;
import java.util.Vector;
import javax.naming.NamingException;

public class NetReplicaServerInfo {
    private String partitionName;
    private NetEnvironment netEnv;
    protected String serverName;
    protected String serverRead;
    protected int timeInSync;
    protected Vector netAddresses;
    protected NdsTimestamp modTime;
    protected boolean busyState;

    protected NetReplicaServerInfo(NetEnvironment netEnvironment, String string, String string2) throws NSIException {
        NetService netService;
        this.serverName = string2;
        this.partitionName = string;
        this.netEnv = netEnvironment;
        try {
            netService = netEnvironment.getService();
        }
        catch (NamingException namingException) {
            throw new NSIException(namingException.getMessage());
        }
        NetAttributeValueEnumerator netAttributeValueEnumerator = new NetAttributeValueEnumerator(netService, string2, "Network Address");
        this.netAddresses = new Vector();
        while (netAttributeValueEnumerator.hasMoreElements()) {
            this.netAddresses.addElement(NetAttributeValueFactory.createValue(12, (byte[])netAttributeValueEnumerator.nextElement(), null, null, this.partitionName, "Network Address"));
        }
        NetReplicaInfoEnumerator netReplicaInfoEnumerator = new NetReplicaInfoEnumerator(netService, string2);
        while (netReplicaInfoEnumerator.hasMoreElements()) {
            NetReplicaInfo netReplicaInfo = (NetReplicaInfo)netReplicaInfoEnumerator.nextElement();
            if (!netReplicaInfo.getPartitionName().equalsIgnoreCase(string)) continue;
            this.modTime = netReplicaInfo.getModificationTime();
            this.busyState = netReplicaInfo.getPartitionBusyStatus();
        }
        try {
            this.serverRead = netService.getServerDN();
            return;
        }
        catch (SessionException sessionException) {
            throw new NSIException(sessionException.getMessage());
        }
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getServerRead() {
        return this.serverRead;
    }

    public int getTimeInSync() {
        return 0;
    }

    public Vector getNetAddresses() {
        return this.netAddresses;
    }

    public NdsTimestamp getModificationTime() {
        return this.modTime;
    }

    public NdsBoolean getBusyState() {
        return new NdsBoolean(this.busyState);
    }
}

