/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds.net;

import com.novell.java.io.EndianInputStream;
import com.novell.java.io.EndianOutputStream;
import com.novell.service.jncp.NSIException;
import com.novell.service.nds.NdsNetAddress;
import com.novell.service.nds.NdsReplicaPointer;
import com.novell.service.nds.net.NetAttributeValue;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;

public final class NetReplicaPointer
extends NdsReplicaPointer
implements NetAttributeValue,
Serializable {
    protected NetReplicaPointer(byte[] byArray) throws NSIException {
        try {
            EndianInputStream endianInputStream = new EndianInputStream(byArray);
            this.serverName = endianInputStream.readLoHiChars();
            this.replicaType = endianInputStream.readLoHiInt();
            this.replicaNumber = endianInputStream.readLoHiInt();
            int n = endianInputStream.readLoHiInt();
            this.replicaAddressHint = new NdsNetAddress[n];
            int n2 = 0;
            while (n2 < n) {
                int n3 = endianInputStream.readLoHiInt();
                byte[] byArray2 = new byte[endianInputStream.readLoHiInt()];
                endianInputStream.readFully(byArray2);
                this.replicaAddressHint[n2] = new NdsNetAddress(n3, byArray2);
                ++n2;
            }
            return;
        }
        catch (IOException iOException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(iOException);
            throw nSIException;
        }
    }

    protected NetReplicaPointer(NdsReplicaPointer ndsReplicaPointer) {
        super(ndsReplicaPointer);
    }

    public byte[] toByte() throws NSIException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            EndianOutputStream endianOutputStream = new EndianOutputStream(byteArrayOutputStream);
            endianOutputStream.writeLoHiChars(this.serverName);
            endianOutputStream.writeLoHiInt(this.replicaType);
            endianOutputStream.writeLoHiInt(this.replicaNumber);
            int n = this.replicaAddressHint.length;
            endianOutputStream.writeLoHiInt(n);
            int n2 = 0;
            while (n2 < n) {
                endianOutputStream.writeLoHiInt((int)this.replicaAddressHint[n2].getType());
                endianOutputStream.writeLoHiInt((int)this.replicaAddressHint[n2].getLength());
                endianOutputStream.write(this.replicaAddressHint[n2].getAddress());
                ++n2;
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(iOException);
            throw nSIException;
        }
    }
}

