/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nw;

import com.novell.service.jncp.NSIExceptionBuilder;
import com.novell.service.nw.BinderyServerNamesEnumerator;
import com.novell.service.nw.BinderyTreeNamesEnumerator;
import com.novell.service.nw.SLPNamesEnumerator;
import com.novell.service.session.Session;
import com.novell.service.session.xplat.CallsService;
import java.util.Enumeration;
import java.util.Hashtable;

class NamesEnumeratorFactory {
    public static final int SERVERS = 1024;
    public static final int TREES = 30722;

    public static Enumeration getNamesEnumerator(int n, Hashtable hashtable) {
        try {
            Session session = (Session)hashtable.get("java.naming.session");
            CallsService callsService = (CallsService)session.getService("com.novell.service.session.xplat.CallsService.4461766964");
            if (callsService.areSLPCallsAvailable()) {
                return new SLPNamesEnumerator(n, hashtable);
            }
            if (n == 30722) {
                return new BinderyTreeNamesEnumerator(hashtable);
            }
            return new BinderyServerNamesEnumerator(hashtable);
        }
        catch (Exception exception) {
            throw NSIExceptionBuilder.build(exception);
        }
    }

    public static void closeEnumerator(Enumeration enumeration) {
        if (enumeration instanceof SLPNamesEnumerator) {
            ((SLPNamesEnumerator)enumeration).close();
        }
    }

    NamesEnumeratorFactory() {
    }
}

