/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.rfc1960;

public class SearchStringComponent {
    public static final int EQUALS = 0;
    public static final int APPROXIMATE = 1;
    public static final int GREATER_OR_EQUAL = 2;
    public static final int LESS_OR_EQUAL = 3;
    public static final int PRESENT = 4;
    public static final int SUBSTRING = 5;
    public static final String EQUALS_STRING = "equal";
    public static final String APPROXIMATE_STRING = "approximate";
    public static final String GREATER_OR_EQUAL_STRING = "greaterOrEqual";
    public static final String LESS_OR_EQUAL_STRING = "lessOrEqual";
    public static final String PRESENT_STRING = "present";
    public static final String SUBSTRING_STRING = "substring";
    protected boolean compared;
    protected int pushCount;
    protected int popCount;
    private String component;
    private String attributeId;
    private String operation;
    private String operand;
    private int operationType;
    private int offset;
    private boolean operandReplacement;
    private Object replacementObject;
    private int replacementIndex = -1;

    public String getComponent() {
        return this.component;
    }

    public String getAttributeId() {
        return this.attributeId;
    }

    public String getOperation() {
        return this.operation;
    }

    public String getOperand() {
        return this.operand;
    }

    public int getReplacementIndex() {
        if (!this.operandReplacement) {
            throw new IllegalStateException();
        }
        return this.replacementIndex;
    }

    public int getOperationType() {
        return this.operationType;
    }

    public boolean operandReplacement() {
        return this.operandReplacement;
    }

    public void setReplacementObject(Object object) {
        if (!this.operandReplacement) {
            throw new IllegalStateException();
        }
        this.replacementObject = object;
    }

    public Object getReplacementObject() {
        return this.replacementObject;
    }

    public int getOffset() {
        return this.offset;
    }

    public static String getOperationTypeDescription(int n) {
        switch (n) {
            case 0: {
                return EQUALS_STRING;
            }
            case 1: {
                return APPROXIMATE_STRING;
            }
            case 2: {
                return GREATER_OR_EQUAL_STRING;
            }
            case 3: {
                return LESS_OR_EQUAL_STRING;
            }
            case 4: {
                return PRESENT_STRING;
            }
            case 5: {
                return SUBSTRING_STRING;
            }
        }
        return null;
    }

    public static boolean compareSubString(String string, String string2, boolean bl) {
        int n = 0;
        int n2 = 0;
        boolean bl2 = true;
        boolean bl3 = true;
        if (string == null || string2 == null) {
            return false;
        }
        if (string.length() == 0 || string2.length() == 0) {
            return false;
        }
        if (bl) {
            string = string.toLowerCase();
            string2 = string2.toLowerCase();
        }
        do {
            String string3;
            int n3;
            if ((n3 = string.indexOf(42, n)) == -1) {
                string3 = string.substring(n);
                if (!bl2) {
                    bl3 = false;
                }
            } else {
                string3 = string.substring(n, n3);
            }
            if (bl2) {
                bl2 = false;
                if (n3 == 0) {
                    n = n3 + 1;
                    continue;
                }
            }
            if (string3.length() == 0) {
                return true;
            }
            int n4 = string2.indexOf(string3, n2);
            if (n4 == -1) {
                return false;
            }
            n2 = n4 + string3.length();
            n = n3 + 1;
        } while (bl3);
        return true;
    }

    public static boolean compareString(int n, String string, String string2, boolean bl) {
        if (n == 1) {
            throw new IllegalArgumentException(SearchStringComponent.getOperationTypeDescription(n));
        }
        if (n == 0) {
            if (string == null) {
                return string2 == null;
            }
            if (string2 == null) {
                return string == null;
            }
            if (bl) {
                return string.equalsIgnoreCase(string2);
            }
            return string.equals(string2);
        }
        if (n == 2) {
            if (string == null) {
                return true;
            }
            if (string2 == null) {
                return string == null;
            }
            int n2 = string2.compareTo(string);
            return n2 >= 0;
        }
        if (n == 3) {
            if (string == null) {
                return string2 == null;
            }
            if (string2 == null) {
                return true;
            }
            int n3 = string2.compareTo(string);
            return n3 <= 0;
        }
        if (n == 4) {
            return string2 != null;
        }
        return SearchStringComponent.compareSubString(string, string2, bl);
    }

    public static boolean compareInt(int n, int n2, int n3) {
        if (n == 1 || n == 5) {
            throw new IllegalArgumentException(SearchStringComponent.getOperationTypeDescription(n));
        }
        if (n == 0) {
            return n2 == n3;
        }
        if (n == 2) {
            return n3 >= n2;
        }
        if (n == 3) {
            return n3 <= n2;
        }
        return true;
    }

    public static boolean compareBoolean(int n, int n2, boolean bl) {
        if (n == 1 || n == 5 || n == 2 || n == 3) {
            throw new IllegalArgumentException(SearchStringComponent.getOperationTypeDescription(n));
        }
        if (n == 4) {
            return true;
        }
        boolean bl2 = n2 != 0;
        if (n == 0) {
            return bl2 == bl;
        }
        return false;
    }

    public static boolean compareBoolean(int n, String string, boolean bl) {
        if (n == 1 || n == 5 || n == 2 || n == 3) {
            throw new IllegalArgumentException(SearchStringComponent.getOperationTypeDescription(n));
        }
        if (n == 4) {
            return true;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        if ("t".equalsIgnoreCase(string)) {
            bl3 = true;
            bl2 = true;
        } else if ("true".equalsIgnoreCase(string)) {
            bl3 = true;
            bl2 = true;
        } else if ("f".equalsIgnoreCase(string)) {
            bl3 = false;
            bl2 = true;
        } else if ("false".equalsIgnoreCase(string)) {
            bl3 = false;
            bl2 = true;
        }
        if (!bl2) {
            return false;
        }
        if (n == 0) {
            return bl3 == bl;
        }
        return false;
    }

    public static boolean compareStringsEqual(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null) {
            return false;
        }
        if (string2 == null) {
            return false;
        }
        return string.equals(string2);
    }

    protected SearchStringComponent(String string, int n, int n2) {
        this.component = string;
        this.pushCount = n;
        this.offset = n2;
        this.popCount = 0;
        this.compared = false;
        int n3 = string.indexOf("~=", 0);
        if (n3 != -1) {
            this.operationType = 1;
            this.breakItUp(string, n3, 2);
            return;
        }
        n3 = string.indexOf(">=", 0);
        if (n3 != -1) {
            this.operationType = 2;
            this.breakItUp(string, n3, 2);
            return;
        }
        n3 = string.indexOf("<=", 0);
        if (n3 != -1) {
            this.operationType = 3;
            this.breakItUp(string, n3, 2);
            return;
        }
        n3 = string.indexOf("=", 0);
        if (n3 != -1) {
            this.operationType = 0;
            this.breakItUp(string, n3, 1);
            return;
        }
        throw new IllegalArgumentException();
    }

    private static int hexchar2int(byte by) {
        if (by >= 48 && by <= 57) {
            return by - 48;
        }
        if (by >= 65 && by <= 70) {
            return by - 65 + 10;
        }
        if (by >= 97 && by <= 102) {
            return by - 97 + 10;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String unescapeFilterValue(byte[] byArray, int n, int n2) {
        boolean bl = false;
        boolean bl2 = false;
        int n3 = n2 - n;
        byte[] byArray2 = new byte[n3];
        int n4 = 0;
        int n5 = n;
        while (n5 < n2) {
            byte by = byArray[n5];
            if (bl) {
                int n6 = SearchStringComponent.hexchar2int(by);
                if (n6 < 0) {
                    if (!bl2) throw new IllegalArgumentException();
                    bl = false;
                    byArray2[n4++] = by;
                } else if (bl2) {
                    byArray2[n4] = (byte)(n6 << 4);
                    bl2 = false;
                } else {
                    int n7 = n4++;
                    byArray2[n7] = (byte)(byArray2[n7] | (byte)n6);
                    bl = false;
                }
            } else if (by != 92) {
                byArray2[n4++] = by;
                bl = false;
            } else {
                bl = true;
                bl2 = true;
            }
            ++n5;
        }
        byte[] byArray3 = new byte[n4];
        System.arraycopy(byArray2, 0, byArray3, 0, n4);
        return new String(byArray3);
    }

    private void breakItUp(String string, int n, int n2) {
        int n3;
        int n4 = string.length();
        int n5 = n - 1;
        while (n5 >= 0) {
            n3 = string.charAt(n5);
            if (n3 != 32 && n3 != 9) {
                this.attributeId = string.substring(0, n5 + 1);
                break;
            }
            --n5;
        }
        if (n5 < 0) {
            throw new IllegalArgumentException();
        }
        this.operation = string.substring(n, n4);
        this.operand = string.substring(n + n2, n4);
        this.operand = SearchStringComponent.unescapeFilterValue(this.operand.getBytes(), 0, this.operand.length());
        this.operandReplacement = false;
        if (this.operand.charAt(0) == '{' && (n3 = this.operand.lastIndexOf(125)) != -1) {
            String string2 = this.operand.substring(1, n3);
            try {
                this.replacementIndex = Integer.parseInt(string2);
                this.operandReplacement = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (this.operationType == 0 && this.operand.length() == 1 && this.operand.charAt(0) == '*') {
            this.operationType = 4;
        }
        if (this.operationType == 0 && this.operand.length() > 1 && this.operand.indexOf(42) != -1) {
            this.operationType = 5;
        }
    }
}

