/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.security.protocols;

import com.novell.java.security.AuthenticatorChannel;
import com.novell.java.security.AuthenticatorException;
import com.novell.java.security.AuthenticatorProtocol;
import com.novell.java.security.ConfigurationException;
import com.novell.java.security.CreateTokensException;
import com.novell.java.security.GetIdentitiesException;
import com.novell.java.security.I2L;
import com.novell.java.security.Identity;
import com.novell.java.security.InvalidAuthenticatorChannelException;
import com.novell.java.security.LoginException;
import com.novell.java.security.LogoutException;
import com.novell.java.security.ModifyTokensException;
import com.novell.java.security.VerifyTokensException;
import com.novell.java.security.channels.NativeCodeChannelProxy;
import com.novell.service.security.NdsIdentity;
import com.novell.service.security.NdsIdentityScope;
import com.novell.service.security.NdsServiceIdentity;
import com.novell.service.security.protocols.XplatProtocolProxy;
import com.novell.service.session.Session;
import com.novell.service.session.SessionAttr;
import com.novell.service.session.SessionAttrs;
import com.novell.service.session.SessionEnumerator;
import com.novell.service.session.SessionManager;
import com.novell.service.session.nds.NDSShibboleth;
import com.novell.service.session.xplat.Shibboleth;
import java.util.Properties;
import java.util.Vector;

public class ServiceAuthProtocolProxy
implements AuthenticatorProtocol {
    protected AuthenticatorChannel channel = new NativeCodeChannelProxy();

    public void configure(Properties properties, String string) throws ConfigurationException {
    }

    public void init(AuthenticatorChannel authenticatorChannel) throws InvalidAuthenticatorChannelException {
        this.channel = authenticatorChannel;
    }

    public AuthenticatorChannel getChannel() {
        return this.channel;
    }

    public void login(Identity identity) throws LoginException {
        if (identity instanceof NdsServiceIdentity) {
            NdsServiceIdentity ndsServiceIdentity = (NdsServiceIdentity)identity;
            if (System.getProperty("os.name").toLowerCase().indexOf("netware") == -1) {
                throw new LoginException(I2L.getString("SERVICE_AUTH_PLATFORM_UNSUPPORTED"));
            }
            this.channel.beginProtocol(this);
            try {
                try {
                    Shibboleth shibboleth = XplatProtocolProxy.getShibboleth(ndsServiceIdentity, ndsServiceIdentity.getUserDomain());
                    if (!(shibboleth instanceof NDSShibboleth)) {
                        throw new LoginException(I2L.getString("INVALID_AUTHENTICATOR_PROTOCOL"));
                    }
                    ((NDSShibboleth)shibboleth).authenticateService(ndsServiceIdentity.getUsername());
                }
                catch (AuthenticatorException authenticatorException) {
                    throw authenticatorException;
                }
                catch (Throwable throwable) {
                    throw new LoginException(throwable);
                }
                Object var4_6 = null;
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                this.channel.endProtocol(this);
                throw throwable;
            }
            this.channel.endProtocol(this);
            return;
        }
        throw new LoginException(I2L.getString("INVALID_AUTHENTICATOR_PROTOCOL"));
    }

    public void logout(Identity identity) throws LogoutException {
        if (identity instanceof NdsServiceIdentity) {
            NdsServiceIdentity ndsServiceIdentity = (NdsServiceIdentity)identity;
            if (System.getProperty("os.name").toLowerCase().indexOf("netware") == -1) {
                throw new LoginException(I2L.getString("SERVICE_AUTH_PLATFORM_UNSUPPORTED"));
            }
            this.channel.beginProtocol(this);
            try {
                try {
                    Shibboleth shibboleth = XplatProtocolProxy.getShibboleth(ndsServiceIdentity, ndsServiceIdentity.getUserDomain());
                    shibboleth.unauthenticate();
                }
                catch (AuthenticatorException authenticatorException) {
                    throw authenticatorException;
                }
                catch (Throwable throwable) {
                    throw new LoginException(throwable);
                }
                Object var4_6 = null;
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                this.channel.endProtocol(this);
                throw throwable;
            }
            this.channel.endProtocol(this);
            return;
        }
        throw new LoginException(I2L.getString("INVALID_AUTHENTICATOR_PROTOCOL"));
    }

    public void createTokens(Identity identity) throws CreateTokensException {
        throw new CreateTokensException(I2L.getString("SERVICE_AUTH_TOKENS_UNSUPPORTED"));
    }

    public void createTokens(Identity identity, Identity identity2) throws CreateTokensException {
        throw new CreateTokensException(I2L.getString("SERVICE_AUTH_TOKENS_UNSUPPORTED"));
    }

    public void modifyTokens(Identity identity) throws ModifyTokensException {
        throw new ModifyTokensException(I2L.getString("SERVICE_AUTH_TOKENS_UNSUPPORTED"));
    }

    public void verifyTokens(Identity identity) throws VerifyTokensException {
        throw new VerifyTokensException(I2L.getString("SERVICE_AUTH_TOKENS_UNSUPPORTED"));
    }

    public Identity[] getIdentities(Identity identity) throws AuthenticatorException {
        this.channel.beginProtocol(this);
        Vector<NdsIdentity> vector = new Vector<NdsIdentity>();
        Object[] objectArray = null;
        try {
            try {
                SessionManager sessionManager = XplatProtocolProxy.getSessionManager(identity);
                NdsIdentityScope ndsIdentityScope = new NdsIdentityScope(NdsIdentityScope.ADMINISTRATIVE_DOMAIN_NAME);
                SessionAttrs sessionAttrs = new SessionAttrs();
                sessionAttrs.add(new SessionAttr("SESSION_PROVIDER", "NDS"));
                sessionAttrs.add(new SessionAttr("IS_AUTHENTICATED_STATE", new Boolean(true)));
                sessionAttrs.add(new SessionAttr("SESSION_TYPE", "TREE"));
                SessionEnumerator sessionEnumerator = sessionManager.search(sessionAttrs);
                while (sessionEnumerator.hasMoreElements()) {
                    Session session = sessionEnumerator.next();
                    NdsIdentityScope ndsIdentityScope2 = new NdsIdentityScope(this.stripUnderscores(session.getDomainName()), ndsIdentityScope);
                    NdsIdentity ndsIdentity = new NdsIdentity(session.getName(), ndsIdentityScope2);
                    vector.addElement(ndsIdentity);
                }
                objectArray = new Identity[vector.size()];
                vector.copyInto(objectArray);
            }
            catch (AuthenticatorException authenticatorException) {
                throw authenticatorException;
            }
            catch (Throwable throwable) {
                throw new GetIdentitiesException(throwable);
            }
        }
        catch (Throwable throwable) {}
        this.channel.endProtocol(this);
        return objectArray;
    }

    String stripUnderscores(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = stringBuffer.length() - 1;
        while (stringBuffer.charAt(n) == '_') {
            stringBuffer.setLength(n);
            --n;
        }
        return stringBuffer.toString();
    }
}

