/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.security.protocols;

import com.novell.java.security.Authenticator;
import com.novell.java.security.AuthenticatorChannel;
import com.novell.java.security.AuthenticatorException;
import com.novell.java.security.AuthenticatorProtocol;
import com.novell.java.security.ConfigurationException;
import com.novell.java.security.CreateTokensException;
import com.novell.java.security.GetIdentitiesException;
import com.novell.java.security.I2L;
import com.novell.java.security.Identity;
import com.novell.java.security.IdentityScope;
import com.novell.java.security.LoginException;
import com.novell.java.security.LogoutException;
import com.novell.java.security.ModifyTokensException;
import com.novell.java.security.VerifyTokensException;
import com.novell.service.security.BinderyIdentity;
import com.novell.service.security.BinderyIdentityScope;
import com.novell.service.security.NdsIdentity;
import com.novell.service.security.NdsIdentityScope;
import com.novell.service.security.Password;
import com.novell.service.security.PasswordIdentity;
import com.novell.service.security.XplatIdentity;
import com.novell.service.security.XplatIdentityScope;
import com.novell.service.security.protocols.XplatProtocolProxyGUI;
import com.novell.service.session.Session;
import com.novell.service.session.SessionAttr;
import com.novell.service.session.SessionAttrs;
import com.novell.service.session.SessionEnumerator;
import com.novell.service.session.SessionEnv;
import com.novell.service.session.SessionException;
import com.novell.service.session.SessionManager;
import com.novell.service.session.SessionManagerFactory;
import com.novell.service.session.xplat.Shibboleth;
import java.util.Properties;
import java.util.Vector;

public class XplatProtocolProxy
implements AuthenticatorProtocol {
    private static final boolean DEBUG = false;
    protected AuthenticatorChannel channel;
    private AuthenticatorProtocol guiProxy;

    public void configure(Properties properties, String string) throws ConfigurationException {
    }

    public void init(AuthenticatorChannel authenticatorChannel) {
        this.channel = authenticatorChannel;
    }

    public AuthenticatorChannel getChannel() {
        return this.channel;
    }

    public void login(Identity identity) throws LoginException {
        this.channel.beginProtocol(this);
        try {
            try {
                if (identity instanceof PasswordIdentity) {
                    XplatProtocolProxy.performLogin(identity, ((XplatIdentity)identity).getUsername(), ((XplatIdentity)identity).getUserDomain(), ((PasswordIdentity)((Object)identity)).getPassword(), null);
                } else {
                    this.getGUI().login(identity);
                }
            }
            catch (AuthenticatorException authenticatorException) {
                throw authenticatorException;
            }
            catch (Throwable throwable) {
                throw new LoginException(throwable);
            }
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.channel.endProtocol(this);
            throw throwable;
        }
        this.channel.endProtocol(this);
    }

    public void createTokens(Identity identity) throws CreateTokensException {
        this.createTokens(identity, identity);
    }

    public void createTokens(Identity identity, Identity identity2) throws CreateTokensException {
        this.channel.beginProtocol(this);
        try {
            try {
                if (identity2 instanceof PasswordIdentity) {
                    XplatProtocolProxy.performCreateTokens(identity, ((XplatIdentity)identity2).getUsername(), ((XplatIdentity)identity2).getUserDomain(), ((PasswordIdentity)((Object)identity2)).getPassword(), null);
                } else {
                    this.getGUI().createTokens(identity, identity2);
                }
            }
            catch (AuthenticatorException authenticatorException) {
                throw authenticatorException;
            }
            catch (Throwable throwable) {
                throw new CreateTokensException(throwable);
            }
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.channel.endProtocol(this);
            throw throwable;
        }
        this.channel.endProtocol(this);
    }

    public void verifyTokens(Identity identity) throws VerifyTokensException {
        this.channel.beginProtocol(this);
        try {
            try {
                if (identity instanceof PasswordIdentity) {
                    XplatProtocolProxy.performVerifyTokens(identity, ((XplatIdentity)identity).getUsername(), ((XplatIdentity)identity).getUserDomain(), ((PasswordIdentity)((Object)identity)).getPassword(), null);
                } else {
                    this.getGUI().verifyTokens(identity);
                }
            }
            catch (AuthenticatorException authenticatorException) {
                throw authenticatorException;
            }
            catch (Throwable throwable) {
                throw new VerifyTokensException(throwable);
            }
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.channel.endProtocol(this);
            throw throwable;
        }
        this.channel.endProtocol(this);
    }

    public void modifyTokens(Identity identity) throws ModifyTokensException {
        this.channel.beginProtocol(this);
        try {
            try {
                if (identity instanceof PasswordIdentity) {
                    XplatProtocolProxy.performModifyTokens(identity, ((XplatIdentity)identity).getUsername(), ((XplatIdentity)identity).getUserDomain(), ((PasswordIdentity)((Object)identity)).getPassword(), ((PasswordIdentity)((Object)identity)).getNewPassword(), null);
                } else {
                    this.getGUI().modifyTokens(identity);
                }
            }
            catch (AuthenticatorException authenticatorException) {
                throw authenticatorException;
            }
            catch (Throwable throwable) {
                throw new ModifyTokensException(throwable);
            }
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.channel.endProtocol(this);
            throw throwable;
        }
        this.channel.endProtocol(this);
    }

    public void logout(Identity identity) throws LogoutException {
        this.channel.beginProtocol(this);
        try {
            try {
                if (identity instanceof PasswordIdentity) {
                    XplatProtocolProxy.performLogout(identity, ((XplatIdentity)identity).getUsername(), ((XplatIdentity)identity).getUserDomain(), null);
                } else {
                    this.getGUI().logout(identity);
                }
            }
            catch (AuthenticatorException authenticatorException) {
                throw authenticatorException;
            }
            catch (Throwable throwable) {
                throw new LogoutException(throwable);
            }
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.channel.endProtocol(this);
            throw throwable;
        }
        this.channel.endProtocol(this);
    }

    static String getAdministrativeDomain(Identity identity) {
        IdentityScope identityScope = identity.getScope();
        if (identityScope == null) {
            if (identity instanceof NdsIdentity) {
                return NdsIdentityScope.ADMINISTRATIVE_DOMAIN_NAME;
            }
            if (identity instanceof BinderyIdentity) {
                return BinderyIdentityScope.ADMINISTRATIVE_DOMAIN_NAME;
            }
            String string = identity.getName();
            if (XplatProtocolProxy.isAdministrativeDomain(string)) {
                return string;
            }
            return "[undefined]";
        }
        return XplatProtocolProxy.getAdministrativeDomain(identityScope);
    }

    static boolean isAdministrativeDomain(String string) {
        if (string == null) {
            return false;
        }
        return string.equalsIgnoreCase(NdsIdentityScope.ADMINISTRATIVE_DOMAIN_NAME) || string.equalsIgnoreCase(BinderyIdentityScope.ADMINISTRATIVE_DOMAIN_NAME);
    }

    public Identity[] getIdentities(Identity identity) throws AuthenticatorException {
        this.channel.beginProtocol(this);
        boolean bl = true;
        boolean bl2 = true;
        if (XplatProtocolProxy.getAdministrativeDomain(identity).equalsIgnoreCase(BinderyIdentityScope.ADMINISTRATIVE_DOMAIN_NAME)) {
            bl2 = false;
        } else if (XplatProtocolProxy.getAdministrativeDomain(identity).equalsIgnoreCase(NdsIdentityScope.ADMINISTRATIVE_DOMAIN_NAME)) {
            bl = false;
        }
        Vector<NdsIdentity> vector = new Vector<NdsIdentity>();
        Object[] objectArray = null;
        try {
            try {
                XplatIdentity xplatIdentity;
                XplatIdentityScope xplatIdentityScope;
                Session session;
                SessionEnumerator sessionEnumerator;
                SessionAttrs sessionAttrs;
                XplatIdentityScope xplatIdentityScope2;
                SessionManager sessionManager = XplatProtocolProxy.getSessionManager(identity);
                if (bl2) {
                    xplatIdentityScope2 = new NdsIdentityScope(NdsIdentityScope.ADMINISTRATIVE_DOMAIN_NAME);
                    sessionAttrs = new SessionAttrs();
                    sessionAttrs.add(new SessionAttr("SESSION_PROVIDER", "NDS"));
                    sessionAttrs.add(new SessionAttr("IS_AUTHENTICATED_STATE", new Boolean(true)));
                    sessionAttrs.add(new SessionAttr("SESSION_TYPE", "TREE"));
                    sessionEnumerator = sessionManager.search(sessionAttrs);
                    while (sessionEnumerator.hasMoreElements()) {
                        session = sessionEnumerator.next();
                        xplatIdentityScope = new NdsIdentityScope(this.stripUnderscores(session.getDomainName()), xplatIdentityScope2);
                        xplatIdentity = new NdsIdentity(session.getName(), xplatIdentityScope);
                        vector.addElement((NdsIdentity)xplatIdentity);
                    }
                }
                if (bl) {
                    xplatIdentityScope2 = new BinderyIdentityScope(BinderyIdentityScope.ADMINISTRATIVE_DOMAIN_NAME);
                    sessionAttrs = new SessionAttrs();
                    sessionAttrs.add(new SessionAttr("SESSION_PROVIDER", "BINDERY"));
                    sessionAttrs.add(new SessionAttr("IS_AUTHENTICATED_STATE", new Boolean(true)));
                    sessionAttrs.add(new SessionAttr("SESSION_TYPE", "SERVER"));
                    sessionEnumerator = sessionManager.search(sessionAttrs);
                    while (sessionEnumerator.hasMoreElements()) {
                        session = sessionEnumerator.next();
                        xplatIdentityScope = new BinderyIdentityScope(this.stripUnderscores(session.getDomainName()), xplatIdentityScope2);
                        xplatIdentity = new BinderyIdentity(session.getName(), xplatIdentityScope);
                        vector.addElement((NdsIdentity)xplatIdentity);
                    }
                }
                objectArray = new Identity[vector.size()];
                vector.copyInto(objectArray);
            }
            catch (AuthenticatorException authenticatorException) {
                throw authenticatorException;
            }
            catch (Throwable throwable) {
                throw new GetIdentitiesException(throwable);
            }
        }
        catch (Throwable throwable) {}
        this.channel.endProtocol(this);
        return objectArray;
    }

    static void performLogin(Identity identity, String string, String string2, Password password, Thread thread) throws SessionException {
        Shibboleth shibboleth = XplatProtocolProxy.getShibboleth(identity, string2);
        boolean bl = false;
        if (identity instanceof NdsIdentity && ((NdsIdentity)identity).getUseExtendedCharacterPasswords()) {
            bl = true;
        }
        if (identity instanceof NdsIdentity && ((NdsIdentity)identity).getUseNAS()) {
            shibboleth.authenticateNAS((NdsIdentity)identity, string, password.getRaw(), bl);
        } else {
            shibboleth.authenticate(string, password.getRaw(), bl);
        }
        Authenticator.putLast(string, string2, thread);
    }

    static void performModifyTokens(Identity identity, String string, String string2, Password password, Password password2, Thread thread) throws SessionException {
        boolean bl = false;
        Shibboleth shibboleth = XplatProtocolProxy.getShibboleth(identity, string2);
        if (identity instanceof NdsIdentity && ((NdsIdentity)identity).getUseExtendedCharacterPasswords()) {
            bl = true;
        }
        shibboleth.changePassword(string, password.getRaw(), password2.getRaw(), bl);
        Authenticator.putLast(string, string2, thread);
    }

    static void performCreateTokens(Identity identity, String string, String string2, Password password, Thread thread) throws SessionException {
        boolean bl = false;
        Shibboleth shibboleth = XplatProtocolProxy.getShibboleth(identity, string2);
        if (identity instanceof NdsIdentity && ((NdsIdentity)identity).getUseExtendedCharacterPasswords()) {
            bl = true;
        }
        shibboleth.setPassword(string, password.getRaw(), bl);
        Authenticator.putLast(string, string2, thread);
    }

    static void performVerifyTokens(Identity identity, String string, String string2, Password password, Thread thread) throws SessionException {
        boolean bl = false;
        Shibboleth shibboleth = XplatProtocolProxy.getShibboleth(identity, string2);
        if (identity instanceof NdsIdentity && ((NdsIdentity)identity).getUseExtendedCharacterPasswords()) {
            bl = true;
        }
        shibboleth.verifyPassword(string, password.getRaw(), bl);
        Authenticator.putLast(string, string2, thread);
    }

    static void performLogout(Identity identity, String string, String string2, Thread thread) throws SessionException {
        Shibboleth shibboleth = XplatProtocolProxy.getShibboleth(identity, string2);
        if (identity instanceof NdsIdentity && ((NdsIdentity)identity).getUseNAS()) {
            shibboleth.unauthenticateNAS((NdsIdentity)identity);
        } else {
            shibboleth.unauthenticate();
        }
        Authenticator.putLast(string, string2, thread);
    }

    String stripUnderscores(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = stringBuffer.length() - 1;
        while (stringBuffer.charAt(n) == '_') {
            stringBuffer.setLength(n);
            --n;
        }
        return stringBuffer.toString();
    }

    static SessionManager getSessionManager(Identity identity) throws SessionException {
        SessionManager sessionManager = null;
        if (identity instanceof XplatIdentity && (sessionManager = ((XplatIdentity)identity).getSessionManager()) == null) {
            Session session = null;
            session = ((XplatIdentity)identity).getSession();
            if (session != null) {
                while (session.hasParent()) {
                    session = session.getParent();
                }
                sessionManager = (SessionManager)session;
            }
        }
        if (sessionManager == null) {
            sessionManager = SessionManagerFactory.getSessionManager(new SessionEnv());
        }
        return sessionManager;
    }

    static Session getSession(Identity identity, String string) throws SessionException {
        Session session = null;
        if (identity instanceof XplatIdentity) {
            session = ((XplatIdentity)identity).getSession();
        }
        if (session == null) {
            SessionManager sessionManager = XplatProtocolProxy.getSessionManager(identity);
            session = sessionManager.findSession(string);
            if (session != null) {
                SessionAttrs sessionAttrs = session.getAttributes(new String[]{"SESSION_PROVIDER"});
                String string2 = (String)sessionAttrs.getValue("SESSION_PROVIDER");
                if (identity instanceof BinderyIdentity ? string2.equals("BINDERY") : identity instanceof NdsIdentity && string2.equals("NDS")) {
                    return session;
                }
                session.close();
            }
            session = identity instanceof BinderyIdentity ? sessionManager.getSession("com.novell.service.session.bindery.BinderyInitialSession") : sessionManager.getSession("com.novell.service.session.nds.NDSInitialSession");
            session = session.getSession(string);
        }
        return session;
    }

    static Shibboleth getShibboleth(Identity identity, String string) throws SessionException {
        return (Shibboleth)XplatProtocolProxy.getSession(identity, string).getService("com.novell.service.session.xplat.Shibboleth.534154414E");
    }

    private AuthenticatorProtocol getGUI() throws ConfigurationException {
        try {
            if (this.guiProxy == null) {
                this.guiProxy = new XplatProtocolProxyGUI(this);
            }
            return this.guiProxy;
        }
        catch (Throwable throwable) {
            throw new ConfigurationException(I2L.getString("JFC_IS_REQUIRED"));
        }
    }
}

