/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.session.bindery;

import com.novell.service.jncp.NSIException;
import com.novell.service.session.InvalidDomainNameException;
import com.novell.service.session.Session;
import com.novell.service.session.SessionAttrs;
import com.novell.service.session.SessionEnumerator;
import com.novell.service.session.SessionEnv;
import com.novell.service.session.SessionException;
import com.novell.service.session.bindery.BinderyServerSessionState;
import com.novell.service.session.bindery.BinderySessionState;
import com.novell.service.session.spi.InvalidSessionState;
import com.novell.service.session.spi.SessionImpl;
import com.novell.service.session.xplat.Connection;
import com.novell.service.session.xplat.ConnectionEnumerator;
import com.novell.service.session.xplat.Connections;

public class BinderyInitialSessionState
extends BinderySessionState {
    private static final boolean DEBUG = false;
    private static final boolean ENTRY_DEBUG = false;
    private static final boolean FAIL_DEBUG = false;
    private static final boolean I_DEBUG = false;
    private static final boolean S_DEBUG = false;

    public BinderyInitialSessionState(SessionImpl sessionImpl) throws SessionException {
        super(sessionImpl);
        this.attachedSession.setState(this);
    }

    public Session getSession(String string, SessionEnv sessionEnv) throws SessionException {
        String string2 = string.toUpperCase();
        this.validateChildren();
        Session session = this.getChild(string2);
        if (session == null) {
            try {
                session = this.addNewSession(string2, sessionEnv);
            }
            catch (Exception exception) {
                throw new InvalidDomainNameException(string2, exception);
            }
        }
        return session;
    }

    public SessionAttrs getAttributes() throws SessionException {
        try {
            SessionAttrs sessionAttrs = super.getAttributes();
            String[] stringArray = new String[]{"SESSION_PROVIDER", "SESSION_TYPE", "IS_REAL"};
            sessionAttrs.modify(this.getStateAttrs(stringArray));
            return sessionAttrs;
        }
        catch (NSIException nSIException) {
            throw InvalidSessionState.makeInvalid(this.attachedSession, nSIException);
        }
    }

    public SessionAttrs getAttributes(String[] stringArray) throws SessionException {
        try {
            SessionAttrs sessionAttrs = this.getStateAttrs(stringArray);
            if (sessionAttrs.count() != stringArray.length) {
                sessionAttrs.merge(super.getAttributes(stringArray));
            }
            return sessionAttrs;
        }
        catch (NSIException nSIException) {
            throw InvalidSessionState.makeInvalid(this.attachedSession, nSIException);
        }
    }

    private SessionAttrs getStateAttrs(String[] stringArray) throws SessionException {
        SessionAttrs sessionAttrs = new SessionAttrs();
        int n = 0;
        while (n < stringArray.length) {
            if ("SESSION_TYPE".equals(stringArray[n])) {
                sessionAttrs.modify("SESSION_TYPE", "INITIAL_SESSION");
            }
            if ("SESSION_PROVIDER".equals(stringArray[n])) {
                sessionAttrs.modify("SESSION_PROVIDER", "BINDERY");
            }
            if ("IS_REAL".equals(stringArray[n])) {
                sessionAttrs.add("IS_REAL", new Boolean(false));
            }
            ++n;
        }
        return sessionAttrs;
    }

    protected void validateChildren() throws SessionException {
        Object object;
        Connections connections = this.xplatUtil.getBinderyConnections();
        SessionEnumerator sessionEnumerator = this.getChildren();
        while (sessionEnumerator.hasMoreElements()) {
            object = sessionEnumerator.next();
            int n = 0;
            try {
                BinderyServerSessionState binderyServerSessionState = (BinderyServerSessionState)((SessionImpl)object).getState();
                n = this.xplatUtil.getReference(binderyServerSessionState.getConnection());
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean bl = false;
            if (connections.get(n) != null) {
                bl = true;
                connections.remove(n);
                continue;
            }
            InvalidSessionState.makeInvalid((SessionImpl)object, new SessionException("Session not found in requester"));
        }
        ConnectionEnumerator connectionEnumerator = connections.elements();
        while (connectionEnumerator.hasMoreElements()) {
            object = connectionEnumerator.next();
            try {
                String string = this.xplatUtil.getInfoString((Connection)object, 7);
                this.addNewSession((Connection)object, string.toString(), new SessionEnv());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Session addNewSession(String string, SessionEnv sessionEnv) throws SessionException {
        return this.addNewSession(null, string, sessionEnv);
    }

    private Session addNewSession(Connection connection, String string, SessionEnv sessionEnv) throws SessionException {
        SessionImpl sessionImpl = new SessionImpl(this.attachedSession, string, (SessionEnv)sessionEnv.clone());
        new BinderyServerSessionState(sessionImpl, connection);
        this.attachedSession.addChild(sessionImpl);
        return sessionImpl;
    }
}

