/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.session.nds;

import com.novell.service.security.NdsIdentity;
import com.novell.service.session.Session;
import com.novell.service.session.SessionException;
import com.novell.service.session.nds.NDSContextSessionState;
import com.novell.service.session.spi.SessionImpl;
import com.novell.service.session.xplat.NDSContext;
import com.novell.service.session.xplat.ShibbolethImpl;

public class NDSShibboleth
extends ShibbolethImpl {
    private static final boolean DEBUG = false;
    private static final boolean I_DEBUG = false;
    private static final boolean LOGOUT_DEBUG = false;
    private static final boolean S_DEBUG = false;
    protected static final String KEY = "com.novell.service.session.xplat.Shibboleth.534154414E";
    SessionImpl origSession;
    SessionImpl treeSession;

    NDSShibboleth(SessionImpl sessionImpl) throws SessionException {
        this.origSession = sessionImpl;
        this.treeSession = this.getTreeSession(sessionImpl);
    }

    public void changePassword(String string, String string2, String string3, boolean bl) throws SessionException {
        this.getContext(this.treeSession).changePassword(string, string2, string3, bl);
    }

    public void setPassword(String string, String string2, boolean bl) throws SessionException {
        this.getContext(this.treeSession).setPassword(string, string2, bl);
    }

    public void verifyPassword(String string, String string2, boolean bl) throws SessionException {
        this.getContext(this.treeSession).verifyPassword(string, string2, bl);
    }

    public void authenticate(String string, String string2, boolean bl) throws SessionException {
        this.getContext(this.treeSession).login(string, string2, bl);
    }

    public void authenticateNAS(NdsIdentity ndsIdentity, String string, String string2, boolean bl) throws SessionException {
        this.getContext(this.treeSession).loginNAS(ndsIdentity, string, string2, bl);
    }

    public void authenticateService(String string) throws SessionException {
        this.getContext(this.origSession).loginAsService(string);
    }

    public void unauthenticate() throws SessionException {
        this.getContext(this.treeSession).logout();
    }

    public void unauthenticateNAS(NdsIdentity ndsIdentity) throws SessionException {
        this.getContext(this.treeSession).logoutNAS(ndsIdentity);
    }

    private SessionImpl getTreeSession(Session session) throws SessionException {
        String string = (String)session.getAttributes(new String[]{"SESSION_TYPE"}).getValue("SESSION_TYPE");
        if (!string.equalsIgnoreCase("TREE")) {
            session = session.getParent();
            string = (String)session.getAttributes(new String[]{"SESSION_TYPE"}).getValue("SESSION_TYPE");
            if (!string.equalsIgnoreCase("TREE")) {
                throw new SessionException(String.valueOf(string) + "!=" + "TREE");
            }
        }
        return (SessionImpl)session;
    }

    private NDSContext getContext(SessionImpl sessionImpl) throws SessionException {
        NDSContextSessionState nDSContextSessionState = (NDSContextSessionState)sessionImpl.getState();
        return nDSContextSessionState.context;
    }
}

