/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.connectionpool;

import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPSocketFactory;
import com.novell.ldap.LDAPTLSSocketFactory;
import com.novell.ldap.connectionpool.Connection;
import com.novell.ldap.connectionpool.ListOfSharedConnections;
import com.novell.ldap.connectionpool.SharedConnections;

public class PoolManager {
    private ListOfSharedConnections inUseListOfSharedConnections = new ListOfSharedConnections();
    private ListOfSharedConnections availableListOfSharedConnections = new ListOfSharedConnections();
    private boolean shuttingDown;

    public PoolManager(String string, int n, int n2, int n3, LDAPSocketFactory lDAPSocketFactory) throws LDAPException {
        for (int i = 0; i < n2; ++i) {
            SharedConnections sharedConnections = new SharedConnections(n3);
            Connection connection = new Connection(lDAPSocketFactory);
            try {
                connection.connect(string, n);
            }
            catch (LDAPException lDAPException) {
                System.out.println("Error :  " + lDAPException.getResultCode());
            }
            if (lDAPSocketFactory instanceof LDAPTLSSocketFactory) {
                connection.startTLS();
            }
            sharedConnections.add(connection);
            for (int j = 1; j < n3; ++j) {
                Connection connection2 = (Connection)connection.clone();
                sharedConnections.add(connection2);
            }
            this.availableListOfSharedConnections.add(i, sharedConnections);
        }
        this.shuttingDown = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LDAPConnection getBoundConnection(String string, byte[] byArray) throws LDAPException, InterruptedException {
        Connection connection = null;
        SharedConnections sharedConnections = null;
        boolean bl = false;
        ListOfSharedConnections listOfSharedConnections = this.inUseListOfSharedConnections;
        synchronized (listOfSharedConnections) {
            connection = this.inUseListOfSharedConnections.getAvailableConnection(string, byArray);
            if (null != connection) {
                connection.setInUse();
                return connection;
            }
        }
        listOfSharedConnections = this.availableListOfSharedConnections;
        synchronized (listOfSharedConnections) {
            sharedConnections = this.availableListOfSharedConnections.getSharedConns(string, byArray);
            if (null == sharedConnections) {
                while (0 == this.availableListOfSharedConnections.size()) {
                    this.availableListOfSharedConnections.wait();
                    if (!this.shuttingDown) continue;
                    return null;
                }
                sharedConnections = (SharedConnections)this.availableListOfSharedConnections.get(0);
                bl = true;
            }
            this.availableListOfSharedConnections.remove(sharedConnections);
            connection = (Connection)sharedConnections.get(0);
            connection.setInUse();
        }
        if (bl || !connection.isConnectionAlive()) {
            try {
                connection.poolBind(3, string, byArray);
                sharedConnections.setDN(string);
                sharedConnections.setPW(byArray);
            }
            catch (LDAPException lDAPException) {
                connection.clearInUse();
                sharedConnections.setDN(null);
                sharedConnections.setPW(null);
                ListOfSharedConnections listOfSharedConnections2 = this.availableListOfSharedConnections;
                synchronized (listOfSharedConnections2) {
                    this.availableListOfSharedConnections.add(sharedConnections);
                }
                throw lDAPException;
            }
        }
        listOfSharedConnections = this.inUseListOfSharedConnections;
        synchronized (listOfSharedConnections) {
            this.inUseListOfSharedConnections.add(sharedConnections);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeConnectionAvailable(LDAPConnection lDAPConnection) {
        SharedConnections sharedConnections = null;
        ListOfSharedConnections listOfSharedConnections = this.inUseListOfSharedConnections;
        synchronized (listOfSharedConnections) {
            ((Connection)lDAPConnection).clearInUse();
            sharedConnections = this.inUseListOfSharedConnections.getSharedConns((Connection)lDAPConnection);
            if (sharedConnections == null) {
                sharedConnections = this.availableListOfSharedConnections.getSharedConns((Connection)lDAPConnection);
            }
            if (sharedConnections.allConnectionsAvailable()) {
                this.inUseListOfSharedConnections.remove(sharedConnections);
            } else {
                sharedConnections = null;
            }
        }
        if (null != sharedConnections) {
            listOfSharedConnections = this.availableListOfSharedConnections;
            synchronized (listOfSharedConnections) {
                this.availableListOfSharedConnections.add(sharedConnections);
                this.availableListOfSharedConnections.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        ListOfSharedConnections listOfSharedConnections = this.availableListOfSharedConnections;
        synchronized (listOfSharedConnections) {
            this.shuttingDown = true;
            this.availableListOfSharedConnections.notifyAll();
        }
    }
}

