/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.controls;

import com.novell.ldap.LDAPControl;
import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.LBEREncoder;

public class LDAPPagedResultsControl
extends LDAPControl {
    private static String requestOID = "1.2.840.113556.1.4.319";
    private static String responseOID = "1.2.840.113556.1.4.319";
    private static final byte[] EMPTY_COOKIE = new byte[0];
    private int pageSize;
    private byte[] Cookie;

    public LDAPPagedResultsControl(int n, byte[] byArray, boolean bl) {
        super(requestOID, bl, null);
        this.pageSize = n;
        this.Cookie = byArray;
        this.setEncodedValue();
    }

    private void setEncodedValue() {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.add(new ASN1Integer(this.pageSize));
        aSN1Sequence.add(new ASN1OctetString(this.Cookie == null ? EMPTY_COOKIE : this.Cookie));
        this.setValue(aSN1Sequence.getEncoding(new LBEREncoder()));
    }

    public LDAPPagedResultsControl(int n, boolean bl) {
        this(n, null, bl);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int n) {
        this.pageSize = n;
        this.setEncodedValue();
    }

    public byte[] getCookie() {
        return this.Cookie;
    }

    public void setCookie(byte[] byArray) {
        this.Cookie = byArray;
        this.setEncodedValue();
    }

    static {
        try {
            LDAPControl.register(responseOID, Class.forName("com.novell.ldap.controls.LDAPPagedResultsResponse"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

