/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds.skeleton;

import com.novell.nds.dirxml.driver.Trace;
import com.novell.nds.dirxml.driver.xds.QueryResultDocument;
import com.novell.nds.dirxml.driver.xds.WriteableDocument;
import com.novell.nds.dirxml.driver.xds.XDSCommandDocument;
import com.novell.nds.dirxml.driver.xds.XDSProductElement;
import com.novell.nds.dirxml.driver.xds.XDSQueryElement;
import com.novell.nds.dirxml.driver.xds.XDSReadAttrElement;
import com.novell.nds.dirxml.driver.xds.XDSResultDocument;
import com.novell.nds.dirxml.driver.xds.XDSSearchAttrElement;
import com.novell.nds.dirxml.driver.xds.XDSSearchClassElement;
import com.novell.nds.dirxml.driver.xds.XDSSourceElement;
import java.io.IOException;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public abstract class CommonImpl {
    private static final String PRODUCT_NAME = "DirXML Skeleton Driver (Java, XDS)";
    private static final String COMPANY_NAME = "My Company Name";
    private static final String VERSION = "3.5.2";
    protected static final String TRACE_ID = "Skeleton Driver";
    protected Map driverParams = null;
    protected String driverRDN = null;
    protected Trace trace = null;
    protected boolean connected = false;

    protected CommonImpl() {
    }

    protected void setDriverParams(Map params) {
        this.driverParams = params;
    }

    Map getDriverParams() {
        return this.driverParams;
    }

    protected void setDriverRDN(String name) {
        this.driverRDN = name;
    }

    protected String getDriverRDN() {
        return this.driverRDN == null ? TRACE_ID : this.driverRDN;
    }

    protected void setTrace() {
        this.trace = new Trace(null);
    }

    protected void appendSourceInfo(WriteableDocument doc) {
        if (doc != null) {
            XDSSourceElement source = doc.appendSourceElement();
            XDSProductElement product = source.appendProductElement();
            product.setBuild("20070620_0505");
            product.setInstance(this.driverRDN);
            product.setVersion(VERSION);
            product.appendText(PRODUCT_NAME);
            source.appendContactElement(COMPANY_NAME);
        }
    }

    protected XDSResultDocument newResultDoc() {
        XDSResultDocument resultDoc = new XDSResultDocument();
        this.appendSourceInfo((WriteableDocument)resultDoc);
        return resultDoc;
    }

    protected XDSCommandDocument newCommandDoc() {
        XDSCommandDocument commandDoc = new XDSCommandDocument();
        this.appendSourceInfo((WriteableDocument)commandDoc);
        return commandDoc;
    }

    protected static String toLiteral(String string) {
        return string == null ? null : "'" + string + "'";
    }

    protected void connect() throws IOException {
        this.trace.trace("connect", 1);
        if (!this.connected) {
            this.connected = true;
        }
    }

    protected void disconnect() {
        this.trace.trace("disconnect", 1);
        this.connected = false;
    }

    protected void queryHandler(XDSQueryElement query, QueryResultDocument result) {
        this.trace.trace("queryHandler", 1);
        if (query == null) {
            return;
        }
        this.trace.trace("queryHandler: association      == " + CommonImpl.toLiteral(query.extractAssociationText()));
        this.trace.trace("queryHandler: class-name       == " + CommonImpl.toLiteral(query.getClassName()));
        this.trace.trace("queryHandler: dest-dn          == " + CommonImpl.toLiteral(query.getDestDN()));
        this.trace.trace("queryHandler: event-id         == " + CommonImpl.toLiteral(query.getEventID()));
        this.trace.trace("queryHandler: max-result-count == " + query.getMaxResultCount());
        this.trace.trace("queryHandler: qualified-src-dn == " + CommonImpl.toLiteral(query.getQualifiedSrcDN()));
        this.trace.trace("queryHandler: scope            == " + CommonImpl.toLiteral(query.getScope().toString()));
        this.trace.trace("queryHandler: src-dn           == " + CommonImpl.toLiteral(query.getSrcDN()));
        this.trace.trace("queryHandler: src-entry-id     == " + CommonImpl.toLiteral(query.getSrcEntryID()));
        List searchClasses = query.extractSearchClassElements();
        ListIterator l = searchClasses.listIterator();
        while (l.hasNext()) {
            XDSSearchClassElement sc = (XDSSearchClassElement)l.next();
            this.trace.trace("queryHandler: search-class     == " + CommonImpl.toLiteral(sc.getClassName()));
        }
        List searchAttrs = query.extractSearchAttrElements();
        l = searchAttrs.listIterator();
        while (l.hasNext()) {
            XDSSearchAttrElement sa = (XDSSearchAttrElement)l.next();
            this.trace.trace("queryHandler: search-attr      == " + CommonImpl.toLiteral(sa.getAttrName()));
        }
        List readAttrs = query.extractReadAttrElements();
        l = readAttrs.listIterator();
        while (l.hasNext()) {
            XDSReadAttrElement ra = (XDSReadAttrElement)l.next();
            this.trace.trace("queryHandler: read-attr        == " + CommonImpl.toLiteral(ra.getAttrName()));
        }
        this.trace.trace("queryHandler: contains query token?       " + query.containsQueryToken());
        this.trace.trace("queryHandler: contains read attrs?        " + query.containsReadAttrElements());
        this.trace.trace("queryHandler: contains search attrs?      " + query.containsSearchAttrElements());
        this.trace.trace("queryHandler: contains search classes?    " + query.containsSearchClassElements());
        this.trace.trace("queryHandler: has entry scope?            " + query.hasEntryScope());
        this.trace.trace("queryHandler: has subordinates scope?     " + query.hasSubordinatesScope());
        this.trace.trace("queryHandler: has subtree scope?          " + query.hasSubtreeScope());
        this.trace.trace("queryHandler: has limited results?        " + query.hasLimitedResults());
        this.trace.trace("queryHandler: has unlimited results?      " + query.hasUnlimitedResults());
        this.trace.trace("queryHandler: has root base object?       " + query.hasRootBaseObject());
        this.trace.trace("queryHandler: is cancelled query?         " + query.isCancelled());
        this.trace.trace("queryHandler: is extended query?          " + query.isExtended());
        this.trace.trace("queryHandler: is identity query?          " + query.isIdentity());
        this.trace.trace("queryHandler: is initial query?           " + query.isInitialQuery());
        this.trace.trace("queryHandler: is subsequent query?        " + query.isSubsequentQuery());
        this.trace.trace("queryHandler: should read attrs?          " + query.shouldReadAttributes());
        this.trace.trace("queryHandler: should read parent?         " + query.shouldReadParent());
        this.trace.trace("queryHandler: should search all classes?  " + query.shouldSearchAllClasses());
    }
}

