/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds.skeleton;

import com.novell.nds.dirxml.driver.DriverShim;
import com.novell.nds.dirxml.driver.PublicationShim;
import com.novell.nds.dirxml.driver.SubscriptionShim;
import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.DataType;
import com.novell.nds.dirxml.driver.xds.EnumConstraint;
import com.novell.nds.dirxml.driver.xds.Parameter;
import com.novell.nds.dirxml.driver.xds.RegExConstraint;
import com.novell.nds.dirxml.driver.xds.RequiredConstraint;
import com.novell.nds.dirxml.driver.xds.StatusDocument;
import com.novell.nds.dirxml.driver.xds.StatusLevel;
import com.novell.nds.dirxml.driver.xds.StatusType;
import com.novell.nds.dirxml.driver.xds.ValueType;
import com.novell.nds.dirxml.driver.xds.WriteableDocument;
import com.novell.nds.dirxml.driver.xds.XDSAttrDefElement;
import com.novell.nds.dirxml.driver.xds.XDSClassDefElement;
import com.novell.nds.dirxml.driver.xds.XDSInitDocument;
import com.novell.nds.dirxml.driver.xds.XDSResultDocument;
import com.novell.nds.dirxml.driver.xds.XDSSchemaDefElement;
import com.novell.nds.dirxml.driver.xds.XDSSchemaResultDocument;
import com.novell.nds.dirxml.driver.xds.XDSStatusElement;
import com.novell.nds.dirxml.driver.xds.skeleton.CommonImpl;
import com.novell.nds.dirxml.driver.xds.skeleton.SkeletonPublicationShim;
import com.novell.nds.dirxml.driver.xds.skeleton.SkeletonSubscriptionShim;
import com.novell.nds.dirxml.driver.xds.util.StatusAttributes;
import com.novell.nds.dirxml.driver.xds.util.XDSUtil;
import java.util.HashMap;

public class SkeletonDriverShim
extends CommonImpl
implements DriverShim {
    private static final int NO_OF_PARAMS = 9;
    private static final String TAG_OPTION_1 = "option-1";
    private static final String TAG_OPTION_2 = "option-2";
    private static final String TAG_OPTION_3 = "option-3";
    private static final String TAG_OPTION_4 = "option-4";
    private static final String TAG_OPTION_5 = "option-5";
    private static final String TAG_OPTION_6 = "option-6";
    private static final String DEFAULT_OPTION_1 = "any string will do";
    private static final String DEFAULT_OPTION_2 = "10";
    private static final String DEFAULT_OPTION_3 = "true";
    private static final String DEFAULT_OPTION_4 = "1";
    private static final String DEFAULT_OPTION_5 = null;
    private static final String DEFAULT_OPTION_6 = null;
    private static final String DEFAULT_SERVER = null;
    private static final String DEFAULT_USER = null;
    private static final String DEFAULT_PASSWORD = null;
    private static final String APPLICATION_NAME = "Skeleton Application";
    private SkeletonSubscriptionShim subscriptionShim;
    private SkeletonPublicationShim publicationShim;

    public SkeletonDriverShim() {
        this.setDriverRDN("Skeleton Driver");
        this.setTrace();
        this.setDriverParams();
        this.subscriptionShim = null;
        this.publicationShim = null;
    }

    private void setDriverParams() {
        this.driverParams = new HashMap(9);
        Parameter param = new Parameter(TAG_OPTION_1, DEFAULT_OPTION_1, DataType.STRING);
        this.driverParams.put(param.tagName(), param);
        param = new Parameter(TAG_OPTION_2, DEFAULT_OPTION_2, DataType.INT);
        this.driverParams.put(param.tagName(), param);
        param = new Parameter(TAG_OPTION_3, DEFAULT_OPTION_3, DataType.BOOLEAN);
        this.driverParams.put(param.tagName(), param);
        param = new Parameter(TAG_OPTION_4, DEFAULT_OPTION_4, DataType.INT);
        EnumConstraint enumConstraint = new EnumConstraint();
        enumConstraint.addLiterals(new String[]{DEFAULT_OPTION_4, "2", "3"});
        param.add((Constraint)enumConstraint);
        this.driverParams.put(param.tagName(), param);
        param = new Parameter(TAG_OPTION_5, DEFAULT_OPTION_5, DataType.STRING);
        RegExConstraint regex = new RegExConstraint("a*b");
        param.add((Constraint)regex);
        this.driverParams.put(param.tagName(), param);
        param = new Parameter(TAG_OPTION_6, DEFAULT_OPTION_6, DataType.STRING);
        param.add((Constraint)RequiredConstraint.REQUIRED);
        this.driverParams.put(param.tagName(), param);
        param = new Parameter("server", DEFAULT_SERVER, DataType.STRING);
        this.driverParams.put(param.tagName(), param);
        param = new Parameter("user", DEFAULT_USER, DataType.STRING);
        this.driverParams.put(param.tagName(), param);
        param = new Parameter("password", DEFAULT_PASSWORD, DataType.STRING);
        this.driverParams.put(param.tagName(), param);
    }

    public XmlDocument init(XmlDocument initXML) {
        this.trace.trace("init", 1);
        XDSResultDocument result = new XDSResultDocument();
        try {
            XDSInitDocument init = new XDSInitDocument(initXML);
            this.setDriverRDN(init.rdn());
            this.setTrace();
            this.appendSourceInfo((WriteableDocument)result);
            init.parameters(this.driverParams);
            if (this.driverParams.get("server").toString() == null && this.driverParams.get("user").toString() == null && this.driverParams.get("password").toString() == null) {
                StatusAttributes attrs = StatusAttributes.factory((StatusLevel)StatusLevel.FATAL, (StatusType)StatusType.DRIVER_GENERAL, null);
                XDSUtil.appendStatus((StatusDocument)result, (StatusAttributes)attrs, (String)"Missing authentication information.");
            } else {
                this.subscriptionShim = new SkeletonSubscriptionShim(this);
                this.publicationShim = new SkeletonPublicationShim(this);
                StatusAttributes attrs = StatusAttributes.factory((StatusLevel)StatusLevel.SUCCESS, (StatusType)StatusType.DRIVER_STATUS, null);
                XDSStatusElement status = XDSUtil.appendStatus((StatusDocument)result, (StatusAttributes)attrs, null);
                status.parametersAppend(this.driverParams);
            }
        }
        catch (Exception e) {
            StatusAttributes attrs = StatusAttributes.factory((StatusLevel)StatusLevel.FATAL, (StatusType)StatusType.DRIVER_STATUS, null);
            XDSUtil.appendStatus((StatusDocument)result, (StatusAttributes)attrs, null, (Exception)e, (boolean)XDSUtil.appendStackTrace((Exception)e), (XmlDocument)initXML);
        }
        return result.toXML();
    }

    public XmlDocument shutdown(XmlDocument reasonXML) {
        this.trace.trace("shutdown", 1);
        XDSResultDocument result = this.newResultDoc();
        try {
            if (this.publicationShim != null) {
                this.publicationShim.shutdown();
            }
            if (this.subscriptionShim != null) {
                this.subscriptionShim.shutdown();
            }
            StatusAttributes attrs = StatusAttributes.factory((StatusLevel)StatusLevel.SUCCESS, (StatusType)StatusType.DRIVER_STATUS, null);
            XDSUtil.appendStatus((StatusDocument)result, (StatusAttributes)attrs, null);
        }
        catch (Exception e) {
            StatusAttributes attrs = StatusAttributes.factory((StatusLevel)StatusLevel.FATAL, (StatusType)StatusType.DRIVER_STATUS, null);
            XDSUtil.appendStatus((StatusDocument)result, (StatusAttributes)attrs, null, (Exception)e, (boolean)true, null);
        }
        return result.toXML();
    }

    public SubscriptionShim getSubscriptionShim() {
        this.trace.trace("getSubscriptionShim", 1);
        return this.subscriptionShim;
    }

    public PublicationShim getPublicationShim() {
        this.trace.trace("getPublicationShim", 1);
        return this.publicationShim;
    }

    public XmlDocument getSchema(XmlDocument initXML) {
        this.trace.trace("getSchema", 1);
        XDSSchemaResultDocument result = new XDSSchemaResultDocument();
        try {
            XDSInitDocument init = new XDSInitDocument(initXML);
            this.setDriverRDN(init.rdn());
            this.setTrace();
            this.appendSourceInfo((WriteableDocument)result);
            init.parameters(this.driverParams);
            XDSSchemaDefElement schemaDef = result.appendSchemaDefElement();
            schemaDef.setApplicationName(APPLICATION_NAME);
            schemaDef.setHierarchical(true);
            XDSClassDefElement classDef = schemaDef.appendClassDefElement();
            classDef.setClassName("fake-class-1");
            classDef.setContainer(true);
            XDSAttrDefElement attrDef = classDef.appendAttrDefElement();
            attrDef.setAttrName("fake-attr-1");
            attrDef.setCaseSensitive(true);
            attrDef.setMultiValued(true);
            attrDef.setNaming(true);
            attrDef.setReadOnly(true);
            attrDef.setRequired(true);
            attrDef.setType(ValueType.STRING);
            classDef = schemaDef.appendClassDefElement();
            classDef.setClassName("fake-class-2");
            classDef.setContainer(false);
            attrDef = classDef.appendAttrDefElement();
            attrDef.setAttrName("fake-attr-2");
            attrDef.setCaseSensitive(false);
            attrDef.setMultiValued(false);
            attrDef.setNaming(false);
            attrDef.setReadOnly(false);
            attrDef.setRequired(false);
            attrDef.setType(ValueType.INT);
            StatusAttributes attrs = StatusAttributes.factory((StatusLevel)StatusLevel.WARNING, (StatusType)StatusType.DRIVER_GENERAL, null);
            XDSUtil.appendStatus((StatusDocument)result, (StatusAttributes)attrs, (String)"Get schema not implemented.");
        }
        catch (Exception e) {
            result.empty();
            StatusAttributes attrs = StatusAttributes.factory((StatusLevel)StatusLevel.FATAL, (StatusType)StatusType.DRIVER_STATUS, null);
            XDSUtil.appendStatus((StatusDocument)result, (StatusAttributes)attrs, null, (Exception)e, (boolean)XDSUtil.appendStackTrace((Exception)e), (XmlDocument)initXML);
        }
        return result.toXML();
    }
}

