/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds.skeleton;

import com.novell.nds.dirxml.driver.DriverFilter;
import com.novell.nds.dirxml.driver.PublicationShim;
import com.novell.nds.dirxml.driver.XmlCommandProcessor;
import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.driver.XmlQueryProcessor;
import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.DataType;
import com.novell.nds.dirxml.driver.xds.Parameter;
import com.novell.nds.dirxml.driver.xds.QueryResultDocument;
import com.novell.nds.dirxml.driver.xds.RangeConstraint;
import com.novell.nds.dirxml.driver.xds.StatusDocument;
import com.novell.nds.dirxml.driver.xds.StatusLevel;
import com.novell.nds.dirxml.driver.xds.StatusType;
import com.novell.nds.dirxml.driver.xds.WriteableDocument;
import com.novell.nds.dirxml.driver.xds.XDSCommandDocument;
import com.novell.nds.dirxml.driver.xds.XDSCommandResultDocument;
import com.novell.nds.dirxml.driver.xds.XDSException;
import com.novell.nds.dirxml.driver.xds.XDSHeartbeatDocument;
import com.novell.nds.dirxml.driver.xds.XDSInitDocument;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.nds.dirxml.driver.xds.XDSQueryDocument;
import com.novell.nds.dirxml.driver.xds.XDSQueryElement;
import com.novell.nds.dirxml.driver.xds.XDSQueryResultDocument;
import com.novell.nds.dirxml.driver.xds.XDSResultDocument;
import com.novell.nds.dirxml.driver.xds.XDSStatusElement;
import com.novell.nds.dirxml.driver.xds.skeleton.CommonImpl;
import com.novell.nds.dirxml.driver.xds.skeleton.SkeletonDriverShim;
import com.novell.nds.dirxml.driver.xds.util.StatusAttributes;
import com.novell.nds.dirxml.driver.xds.util.XDSUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;

public class SkeletonPublicationShim
extends CommonImpl
implements PublicationShim,
XmlQueryProcessor {
    private static final int NO_OF_PARAMS = 3;
    private static final String TAG_PUB_1 = "pub-1";
    private static final String TAG_POLLING_INTERVAL = "polling-interval";
    private static final String TAG_HEARTBEAT_INTERVAL = "pub-heartbeat-interval";
    private static final String DEFAULT_PUB_1 = "String for Publisher";
    private static final String DEFAULT_POLLING_INTERVAL = "10";
    private static final String DEFAULT_HEARTBEAT_INTERVAL = "0";
    private boolean shutdown;
    private long pollingInterval;
    private long heartbeatInterval;
    private boolean doHeartbeat;
    private long interval;
    private Object semaphore;
    private DriverFilter filter;
    private Map pubParams;
    private SkeletonDriverShim driver;

    SkeletonPublicationShim(SkeletonDriverShim someDriver) {
        this.driver = someDriver;
        this.setDriverRDN(this.driver.getDriverRDN());
        this.setTrace();
        this.setDriverParams(this.driver.getDriverParams());
        this.setPubParams();
        this.shutdown = false;
        this.pollingInterval = -1L;
        this.semaphore = new short[0];
        this.filter = null;
        this.doHeartbeat = false;
    }

    private void setPubParams() {
        this.pubParams = new HashMap(3);
        Parameter param = new Parameter(TAG_PUB_1, DEFAULT_PUB_1, DataType.STRING);
        this.pubParams.put(param.tagName(), param);
        param = new Parameter(TAG_POLLING_INTERVAL, DEFAULT_POLLING_INTERVAL, DataType.INT);
        param.add((Constraint)RangeConstraint.POSITIVE);
        this.pubParams.put(param.tagName(), param);
        param = new Parameter(TAG_HEARTBEAT_INTERVAL, DEFAULT_HEARTBEAT_INTERVAL, DataType.INT);
        param.add((Constraint)RangeConstraint.NON_NEGATIVE);
        this.pubParams.put(param.tagName(), param);
    }

    public XmlDocument init(XmlDocument initXML) {
        this.trace.trace("init", 1);
        XDSResultDocument result = this.newResultDoc();
        try {
            XDSInitDocument init = new XDSInitDocument(initXML);
            init.parameters(this.pubParams);
            Parameter param = (Parameter)this.pubParams.get(TAG_POLLING_INTERVAL);
            this.pollingInterval = XDSUtil.toMillis((int)param.toInteger());
            param = (Parameter)this.pubParams.get(TAG_HEARTBEAT_INTERVAL);
            this.heartbeatInterval = XDSUtil.toMillis((int)(param.toInteger() * 60));
            this.doHeartbeat = this.heartbeatInterval > 0L;
            this.interval = this.doHeartbeat ? Math.min(this.pollingInterval, this.heartbeatInterval) : this.pollingInterval;
            this.filter = init.driverFilter();
            StatusAttributes attrs = StatusAttributes.factory((StatusLevel)StatusLevel.SUCCESS, (StatusType)StatusType.DRIVER_STATUS, null);
            XDSStatusElement status = XDSUtil.appendStatus((StatusDocument)result, (StatusAttributes)attrs, null);
            status.parametersAppend(this.pubParams);
        }
        catch (Exception e) {
            StatusAttributes attrs = StatusAttributes.factory((StatusLevel)StatusLevel.FATAL, (StatusType)StatusType.DRIVER_STATUS, null);
            XDSUtil.appendStatus((StatusDocument)result, (StatusAttributes)attrs, null, (Exception)e, (boolean)XDSUtil.appendStackTrace((Exception)e), (XmlDocument)initXML);
        }
        return result.toXML();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlDocument start(XmlCommandProcessor processor) {
        this.trace.trace("start", 1);
        XDSResultDocument result = this.newResultDoc();
        XmlDocument heartbeat = new XDSHeartbeatDocument().toXML();
        StatusAttributes shutdownAttrs = StatusAttributes.factory((StatusLevel)StatusLevel.SUCCESS, (StatusType)StatusType.DRIVER_STATUS, null);
        long lastPollTime = this.pollingInterval;
        long lastBeatTime = this.heartbeatInterval;
        try {
            while (!this.shutdown) {
                try {
                    boolean published = false;
                    if (lastPollTime >= this.pollingInterval) {
                        this.connect();
                        published = this.poll(processor);
                        lastPollTime = 0L;
                    }
                    if (published) {
                        lastBeatTime = 0L;
                    } else if (lastBeatTime >= this.heartbeatInterval) {
                        lastBeatTime = 0L;
                        if (this.doHeartbeat) {
                            this.trace.trace("sending heartbeat", 2);
                            processor.execute(heartbeat, (XmlQueryProcessor)this);
                        }
                    }
                    long sleep = Math.min(this.pollingInterval - lastPollTime, this.heartbeatInterval - lastBeatTime);
                    if (sleep == 0L) {
                        sleep = this.interval;
                    }
                    Object object = this.semaphore;
                    synchronized (object) {
                        long start = System.currentTimeMillis();
                        this.trace.trace("sleeping for " + sleep / 1000L + " seconds", 2);
                        this.semaphore.wait(sleep);
                        long elapsedTime = System.currentTimeMillis() - start;
                        lastPollTime += elapsedTime;
                        lastBeatTime += elapsedTime;
                    }
                }
                catch (IOException io) {
                    this.disconnect();
                    this.connect();
                }
                catch (InterruptedException ie) {
                }
            }
            XDSUtil.appendStatus((StatusDocument)result, (StatusAttributes)shutdownAttrs, null);
        }
        catch (Exception e) {
            shutdownAttrs.setLevel(StatusLevel.FATAL);
            XDSUtil.appendStatus((StatusDocument)result, (StatusAttributes)shutdownAttrs, null, (Exception)e, (boolean)true, null);
        }
        finally {
            this.trace.trace("stopping...", 2);
            this.disconnect();
        }
        return result.toXML();
    }

    private boolean poll(XmlCommandProcessor processor) {
        this.trace.trace("poll", 1);
        if (Math.random() > 0.35) {
            this.trace.trace("nothing to do", 2);
            return false;
        }
        String eventID = DEFAULT_HEARTBEAT_INTERVAL;
        XDSCommandResultDocument response = null;
        XDSCommandDocument command = this.newCommandDoc();
        StatusAttributes pollAttrs = StatusAttributes.factory((StatusLevel)StatusLevel.WARNING, (StatusType)StatusType.DRIVER_GENERAL, (String)eventID);
        XDSUtil.appendStatus((StatusDocument)command, (StatusAttributes)pollAttrs, (String)"Publisher not implemented.");
        try {
            command.validate();
        }
        catch (XDSParseException xds) {
            pollAttrs = StatusAttributes.factory((StatusLevel)StatusLevel.WARNING, (StatusType)StatusType.DRIVER_GENERAL, null);
            XDSUtil.appendStatus((StatusDocument)command, (StatusAttributes)pollAttrs, (String)"Document is invalid.", (Exception)((Object)xds), (boolean)false, null);
        }
        response = null;
        try {
            response = new XDSCommandResultDocument(processor.execute(command.toXML(), (XmlQueryProcessor)this));
            StatusLevel level = response.mostSevereStatusLevel(eventID);
            this.trace.trace("start: status == " + SkeletonPublicationShim.toLiteral(level.toString()), 3);
        }
        catch (XDSParseException xds) {
            command = this.newCommandDoc();
            pollAttrs = StatusAttributes.factory((StatusLevel)StatusLevel.ERROR, (StatusType)StatusType.DRIVER_GENERAL, null);
            XDSUtil.appendStatus((StatusDocument)command, (StatusAttributes)pollAttrs, (String)"Document is invalid.", (Exception)((Object)xds), (boolean)false, (XmlDocument)response.toXML());
            processor.execute(command.toXML(), (XmlQueryProcessor)this);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        this.trace.trace("shutdown", 1);
        this.shutdown = true;
        Object object = this.semaphore;
        synchronized (object) {
            this.semaphore.notifyAll();
        }
    }

    public XmlDocument query(XmlDocument queryXML) {
        this.trace.trace("query", 1);
        XDSQueryResultDocument result = new XDSQueryResultDocument();
        this.appendSourceInfo((WriteableDocument)result);
        String eventID = null;
        try {
            XDSQueryDocument queryDoc = new XDSQueryDocument(queryXML);
            ListIterator q = queryDoc.extractQueryElements().listIterator();
            while (q.hasNext()) {
                XDSQueryElement query = (XDSQueryElement)q.next();
                eventID = query.getEventID();
                this.queryHandler(query, (QueryResultDocument)result);
                StatusAttributes attrs = StatusAttributes.factory((StatusLevel)StatusLevel.SUCCESS, (StatusType)StatusType.DRIVER_GENERAL, (String)eventID);
                XDSUtil.appendStatus((StatusDocument)result, (StatusAttributes)attrs, null);
            }
        }
        catch (XDSException xds) {
            StatusAttributes attrs = StatusAttributes.factory((StatusLevel)StatusLevel.ERROR, (StatusType)StatusType.DRIVER_GENERAL, null);
            XDSUtil.appendStatus((StatusDocument)result, (StatusAttributes)attrs, null, (Exception)((Object)xds), (boolean)false, (XmlDocument)queryXML);
        }
        catch (Exception e) {
            StatusAttributes attrs = StatusAttributes.factory((StatusLevel)StatusLevel.ERROR, (StatusType)StatusType.DRIVER_GENERAL, null);
            XDSUtil.appendStatus((StatusDocument)result, (StatusAttributes)attrs, null, (Exception)e, (boolean)true, (XmlDocument)queryXML);
        }
        return result.toXML();
    }
}

