/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds.skeleton;

import com.novell.nds.dirxml.driver.SubscriptionShim;
import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.driver.XmlQueryProcessor;
import com.novell.nds.dirxml.driver.xds.CommandElement;
import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.DataType;
import com.novell.nds.dirxml.driver.xds.Parameter;
import com.novell.nds.dirxml.driver.xds.QueryResultDocument;
import com.novell.nds.dirxml.driver.xds.RangeConstraint;
import com.novell.nds.dirxml.driver.xds.StateDocument;
import com.novell.nds.dirxml.driver.xds.StatusDocument;
import com.novell.nds.dirxml.driver.xds.StatusLevel;
import com.novell.nds.dirxml.driver.xds.StatusType;
import com.novell.nds.dirxml.driver.xds.ValueType;
import com.novell.nds.dirxml.driver.xds.WriteableDocument;
import com.novell.nds.dirxml.driver.xds.XDSAddAssociationElement;
import com.novell.nds.dirxml.driver.xds.XDSAddAttrElement;
import com.novell.nds.dirxml.driver.xds.XDSAddElement;
import com.novell.nds.dirxml.driver.xds.XDSAddValueElement;
import com.novell.nds.dirxml.driver.xds.XDSCheckObjectPasswordElement;
import com.novell.nds.dirxml.driver.xds.XDSCommandDocument;
import com.novell.nds.dirxml.driver.xds.XDSCommandResultDocument;
import com.novell.nds.dirxml.driver.xds.XDSDeleteElement;
import com.novell.nds.dirxml.driver.xds.XDSElement;
import com.novell.nds.dirxml.driver.xds.XDSException;
import com.novell.nds.dirxml.driver.xds.XDSInitDocument;
import com.novell.nds.dirxml.driver.xds.XDSModifyAttrElement;
import com.novell.nds.dirxml.driver.xds.XDSModifyElement;
import com.novell.nds.dirxml.driver.xds.XDSModifyPasswordElement;
import com.novell.nds.dirxml.driver.xds.XDSMoveElement;
import com.novell.nds.dirxml.driver.xds.XDSParentElement;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.nds.dirxml.driver.xds.XDSQueryElement;
import com.novell.nds.dirxml.driver.xds.XDSRemoveAllValuesElement;
import com.novell.nds.dirxml.driver.xds.XDSRemoveValueElement;
import com.novell.nds.dirxml.driver.xds.XDSRenameElement;
import com.novell.nds.dirxml.driver.xds.XDSResultDocument;
import com.novell.nds.dirxml.driver.xds.XDSStatusElement;
import com.novell.nds.dirxml.driver.xds.XDSValueElement;
import com.novell.nds.dirxml.driver.xds.skeleton.CommonImpl;
import com.novell.nds.dirxml.driver.xds.skeleton.SkeletonDriverShim;
import com.novell.nds.dirxml.driver.xds.util.StatusAttributes;
import com.novell.nds.dirxml.driver.xds.util.XDSUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import org.w3c.dom.Element;

public class SkeletonSubscriptionShim
extends CommonImpl
implements SubscriptionShim {
    private static final int NO_OF_PARAMS = 2;
    private static final String TAG_CURRENT_ASSOCIATION = "current-association";
    private static final String TAG_SUB_1 = "sub-1";
    private static final String DEFAULT_SUB_1 = "String for Subscriber";
    private static final String DEFAULT_ASSOCIATION = "1";
    private static final String DRIVER_ID_VALUE = "JSKEL";
    private static final String DRIVER_MIN_ACTIVATION_VERSION = "0";
    private Map subParams;
    private int currentAssociation;
    private SkeletonDriverShim driver;
    static /* synthetic */ Class class$com$novell$nds$dirxml$driver$xds$XDSAddElement;
    static /* synthetic */ Class class$com$novell$nds$dirxml$driver$xds$XDSModifyElement;
    static /* synthetic */ Class class$com$novell$nds$dirxml$driver$xds$XDSDeleteElement;
    static /* synthetic */ Class class$com$novell$nds$dirxml$driver$xds$XDSRenameElement;
    static /* synthetic */ Class class$com$novell$nds$dirxml$driver$xds$XDSMoveElement;
    static /* synthetic */ Class class$com$novell$nds$dirxml$driver$xds$XDSModifyPasswordElement;
    static /* synthetic */ Class class$com$novell$nds$dirxml$driver$xds$XDSCheckObjectPasswordElement;
    static /* synthetic */ Class class$com$novell$nds$dirxml$driver$xds$XDSAddValueElement;
    static /* synthetic */ Class class$com$novell$nds$dirxml$driver$xds$XDSRemoveValueElement;
    static /* synthetic */ Class class$com$novell$nds$dirxml$driver$xds$XDSRemoveAllValuesElement;

    SkeletonSubscriptionShim(SkeletonDriverShim someDriver) {
        this.driver = someDriver;
        this.setDriverRDN(this.driver.getDriverRDN());
        this.setTrace();
        this.setDriverParams(this.driver.getDriverParams());
        this.setSubParams();
        this.currentAssociation = -1;
    }

    private void setSubParams() {
        this.subParams = new HashMap(2);
        Parameter param = new Parameter(TAG_SUB_1, DEFAULT_SUB_1, DataType.STRING);
        this.subParams.put(param.tagName(), param);
        param = new Parameter(TAG_CURRENT_ASSOCIATION, DEFAULT_ASSOCIATION, DataType.INT);
        param.add((Constraint)RangeConstraint.POSITIVE);
        this.subParams.put(param.tagName(), param);
    }

    public XmlDocument init(XmlDocument initXML) {
        this.trace.trace("init", 1);
        XDSResultDocument result = this.newResultDoc();
        try {
            XDSInitDocument init = new XDSInitDocument(initXML);
            init.parameters(this.subParams);
            this.currentAssociation = ((Parameter)this.subParams.get(TAG_CURRENT_ASSOCIATION)).toInteger();
            StatusAttributes attrs = StatusAttributes.factory((StatusLevel)StatusLevel.SUCCESS, (StatusType)StatusType.DRIVER_STATUS, null);
            XDSStatusElement status = XDSUtil.appendStatus((StatusDocument)result, (StatusAttributes)attrs, null);
            status.parametersAppend(this.subParams);
        }
        catch (Exception e) {
            StatusAttributes attrs = StatusAttributes.factory((StatusLevel)StatusLevel.FATAL, (StatusType)StatusType.DRIVER_STATUS, null);
            XDSUtil.appendStatus((StatusDocument)result, (StatusAttributes)attrs, null, (Exception)e, (boolean)XDSUtil.appendStackTrace((Exception)e), (XmlDocument)initXML);
        }
        return result.toXML();
    }

    public XmlDocument execute(XmlDocument commandXML, XmlQueryProcessor processor) {
        this.trace.trace("execute", 1);
        XDSCommandResultDocument result = new XDSCommandResultDocument();
        this.appendSourceInfo((WriteableDocument)result);
        String eventID = null;
        try {
            XDSCommandDocument commands = new XDSCommandDocument(commandXML);
            if (commands.containsIdentityQuery()) {
                XDSQueryElement query = commands.identityQuery();
                eventID = query.getEventID();
                this.appendDriverIdentityInfo(result);
                StatusAttributes attrs = StatusAttributes.factory((StatusLevel)StatusLevel.SUCCESS, (StatusType)StatusType.DRIVER_GENERAL, (String)eventID);
                XDSUtil.appendStatus((StatusDocument)result, (StatusAttributes)attrs, null);
            } else {
                this.connect();
                ListIterator c = commands.childElements().listIterator();
                while (c.hasNext()) {
                    CommandElement command = (CommandElement)c.next();
                    eventID = command.getEventID();
                    this.dispatch(command, result);
                    StatusAttributes attrs = StatusAttributes.factory((StatusLevel)StatusLevel.SUCCESS, (StatusType)StatusType.DRIVER_GENERAL, (String)eventID);
                    XDSUtil.appendStatus((StatusDocument)result, (StatusAttributes)attrs, null);
                }
            }
        }
        catch (XDSException xds) {
            StatusAttributes attrs = StatusAttributes.factory((StatusLevel)StatusLevel.ERROR, (StatusType)StatusType.DRIVER_GENERAL, null);
            XDSUtil.appendStatus((StatusDocument)result, (StatusAttributes)attrs, null, (Exception)((Object)xds), (boolean)false, (XmlDocument)commandXML);
        }
        catch (IOException io) {
            this.connected = false;
            StatusAttributes attrs = StatusAttributes.factory((StatusLevel)StatusLevel.RETRY, (StatusType)StatusType.APP_CONNECTION, eventID);
            XDSUtil.appendStatus((StatusDocument)result, (StatusAttributes)attrs, (String)"Communications error.", (Exception)io, (boolean)false, null);
        }
        catch (Exception e) {
            StatusAttributes attrs = StatusAttributes.factory((StatusLevel)StatusLevel.FATAL, (StatusType)StatusType.DRIVER_STATUS, eventID);
            XDSUtil.appendStatus((StatusDocument)result, (StatusAttributes)attrs, null, (Exception)e, (boolean)true, (XmlDocument)commandXML);
        }
        return result.toXML();
    }

    private void dispatch(CommandElement command, XDSCommandResultDocument result) throws XDSParseException {
        this.trace.trace("dispatch", 1);
        Class<?> commandClass = command.getClass();
        if (commandClass == (class$com$novell$nds$dirxml$driver$xds$XDSAddElement == null ? (class$com$novell$nds$dirxml$driver$xds$XDSAddElement = SkeletonSubscriptionShim.class$("com.novell.nds.dirxml.driver.xds.XDSAddElement")) : class$com$novell$nds$dirxml$driver$xds$XDSAddElement)) {
            this.addHandler((XDSAddElement)command, result);
            this.appendStateInfo((StateDocument)result);
        } else if (commandClass == (class$com$novell$nds$dirxml$driver$xds$XDSModifyElement == null ? (class$com$novell$nds$dirxml$driver$xds$XDSModifyElement = SkeletonSubscriptionShim.class$("com.novell.nds.dirxml.driver.xds.XDSModifyElement")) : class$com$novell$nds$dirxml$driver$xds$XDSModifyElement)) {
            this.modifyHandler((XDSModifyElement)command, result);
        } else if (commandClass == (class$com$novell$nds$dirxml$driver$xds$XDSDeleteElement == null ? (class$com$novell$nds$dirxml$driver$xds$XDSDeleteElement = SkeletonSubscriptionShim.class$("com.novell.nds.dirxml.driver.xds.XDSDeleteElement")) : class$com$novell$nds$dirxml$driver$xds$XDSDeleteElement)) {
            this.deleteHandler((XDSDeleteElement)command, result);
        } else if (commandClass == (class$com$novell$nds$dirxml$driver$xds$XDSRenameElement == null ? (class$com$novell$nds$dirxml$driver$xds$XDSRenameElement = SkeletonSubscriptionShim.class$("com.novell.nds.dirxml.driver.xds.XDSRenameElement")) : class$com$novell$nds$dirxml$driver$xds$XDSRenameElement)) {
            this.renameHandler((XDSRenameElement)command, result);
        } else if (commandClass == (class$com$novell$nds$dirxml$driver$xds$XDSMoveElement == null ? (class$com$novell$nds$dirxml$driver$xds$XDSMoveElement = SkeletonSubscriptionShim.class$("com.novell.nds.dirxml.driver.xds.XDSMoveElement")) : class$com$novell$nds$dirxml$driver$xds$XDSMoveElement)) {
            this.moveHandler((XDSMoveElement)command, result);
        } else if (command instanceof XDSQueryElement) {
            this.queryHandler((XDSQueryElement)command, (QueryResultDocument)result);
        } else if (commandClass == (class$com$novell$nds$dirxml$driver$xds$XDSModifyPasswordElement == null ? (class$com$novell$nds$dirxml$driver$xds$XDSModifyPasswordElement = SkeletonSubscriptionShim.class$("com.novell.nds.dirxml.driver.xds.XDSModifyPasswordElement")) : class$com$novell$nds$dirxml$driver$xds$XDSModifyPasswordElement)) {
            this.modifyPasswordHandler((XDSModifyPasswordElement)command, result);
        } else if (commandClass == (class$com$novell$nds$dirxml$driver$xds$XDSCheckObjectPasswordElement == null ? (class$com$novell$nds$dirxml$driver$xds$XDSCheckObjectPasswordElement = SkeletonSubscriptionShim.class$("com.novell.nds.dirxml.driver.xds.XDSCheckObjectPasswordElement")) : class$com$novell$nds$dirxml$driver$xds$XDSCheckObjectPasswordElement)) {
            this.checkObjectPasswordHandler((XDSCheckObjectPasswordElement)command, result);
        } else {
            this.trace.trace("unhandled element:  " + command.tagName(), 3);
        }
    }

    private void addHandler(XDSAddElement add, XDSCommandResultDocument result) {
        this.trace.trace("addHandler", 1);
        String className = add.getClassName();
        this.trace.trace("addHandler: class-name == " + SkeletonSubscriptionShim.toLiteral(className), 2);
        ListIterator a = add.extractAddAttrElements().listIterator();
        while (a.hasNext()) {
            XDSAddAttrElement addAttr = (XDSAddAttrElement)a.next();
            this.trace.trace("addHandler: attr-name  == " + SkeletonSubscriptionShim.toLiteral(addAttr.getAttrName()), 2);
            ListIterator v = addAttr.extractValueElements().listIterator();
            while (v.hasNext()) {
                XDSValueElement value = (XDSValueElement)v.next();
                this.trace.trace("addHandler:\tvalue == " + SkeletonSubscriptionShim.toLiteral(value.extractText()), 2);
            }
        }
        XDSAddAssociationElement addAssociation = result.appendAddAssociationElement();
        addAssociation.setDestDN(add.getSrcDN());
        addAssociation.setEventID(add.getEventID());
        addAssociation.appendText(String.valueOf(this.currentAssociation));
        ++this.currentAssociation;
    }

    private void modifyPasswordHandler(XDSModifyPasswordElement modifyPassword, XDSCommandResultDocument result) {
        this.trace.trace("modifyPasswordHandler", 1);
        String className = modifyPassword.getClassName();
        String assocValue = modifyPassword.extractAssociationText();
        this.trace.trace("modifyPasswordHandler: class-name   == " + SkeletonSubscriptionShim.toLiteral(className), 2);
        this.trace.trace("modifyPasswordHandler: association  == " + SkeletonSubscriptionShim.toLiteral(assocValue), 2);
        String oldPassword = modifyPassword.extractOldPasswordText();
        this.trace.trace("modifyPasswordHandler: old-password == " + SkeletonSubscriptionShim.toLiteral(oldPassword), 2);
        String newPassword = modifyPassword.extractPasswordText();
        this.trace.trace("modifyPasswordHandler: new-password == " + SkeletonSubscriptionShim.toLiteral(newPassword), 2);
    }

    private void checkObjectPasswordHandler(XDSCheckObjectPasswordElement checkPassword, XDSCommandResultDocument result) {
        this.trace.trace("checkObjectPassword", 1);
        String assocValue = checkPassword.extractAssociationText();
        String password = checkPassword.extractPasswordText();
        this.trace.trace("checkObjectPassword: association  == " + SkeletonSubscriptionShim.toLiteral(assocValue), 2);
        this.trace.trace("checkObjectPassword: password     == " + SkeletonSubscriptionShim.toLiteral(password), 2);
    }

    private void modifyHandler(XDSModifyElement modify, XDSCommandResultDocument result) {
        this.trace.trace("modifyHandler", 1);
        String className = modify.getClassName();
        String assocValue = modify.extractAssociationText();
        this.trace.trace("modifyHandler: class-name  == " + SkeletonSubscriptionShim.toLiteral(className), 2);
        this.trace.trace("modifyHandler: association == " + SkeletonSubscriptionShim.toLiteral(assocValue), 2);
        ListIterator m = modify.extractModifyAttrElements().listIterator();
        while (m.hasNext()) {
            XDSModifyAttrElement modifyAttr = (XDSModifyAttrElement)m.next();
            String attrName = modifyAttr.getAttrName();
            this.trace.trace("modifyHandler: attr-name   == " + SkeletonSubscriptionShim.toLiteral(attrName), 2);
            ListIterator c = modifyAttr.childElements().listIterator();
            while (c.hasNext()) {
                XDSElement element = (XDSElement)c.next();
                if (element.getClass() == (class$com$novell$nds$dirxml$driver$xds$XDSAddValueElement == null ? SkeletonSubscriptionShim.class$("com.novell.nds.dirxml.driver.xds.XDSAddValueElement") : class$com$novell$nds$dirxml$driver$xds$XDSAddValueElement)) {
                    this.addValueHandler((XDSAddValueElement)element);
                    continue;
                }
                if (element.getClass() == (class$com$novell$nds$dirxml$driver$xds$XDSRemoveValueElement == null ? SkeletonSubscriptionShim.class$("com.novell.nds.dirxml.driver.xds.XDSRemoveValueElement") : class$com$novell$nds$dirxml$driver$xds$XDSRemoveValueElement)) {
                    this.removeValueHandler((XDSRemoveValueElement)element);
                    continue;
                }
                if (element.getClass() == (class$com$novell$nds$dirxml$driver$xds$XDSRemoveAllValuesElement == null ? SkeletonSubscriptionShim.class$("com.novell.nds.dirxml.driver.xds.XDSRemoveAllValuesElement") : class$com$novell$nds$dirxml$driver$xds$XDSRemoveAllValuesElement)) {
                    this.removeAllValuesHandler((XDSRemoveAllValuesElement)element);
                    continue;
                }
                this.trace.trace("unhandled element:  " + element.tagName(), 3);
            }
        }
    }

    private void addValueHandler(XDSAddValueElement addValue) {
        ListIterator v = addValue.extractValueElements().listIterator();
        while (v.hasNext()) {
            XDSValueElement value = (XDSValueElement)v.next();
            this.trace.trace("modifyHandler:\tadd-value    == " + SkeletonSubscriptionShim.toLiteral(value.extractText()), 2);
            ValueType type = value.getType();
        }
    }

    private void removeValueHandler(XDSRemoveValueElement removeValue) {
        ListIterator v = removeValue.extractValueElements().listIterator();
        while (v.hasNext()) {
            XDSValueElement value = (XDSValueElement)v.next();
            this.trace.trace("modifyHandler:\tremove-value == " + SkeletonSubscriptionShim.toLiteral(value.extractText()), 2);
            ValueType type = value.getType();
        }
    }

    private void removeAllValuesHandler(XDSRemoveAllValuesElement removeAll) {
        this.trace.trace("modifyHandler:\tremove-all-values", 2);
    }

    private void deleteHandler(XDSDeleteElement delete, XDSCommandResultDocument result) throws XDSParseException {
        this.trace.trace("deleteHandler", 1);
        String className = delete.getClassName();
        String assocValue = delete.extractAssociationText();
        this.trace.trace("deleteHandler: class-name  == " + SkeletonSubscriptionShim.toLiteral(className), 2);
        this.trace.trace("deleteHandler: association == " + SkeletonSubscriptionShim.toLiteral(assocValue), 2);
        if (assocValue == null) {
            throw new XDSParseException("Missing required association.");
        }
    }

    private void renameHandler(XDSRenameElement rename, XDSCommandResultDocument result) {
        this.trace.trace("renameHandler", 1);
        String className = rename.getClassName();
        String assocValue = rename.extractAssociationText();
        this.trace.trace("renameHandler: class-name  == " + SkeletonSubscriptionShim.toLiteral(className), 2);
        this.trace.trace("renameHandler: association == " + SkeletonSubscriptionShim.toLiteral(assocValue), 2);
        String newName = rename.extractNewNameText();
        this.trace.trace("renameHandler: new-name    == " + SkeletonSubscriptionShim.toLiteral(newName), 2);
    }

    private void moveHandler(XDSMoveElement move, XDSCommandResultDocument result) {
        this.trace.trace("moveHandler", 1);
        String className = move.getClassName();
        String childAssociation = move.extractAssociationText();
        this.trace.trace("moveHandler: class       == " + SkeletonSubscriptionShim.toLiteral(className), 2);
        this.trace.trace("moveHandler: association == " + SkeletonSubscriptionShim.toLiteral(childAssociation), 2);
        XDSParentElement parent = move.extractParentElement();
        String parentAssociation = parent.extractAssociationText();
        this.trace.trace("moveHandler:\tparent association == " + SkeletonSubscriptionShim.toLiteral(parentAssociation), 2);
    }

    private void appendDriverIdentityInfo(XDSCommandResultDocument result) {
        if (result != null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("<instance class-name=\"__driver_identification_class__\">");
            buffer.append("<attr attr-name=\"driver-id\">");
            buffer.append("<value type=\"string\">");
            buffer.append(DRIVER_ID_VALUE);
            buffer.append("</value>");
            buffer.append("</attr>");
            buffer.append("<attr attr-name=\"driver-version\">");
            buffer.append("<value type=\"string\">");
            buffer.append("3.5.2");
            buffer.append("</value>");
            buffer.append("</attr>");
            buffer.append("<attr attr-name=\"min-activation-version\">");
            buffer.append("<value type=\"string\">");
            buffer.append(DRIVER_MIN_ACTIVATION_VERSION);
            buffer.append("</value>");
            buffer.append("</attr>");
            buffer.append("<attr attr-name=\"query-ex-supported\">");
            buffer.append("<value type=\"state\">false</value>");
            buffer.append("</attr>");
            buffer.append("</instance>");
            XDSUtil.appendXML((Element)result.domIOElement(), (String)buffer.toString());
        }
    }

    void shutdown() {
        this.trace.trace("shutdown", 1);
        this.disconnect();
    }

    void appendStateInfo(StateDocument doc) {
        if (doc != null) {
            String state = "<init-params><subscriber-state><current-association>" + String.valueOf(this.currentAssociation) + "</current-association>" + "</subscriber-state>" + "</init-params>";
            XDSUtil.appendXML((Element)doc.domIOElement(), (String)state);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

