/*
 * Decompiled with CFR 0.152.
 */
import arguments.ApplicationArguments;
import arguments.Argument;
import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPConstraints;
import com.novell.ldap.LDAPJSSESecureSocketFactory;
import com.novell.ldap.LDAPJSSEStartTLSFactory;
import com.novell.ldap.LDAPSocketFactory;
import com.novell.ldap.client.Debug;
import com.sun.net.ssl.internal.ssl.Provider;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.security.Security;
import java.text.ParseException;
import schema.CloseWindowAndExit;
import schema.ListAttributeSchema;
import schema.ListObjectClassSchema;

public class ListSchema {
    public final int BIND_TIMEOUT = 20000;

    public static void main(String[] stringArray) {
        System.exit(new ListSchema().runSchema(stringArray));
    }

    private int runSchema(String[] stringArray) {
        Object object;
        Options options = null;
        try {
            options = new Options();
            options.parse(stringArray);
        }
        catch (ParseException parseException) {
            String string = parseException.getMessage();
            if (string == null) {
                string = parseException.toString();
            }
            string = options.usage(string);
            this.displayArguments(options, stringArray);
            System.err.println(string);
            return 1;
        }
        catch (Exception exception) {
            System.err.println("Exception: " + exception.toString());
            exception.printStackTrace();
            return 1;
        }
        if (options.debug()) {
            Debug.setTraceStream((PrintStream)System.err);
            Debug.setTrace((String)"TraceAll", (boolean)true);
        }
        String string = null;
        String string2 = options.getConnectionType();
        string = options.getKeystore();
        if (string != null) {
            Security.addProvider((java.security.Provider)new Provider());
            if (options.getPrintVerbose()) {
                System.err.println("Java key store is \"" + string + "\"");
            }
            System.setProperty("javax.net.ssl.trustStore", string);
            if (string2.equalsIgnoreCase("TLS")) {
                if (options.getPrintVerbose()) {
                    System.err.println("Setting factory for a TLS connection");
                }
                object = new LDAPJSSEStartTLSFactory();
            } else {
                if (options.getPrintVerbose()) {
                    System.err.println("Setting factory for a SSL connection");
                }
                object = new LDAPJSSESecureSocketFactory();
            }
            LDAPConnection.setSocketFactory((LDAPSocketFactory)object);
        }
        LDAPConnection lDAPConnection = new LDAPConnection();
        try {
            String string3;
            if (options.getPrintVerbose()) {
                System.err.println("Connecting to host \"" + options.getHostPort() + "\"");
            }
            lDAPConnection.connect(options.getHostPort(), 0);
            if (string != null && string2.equalsIgnoreCase("TLS")) {
                lDAPConnection.startTLS();
            }
            if ((string3 = options.getLoginDN()).length() != 0) {
                LDAPConstraints lDAPConstraints = new LDAPConstraints();
                lDAPConstraints.setTimeLimit(20000);
                lDAPConnection.bind(3, string3, options.getLoginPasswd().getBytes("UTF8"), lDAPConstraints);
            }
            if (options.attributeSchema()) {
                object = new Frame("Display an attribute's properties");
                ListAttributeSchema listAttributeSchema = new ListAttributeSchema(lDAPConnection);
                listAttributeSchema.init();
                ((Container)object).add((Component)listAttributeSchema, "West");
                ((Window)object).setSize(835, 505);
                ((Window)object).addWindowListener(new CloseWindowAndExit());
                ((Window)object).setVisible(true);
            } else {
                object = new Frame("Display an object class' properties");
                ListObjectClassSchema listObjectClassSchema = new ListObjectClassSchema(lDAPConnection);
                listObjectClassSchema.init();
                ((Container)object).add((Component)listObjectClassSchema, "West");
                ((Window)object).setSize(835, 505);
                ((Window)object).addWindowListener(new CloseWindowAndExit());
                ((Window)object).setVisible(true);
            }
            lDAPConnection.disconnect();
            while (true) {
                Thread.sleep(1000L);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println("Error: " + unsupportedEncodingException.toString());
            return 1;
        }
        catch (Exception exception) {
            System.out.println("\n    Error: " + exception.toString());
            return 1;
        }
    }

    private void displayArguments(Options options, String[] stringArray) {
        if (options.getPrintVerbose()) {
            System.err.println("\nCommand line arguments");
            for (int i = 0; i < stringArray.length; ++i) {
                System.err.println("   " + i + ": " + stringArray[i]);
            }
        }
    }

    private class Options {
        private ApplicationArguments options = new ApplicationArguments("jldapschema", 25);

        private Options() throws Exception {
            this.options.add(new Argument('a', "list attribute schema.  The absence of this\n          option means list object class schema", false));
            this.options.add(new Argument('d', "enable API debug output", false));
            this.options.add(new Argument('D', "bind DN", "the DN of the object used to bind", "", false));
            this.options.add(new Argument('e', "keystore", "Path to a Java Keystore.  A valid certificate in the keystore enables\n          an encrypted TLS connection.  See also the -Z option.", "", false));
            this.options.add(new Argument('h', "host", "host name or IP address.  A port can  be specified with the\n          host name as hostname:port, i.e. myhost:389.  See also \n          the -p option", "localhost", false));
            this.options.add(new Argument('p', "port", "host IP port number.  See also the -h option", 389, false));
            this.options.add(new Argument('w', "password", "the password value used for authentication", "", false));
            this.options.add(new Argument('v', "enable verbose output", false));
            this.options.add(new Argument('Z', "encrypted connection", "sets the type of encrypted connection.  A Keystore must be specified\n            with the -e option to enable an encrypted connection.\n            SSL   - Establishes an encrypted connection using \n                    SSL.  The default port is 636\n            TLS   - Establishes an encrypted connection using \n                    TLS.  The default port is 389", "TLS", false));
        }

        void parse(String[] stringArray) throws Exception {
            this.options.parse(stringArray);
        }

        String getHostPort() {
            int n;
            String string;
            try {
                string = (String)this.options.getArgument('h').getValue();
                Argument argument = this.options.getArgument('p');
                int n2 = argument.getValueCount();
                if (n2 == 0) {
                    n = (Integer)argument.getValue();
                    String string2 = this.getConnectionType();
                    if (string2.equalsIgnoreCase("SSL")) {
                        n = 636;
                    }
                } else {
                    n = (Integer)argument.getValue();
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException.toString());
            }
            if (string.indexOf(":") == -1) {
                string = string + ":" + n;
            }
            return string;
        }

        String getConnectionType() {
            String string = null;
            try {
                string = (String)this.options.getArgument('Z').getValue();
                if (!string.equalsIgnoreCase("SSL") && !string.equalsIgnoreCase("TLS")) {
                    throw new NoSuchFieldException("Invalid connection type specified: " + string);
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException.toString());
            }
            return string;
        }

        String getKeystore() {
            try {
                Argument argument = this.options.getArgument('e');
                int n = argument.getValueCount();
                if (n == 0) {
                    return null;
                }
                return (String)argument.getValue();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException.toString());
            }
        }

        String getLoginDN() {
            try {
                return (String)this.options.getArgument('D').getValue();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException.toString());
            }
        }

        void clearLoginDN() {
            try {
                this.options.getArgument('D').clearValues();
                return;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException.toString());
            }
        }

        String getLoginPasswd() {
            try {
                return (String)this.options.getArgument('w').getValue();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException.toString());
            }
        }

        void clearLoginPassword() {
            try {
                this.options.getArgument('w').clearValues();
                return;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException.toString());
            }
        }

        boolean getPrintVerbose() {
            try {
                return (Boolean)this.options.getArgument('v').getValue();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException.toString());
            }
        }

        boolean debug() {
            try {
                return (Boolean)this.options.getArgument('d').getValue();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException.toString());
            }
        }

        boolean attributeSchema() {
            try {
                return (Boolean)this.options.getArgument('a').getValue();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException.toString());
            }
        }

        String usage(String string) {
            return this.options.usage(string);
        }
    }
}

