/*
 * Decompiled with CFR 0.152.
 */
import arguments.ApplicationArguments;
import arguments.Argument;
import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPAuthHandler;
import com.novell.ldap.LDAPAuthProvider;
import com.novell.ldap.LDAPBindHandler;
import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPConstraints;
import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPJSSESecureSocketFactory;
import com.novell.ldap.LDAPJSSEStartTLSFactory;
import com.novell.ldap.LDAPReferralException;
import com.novell.ldap.LDAPReferralHandler;
import com.novell.ldap.LDAPSearchConstraints;
import com.novell.ldap.LDAPSearchResults;
import com.novell.ldap.LDAPSocketFactory;
import com.novell.ldap.LDAPUrl;
import com.novell.ldap.client.Debug;
import com.novell.ldap.controls.LDAPPersistSearchControl;
import com.novell.ldap.util.DSMLWriter;
import com.novell.ldap.util.LDIFWriter;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.BufferedReader;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.security.Security;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;

public class SearchUtil
extends Thread {
    public final int BIND_TIMEOUT = 20000;
    public final int FORMAT_LDIF = 9;
    public final int FORMAT_DSML = -9;
    public final int FORMAT_TEXT = 0;
    public final String DSAIT_OID = "2.16.840.1.113730.3.4.2";
    public final String PSEARCH_OID = "2.16.840.1.113730.3.4.3";
    public final String SORT_OID = "1.2.840.113556.1.4.473";
    private LDAPSearchResults searchResults;
    private LDAPConnection conn;

    private SearchUtil() {
    }

    public static void main(String[] stringArray) {
        System.exit(new SearchUtil().runSearch(stringArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runSearch(String[] stringArray) {
        int n = 0;
        LDIFWriter lDIFWriter = null;
        Options options = null;
        try {
            options = new Options();
            options.parse(stringArray);
        }
        catch (ParseException parseException) {
            String string = parseException.getMessage();
            if (string == null) {
                string = parseException.toString();
            }
            string = options.usage(string);
            this.displayArguments(options, stringArray);
            System.err.println(string);
            return 1;
        }
        catch (Exception exception) {
            System.err.println("Exception: " + exception.toString());
            exception.printStackTrace();
            return 1;
        }
        if (options.debug()) {
            Debug.setTraceStream((PrintStream)System.err);
            Debug.setTrace((String)"TraceAll", (boolean)true);
        }
        LDAPSearchConstraints lDAPSearchConstraints = new LDAPSearchConstraints(options.getTimeout(), options.getServerTimeLimit(), options.getAliasDereference(), options.getMaxSearchResults(), options.getReferralFollowing(), options.getBatchSize(), options.getReferralHandler(), options.getReferralHopLimit());
        String string = null;
        String string2 = options.getConnectionType();
        string = options.getKeystore();
        if (string != null) {
            LDAPJSSEStartTLSFactory lDAPJSSEStartTLSFactory;
            Security.addProvider((java.security.Provider)new Provider());
            if (options.getPrintVerbose()) {
                System.err.println("Java key store is \"" + string + "\"");
            }
            System.setProperty("javax.net.ssl.trustStore", string);
            if (string2.equalsIgnoreCase("TLS")) {
                if (options.getPrintVerbose()) {
                    System.err.println("Setting factory for a TLS connection");
                }
                lDAPJSSEStartTLSFactory = new LDAPJSSEStartTLSFactory();
            } else {
                if (options.getPrintVerbose()) {
                    System.err.println("Setting factory for a SSL connection");
                }
                lDAPJSSEStartTLSFactory = new LDAPJSSESecureSocketFactory();
            }
            LDAPConnection.setSocketFactory((LDAPSocketFactory)lDAPJSSEStartTLSFactory);
        }
        this.conn = new LDAPConnection();
        this.conn.setConstraints((LDAPConstraints)lDAPSearchConstraints);
        int n2 = 0;
        try {
            Object object;
            String string3;
            if (options.getPrintVerbose()) {
                System.err.println("Connecting to host \"" + options.getHostPort() + "\"");
            }
            this.conn.connect(options.getHostPort(), 0);
            if (string != null && string2.equalsIgnoreCase("TLS")) {
                this.conn.startTLS();
            }
            if ((string3 = options.getLoginDN()).length() != 0) {
                lDAPSearchConstraints.setTimeLimit(20000);
                this.conn.bind(3, string3, options.getLoginPasswd().getBytes("UTF8"), (LDAPConstraints)lDAPSearchConstraints);
            }
            lDAPSearchConstraints = this.conn.getSearchConstraints();
            lDAPSearchConstraints.setControls(options.getControls());
            this.conn.setConstraints((LDAPConstraints)lDAPSearchConstraints);
            this.displaySearchConstraints(options, lDAPSearchConstraints);
            lDAPSearchConstraints = null;
            options.clearLoginDN();
            options.clearLoginPassword();
            this.displayAuthentication(options, this.conn);
            this.displaySearchParameters(options);
            if (options.getPersistentSearch()) {
                object = new Thread(this);
                ((Thread)object).setDaemon(true);
                ((Thread)object).start();
                System.err.println("\nMonitoring changes. Enter a 'STOP' to quit: ");
            }
            this.searchResults = this.conn.search(options.getSearchBase(), options.getSearchScope(), options.getSearchFilter(), options.getAttributeNames(), options.getTypesOnly());
            object = new FileOutputStream(FileDescriptor.out);
            n = options.getExportFormat();
            if (n == 9) {
                lDIFWriter = new LDIFWriter((OutputStream)object);
            } else if (n == -9) {
                object = new FileOutputStream(FileDescriptor.out);
                lDIFWriter = new DSMLWriter((OutputStream)object);
                ((DSMLWriter)lDIFWriter).setIndent(3);
                ((DSMLWriter)lDIFWriter).useIndent(true);
            }
            while (this.searchResults.hasMore()) {
                String string4;
                LDAPEntry lDAPEntry;
                try {
                    lDAPEntry = this.searchResults.next();
                    ++n2;
                }
                catch (LDAPException lDAPException) {
                    this.displayException(options, (Exception)((Object)lDAPException));
                    continue;
                }
                if (n != 0) {
                    lDIFWriter.writeEntry(lDAPEntry);
                    continue;
                }
                if (options.getPrintDN() || options.getPrintAttrs()) {
                    string4 = lDAPEntry.getDN();
                    if (string4.length() == 0) {
                        string4 = "\"\"";
                    }
                    System.out.println("\n" + string4);
                }
                if (!options.getPrintAttrs()) continue;
                System.out.println("\tAttributes: ");
                string4 = lDAPEntry.getAttributeSet();
                Iterator iterator = string4.iterator();
                while (iterator.hasNext()) {
                    LDAPAttribute lDAPAttribute = (LDAPAttribute)iterator.next();
                    String string5 = lDAPAttribute.getName();
                    System.out.println("\t\t" + string5);
                    Enumeration enumeration = lDAPAttribute.getStringValues();
                    if (enumeration == null) continue;
                    while (enumeration.hasMoreElements()) {
                        String string6 = (String)enumeration.nextElement();
                        System.out.println("\t\t\t" + string6);
                    }
                }
            }
        }
        catch (LDAPException lDAPException) {
            this.displayException(options, (Exception)((Object)lDAPException));
        }
        catch (Exception exception) {
            this.displayException(options, exception);
        }
        finally {
            if (n != 0) {
                try {
                    lDIFWriter.finish();
                }
                catch (Exception exception) {}
            }
        }
        System.err.println(n2 + " Entries found");
        if (this.conn.isConnected()) {
            try {
                this.conn.disconnect();
            }
            catch (LDAPException lDAPException) {
                System.err.println("Disconnect Error: " + lDAPException.toString());
            }
        }
        return 0;
    }

    public void run() {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        try {
            String string;
            while (!(string = bufferedReader.readLine()).equalsIgnoreCase("STOP")) {
                System.err.println("\nSearchUtil: input ignored during persistent search: " + string);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        System.err.println("\nSearchUtil: stopping persistent search");
        try {
            if (this.searchResults == null) {
                this.conn.disconnect();
            } else {
                this.conn.abandon(this.searchResults);
            }
        }
        catch (LDAPException lDAPException) {
            System.out.println();
            System.out.println("Error: " + lDAPException.toString());
        }
    }

    private void displayArguments(Options options, String[] stringArray) {
        if (options.getPrintVerbose()) {
            System.err.println("\nCommand line arguments");
            for (int i = 0; i < stringArray.length; ++i) {
                System.err.println("   " + i + ": " + stringArray[i]);
            }
        }
    }

    private void displaySearchConstraints(Options options, LDAPSearchConstraints lDAPSearchConstraints) {
        if (options.getPrintVerbose()) {
            LDAPControl[] lDAPControlArray;
            System.err.println("Constraints Values");
            System.err.print("    Search alias dereferencing is ");
            switch (lDAPSearchConstraints.getDereference()) {
                case 0: {
                    System.err.println("DEREF_NEVER");
                    break;
                }
                case 2: {
                    System.err.println("DEREF_FINDING");
                    break;
                }
                case 1: {
                    System.err.println("DEREF_SEARCHING");
                    break;
                }
                case 3: {
                    System.err.println("DEREF_ALWAYS");
                }
            }
            System.err.println("    Search batch size is " + lDAPSearchConstraints.getBatchSize());
            System.err.println("    Search max results is " + lDAPSearchConstraints.getMaxResults());
            System.err.println("    Search server time limit is " + lDAPSearchConstraints.getServerTimeLimit() + " seconds");
            System.err.println("    API request time limit is " + lDAPSearchConstraints.getTimeLimit() + " milliseconds");
            System.err.println("    Referral following is " + lDAPSearchConstraints.getReferralFollowing());
            if (lDAPSearchConstraints.getReferralFollowing()) {
                lDAPControlArray = options.getReferralHandler();
                if (lDAPControlArray == null) {
                    System.err.println("    Referral handler not set");
                } else {
                    System.err.print("    Referral handler is ");
                    if (lDAPControlArray instanceof LDAPBindHandler) {
                        System.err.println("LDAPBindHandler");
                    } else {
                        System.err.println("LDAPAuthHandler");
                    }
                    System.err.println("    Referral hop limit set to " + lDAPSearchConstraints.getHopLimit());
                }
            }
            if (lDAPSearchConstraints.getControls() != null) {
                lDAPControlArray = lDAPSearchConstraints.getControls();
                StringBuffer stringBuffer = new StringBuffer("Controls:\n");
                for (int i = 0; i < lDAPControlArray.length; ++i) {
                    String string = lDAPControlArray[i].getID();
                    if (string.equals("2.16.840.1.113730.3.4.2")) {
                        stringBuffer.append("    ManageDsaIT\n");
                        continue;
                    }
                    if (string.equals("2.16.840.1.113730.3.4.3")) {
                        stringBuffer.append("    Persistent Search\n");
                        continue;
                    }
                    stringBuffer.append("    " + lDAPControlArray[i].getID() + "\n");
                }
                System.err.print(stringBuffer.toString());
            }
        }
    }

    private void displayAuthentication(Options options, LDAPConnection lDAPConnection) {
        if (options.getPrintVerbose()) {
            if (lDAPConnection.isBound()) {
                System.err.println("Application is authenticated to server as " + lDAPConnection.getAuthenticationDN());
            } else {
                System.err.println("Application authentication is anonymous");
            }
        }
    }

    private void displaySearchParameters(Options options) {
        if (options.getPrintVerbose()) {
            System.err.println("Search Parameters");
            System.err.println("    Search Base: \"" + options.getSearchBase() + "\"");
            System.err.print("    Search Scope: ");
            int n = options.getSearchScope();
            switch (n) {
                case 2: {
                    System.err.println("SUB_TREE");
                    break;
                }
                case 0: {
                    System.err.println("BASE");
                    break;
                }
                case 1: {
                    System.err.println("ONE_LEVEL");
                    break;
                }
                case 4: {
                    System.err.println("SUBORDINATE_SUBTREE");
                }
            }
            System.err.println("    Search Filter: \"" + options.getSearchFilter() + "\"");
            String[] stringArray = options.getAttributeNames();
            if (stringArray.length == 1) {
                System.err.println("    Attribute Name: \"" + stringArray[0] + "\"");
            } else {
                System.err.println("    Attribute Names:");
                for (int i = 0; i < stringArray.length; ++i) {
                    System.err.println("        \"" + stringArray[i] + "\"");
                }
            }
            System.err.println("    Typesonly: " + options.getTypesOnly());
        }
    }

    private void displayException(Options options, Exception exception) {
        if (options.debug()) {
            exception.printStackTrace();
        } else if (exception instanceof RuntimeException) {
            exception.printStackTrace();
            System.exit(1);
        } else {
            System.err.println("\n" + exception.toString());
        }
    }

    private class Options {
        private ApplicationArguments options = new ApplicationArguments("jldapsearch", 25);

        private Options() throws Exception {
            this.options.add(new Argument('a', "alias", "Alias dereferencing\n            NEVER     - do not dereference aliases in \n                        searching or in locating the base\n                        object of the search\n            SEARCHING - dereference aliases in subordinates\n                        of the base object in searching, \n                        but not in locating the base\n                        object of the search\n            FINDING   - dereference aliases in locating the\n                        base object of the search, but not\n                        when searching subordinates of the\n                        base object\n            ALWAYS    - dereference aliases both in\n                        searching and in locating the base\n                        object of the search.", "NEVER", false));
            this.options.add(new Argument('A', "retrieve attribute names only (no values)", false));
            this.options.add(new Argument('b', "baseDN", "the base DN for the search", "", false));
            this.options.add(new Argument('C', "referralHandling", "Follow refeerals, OFF | ON | AUTH | BIND\n            OFF    - Referral following turned off\n            NO     - Follow with NO referral handler (anonymous)\n            AUTH   - Follow with AUTH referral handler\n            BIND   - Follow with BIND referral handler", "OFF", false));
            this.options.add(new Argument('d', "enable API debug output", false));
            this.options.add(new Argument('D', "bind DN", "the DN of the object used for authentication", "", false));
            this.options.add(new Argument('e', "keystore", "Path to a Java Keystore.  A valid certificate in the keystore enables\n          an encrypted TLS connection.  See also the -Z option.", "", false));
            this.options.add(new Argument('h', "host", "host name or IP address.  A port can  be specified with the\n          host name as hostname:port, i.e. myhost:389.  See also \n          the -p option", "localhost", false));
            this.options.add(new Argument('l', "server timeout", "server time limit in seconds to complete the search\n            0 = no limit", 0, false));
            this.options.add(new Argument('L', "export format", "Export format - LDIF|DSML\n            DSML - output in DSML V2.0 format\n            LDIF - output in LDIF V1.0 format\n            TEXT - output in descriptive text formt\n            Note: selecting DSML or LDIF forces the\n                  -a and -c options to be set", "TEXT", false));
            this.options.add(new Argument('m', "max results", "maximum number of entries for server to return", 1000, false));
            this.options.add(new Argument('M', "control", "a control to include with the search.  Any control specified\n          will be sent as critical, i.e., the operation will fail\n          if the server is unwilling to perform the control with the\n          search operation.\n            ManageDsaIT - Causes Directory-specific entries,\n                          regardless of type, to be treated as\n                          normal entries\n            PSearch     - A simple change notification mechanism.\n                          When set, changed entries are returned\n                          until the application is interrupted,\n                          or STOP is entered from the standard input\n                          stream\n          You specify multiple controls by preceding each control with\n          the -M option.  A \"+\" sign on the front of the control name\n          designates it as critical, i.e. \"-M +Sort\".  Psearch is\n          is always considered critical.", null, true));
            this.options.add(new Argument('p', "port", "host IP port number.  See also the -h option", 389, false));
            this.options.add(new Argument('q', "queue size", "number of entries to queue before the search\n           results are displayed", 1, false));
            this.options.add(new Argument('r', "referral hop limit", "the maximum number of referral hops allowed before\n            the operation fails", 10, false));
            this.options.add(new Argument('s', "scope", "Search Scope - BASE|ONE|SUB\n            BASE   - Base level search\n            ONE    - One level search\n            SUB    - Subtree search", "ONE", false));
            this.options.add(new Argument('t', "client timeout", "client message timeout in milliseconds\n             0 = no timeout", 0, false));
            this.options.add(new Argument('v', "enable verbose output", false));
            this.options.add(new Argument('w', "password", "the password value used for authentication", "", false));
            this.options.add(new Argument('Z', "encrypted connection", "sets the type of encrypted connection.  A Keystore must be specified\n            with the -e option to enable an encrypted connection.\n            SSL   - Establishes an encrypted connection using \n                    SSL.  The default port is 636\n            TLS   - Establishes an encrypted connection using \n                    TLS.  The default port is 389", "TLS", false));
            this.options.add(new Argument("filter", "an LDAP search filter", "(objectclass=*)", false));
            this.options.add(new Argument("attributes", "only the the named attributes will be displayed in the results.\n          You specify multiple attributes by separating each attribute\n          description with a space. An attribute description may include:\n            1.1 - no attributes\n            *   - all user attributes\n            +   - all informational attribute\n          Note: You must specify a filter if you specify any attribute\n                descriptions", "*", true));
        }

        void parse(String[] stringArray) throws Exception {
            this.options.parse(stringArray);
        }

        String getHostPort() {
            int n;
            String string;
            try {
                string = (String)this.options.getArgument('h').getValue();
                Argument argument = this.options.getArgument('p');
                int n2 = argument.getValueCount();
                if (n2 == 0) {
                    n = (Integer)argument.getValue();
                    String string2 = this.getConnectionType();
                    if (string2.equalsIgnoreCase("SSL")) {
                        n = 636;
                    }
                } else {
                    n = (Integer)argument.getValue();
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException.toString());
            }
            if (string.indexOf(":") == -1) {
                string = string + ":" + n;
            }
            return string;
        }

        int getTimeout() {
            try {
                return (Integer)this.options.getArgument('t').getValue();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException.toString());
            }
        }

        String getSearchBase() {
            try {
                return (String)this.options.getArgument('b').getValue();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException.toString());
            }
        }

        boolean getTypesOnly() {
            return !this.getPrintAttrs() && !this.getAttrValues() && this.getExportFormat() == 0;
        }

        String getSearchFilter() {
            try {
                return (String)this.options.getArgument(1).getValue();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException.toString());
            }
        }

        String getConnectionType() {
            String string = null;
            try {
                string = (String)this.options.getArgument('Z').getValue();
                if (!string.equalsIgnoreCase("SSL") && !string.equalsIgnoreCase("TLS")) {
                    throw new NoSuchFieldException("Invalid connection type specified: " + string);
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException.toString());
            }
            return string;
        }

        boolean getPersistentSearch() {
            try {
                Argument argument = this.options.getArgument('M');
                Enumeration enumeration = argument.getValues();
                while (enumeration.hasMoreElements()) {
                    if (!"PSearch".equalsIgnoreCase((String)enumeration.nextElement())) continue;
                    return true;
                }
                return false;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException.toString());
            }
        }

        LDAPControl[] getControls() {
            try {
                Argument argument = this.options.getArgument('M');
                Enumeration enumeration = argument.getValues();
                int n = argument.getValueCount();
                if (n == 0) {
                    return null;
                }
                LDAPControl[] lDAPControlArray = new LDAPControl[n];
                int n2 = 0;
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    if (string.equalsIgnoreCase("ManageDsaIT")) {
                        lDAPControlArray[n2++] = new LDAPControl("2.16.840.1.113730.3.4.2", false, null);
                        continue;
                    }
                    if (string.equalsIgnoreCase("+ManageDsaIT")) {
                        lDAPControlArray[n2++] = new LDAPControl("2.16.840.1.113730.3.4.2", true, null);
                        continue;
                    }
                    if (string.equalsIgnoreCase("PSearch")) {
                        lDAPControlArray[n2++] = new LDAPPersistSearchControl();
                        continue;
                    }
                    if (string.equalsIgnoreCase("+PSearch")) {
                        lDAPControlArray[n2++] = new LDAPPersistSearchControl();
                        continue;
                    }
                    throw new NoSuchFieldException("Invalid Control specified: " + string);
                }
                return lDAPControlArray;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException.toString());
            }
        }

        String getKeystore() {
            try {
                Argument argument = this.options.getArgument('e');
                int n = argument.getValueCount();
                if (n == 0) {
                    return null;
                }
                return (String)argument.getValue();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException.toString());
            }
        }

        String[] getAttributeNames() {
            try {
                Argument argument = this.options.getArgument(2);
                int n = argument.getValueCount();
                if (n == 0) {
                    n = 1;
                }
                String[] stringArray = new String[n];
                Enumeration enumeration = argument.getValues();
                int n2 = 0;
                while (enumeration.hasMoreElements()) {
                    stringArray[n2++] = (String)enumeration.nextElement();
                }
                return stringArray;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException.toString());
            }
        }

        int getSearchScope() {
            int n;
            block5: {
                n = 0;
                try {
                    String string = (String)this.options.getArgument('s').getValue();
                    if (string.equalsIgnoreCase("SUB")) {
                        n = 2;
                        break block5;
                    }
                    if (string.equalsIgnoreCase("BASE")) {
                        n = 0;
                        break block5;
                    }
                    if (string.equalsIgnoreCase("ONE")) {
                        n = 1;
                        break block5;
                    }
                    throw new NoSuchFieldException("Invalid Search Scope Argument");
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new RuntimeException(noSuchFieldException.toString());
                }
            }
            return n;
        }

        int getExportFormat() {
            int n;
            block6: {
                n = 0;
                try {
                    Argument argument = this.options.getArgument('L');
                    if (argument.getValueCount() == 0) {
                        return n;
                    }
                    String string = (String)argument.getValue();
                    if (string.equalsIgnoreCase("DSML")) {
                        n = -9;
                        break block6;
                    }
                    if (string.equalsIgnoreCase("LDIF")) {
                        n = 9;
                        break block6;
                    }
                    if (string.equalsIgnoreCase("TEXT")) {
                        n = 0;
                        break block6;
                    }
                    throw new NoSuchFieldException("Invalid Export Format Argument");
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new RuntimeException(noSuchFieldException.toString());
                }
            }
            return n;
        }

        LDAPReferralHandler getReferralHandler() {
            Object object = null;
            try {
                String string = (String)this.options.getArgument('C').getValue();
                if (!string.equalsIgnoreCase("NO") && !string.equalsIgnoreCase("ON")) {
                    if (string.equalsIgnoreCase("BIND")) {
                        object = new BindImpl(this);
                    } else if (string.equalsIgnoreCase("AUTH")) {
                        object = new AuthImpl(this);
                    } else if (string.equalsIgnoreCase("REBIND")) {
                        object = new AuthImpl(this);
                    } else if (!string.equalsIgnoreCase("OFF")) {
                        throw new NoSuchFieldException("Invalid Referral Following Argument: \"" + string + "\"");
                    }
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException.toString());
            }
            return object;
        }

        boolean getReferralFollowing() {
            boolean bl = false;
            try {
                String string = (String)this.options.getArgument('C').getValue();
                if (string.equalsIgnoreCase("ON")) {
                    bl = true;
                } else if (string.equalsIgnoreCase("BIND")) {
                    bl = true;
                } else if (string.equalsIgnoreCase("AUTH")) {
                    bl = true;
                } else if (string.equalsIgnoreCase("REBIND")) {
                    bl = true;
                } else if (!string.equalsIgnoreCase("OFF")) {
                    throw new NoSuchFieldException("Invalid Referral Following Argument: \"" + string + "\"");
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException.toString());
            }
            return bl;
        }

        int getAliasDereference() {
            int n;
            block6: {
                n = 0;
                try {
                    String string = (String)this.options.getArgument('a').getValue();
                    if (string.equalsIgnoreCase("NEVER")) {
                        n = 0;
                        break block6;
                    }
                    if (string.equalsIgnoreCase("FINDING")) {
                        n = 2;
                        break block6;
                    }
                    if (string.equalsIgnoreCase("SEARCHING")) {
                        n = 1;
                        break block6;
                    }
                    if (string.equalsIgnoreCase("ALWAYS")) {
                        n = 3;
                        break block6;
                    }
                    throw new NoSuchFieldException("Invalid Alias Dereference Argument: \"" + string + "\"");
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new RuntimeException(noSuchFieldException.toString());
                }
            }
            return n;
        }

        int getBatchSize() {
            try {
                return (Integer)this.options.getArgument('q').getValue();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException.toString());
            }
        }

        int getReferralHopLimit() {
            try {
                return (Integer)this.options.getArgument('r').getValue();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException.toString());
            }
        }

        int getMaxSearchResults() {
            try {
                return (Integer)this.options.getArgument('m').getValue();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException.toString());
            }
        }

        int getServerTimeLimit() {
            try {
                return (Integer)this.options.getArgument('l').getValue();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException.toString());
            }
        }

        String getLoginDN() {
            try {
                return (String)this.options.getArgument('D').getValue();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException.toString());
            }
        }

        void clearLoginDN() {
            try {
                this.options.getArgument('D').clearValues();
                return;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException.toString());
            }
        }

        String getLoginPasswd() {
            try {
                return (String)this.options.getArgument('w').getValue();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException.toString());
            }
        }

        void clearLoginPassword() {
            try {
                this.options.getArgument('w').clearValues();
                return;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException.toString());
            }
        }

        boolean debug() {
            try {
                return (Boolean)this.options.getArgument('d').getValue();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException.toString());
            }
        }

        boolean getPrintAttrs() {
            return this.getAttrValues();
        }

        boolean getAttrValues() {
            try {
                return (Boolean)this.options.getArgument('A').getValue() == false;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException.toString());
            }
        }

        boolean getPrintDN() {
            return true;
        }

        boolean getPrintVerbose() {
            try {
                return (Boolean)this.options.getArgument('v').getValue();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException.toString());
            }
        }

        String usage(String string) {
            return this.options.usage(string);
        }
    }

    private class BindImpl
    implements LDAPBindHandler {
        private Hashtable connections = new Hashtable();
        private String dn;
        private byte[] passwd;
        private boolean printVerbose;

        private BindImpl(Options options) {
            this.dn = options.getLoginDN();
            this.printVerbose = options.getPrintVerbose();
            try {
                this.passwd = options.getLoginPasswd().getBytes("UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.out.println("Unable to encode password to UTF-8: " + unsupportedEncodingException.toString());
                System.exit(1);
            }
        }

        public LDAPConnection bind(String[] stringArray, LDAPConnection lDAPConnection) throws LDAPReferralException {
            LDAPUrl lDAPUrl;
            int n;
            LDAPReferralException lDAPReferralException = null;
            LDAPConnection lDAPConnection2 = null;
            String string = lDAPConnection.getHost() + ":" + lDAPConnection.getPort();
            if ((LDAPConnection)this.connections.get(string) == null) {
                this.connections.put(string, lDAPConnection);
            }
            if (this.printVerbose) {
                System.err.println("\nBind: Referral contains " + stringArray.length + " URLs");
                for (n = 0; n < stringArray.length; ++n) {
                    System.err.println("         " + stringArray[n]);
                }
                System.err.println("Bind: Original host is " + string);
            }
            for (n = 0; n < stringArray.length; ++n) {
                try {
                    lDAPUrl = new LDAPUrl(stringArray[n]);
                    string = lDAPUrl.getHost() + ":" + lDAPConnection.getPort();
                    lDAPConnection2 = (LDAPConnection)this.connections.get(string);
                    if (lDAPConnection2 == null) continue;
                    if (this.printVerbose) {
                        System.err.println("Bind: Using existing connection to host " + string);
                    }
                    lDAPReferralException = null;
                    break;
                }
                catch (Throwable throwable) {
                    lDAPConnection2 = null;
                }
            }
            if (lDAPConnection2 == null) {
                lDAPConnection2 = new LDAPConnection(lDAPConnection.getSocketFactory());
                LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
                lDAPConnection2.setConstraints((LDAPConstraints)lDAPSearchConstraints);
                lDAPSearchConstraints.setReferralFollowing(false);
                lDAPSearchConstraints.setTimeLimit(20000);
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        lDAPUrl = new LDAPUrl(stringArray[i]);
                    }
                    catch (MalformedURLException malformedURLException) {
                        continue;
                    }
                    string = lDAPUrl.getHost() + ":" + lDAPUrl.getPort();
                    try {
                        lDAPConnection2.connect(string, 0);
                        if (lDAPConnection.isTLS()) {
                            lDAPConnection2.startTLS();
                        }
                        if (lDAPConnection.isBound()) {
                            String string2 = lDAPConnection.getAuthenticationMethod();
                            if (!string2.equals("simple")) {
                                if (string2.equals("sasl")) {
                                    throw new LDAPException("Bind: " + string2 + " not implemented", 86, (String)null);
                                }
                                throw new LDAPException("Bind: " + string2 + " unknown", 86, (String)null);
                            }
                            lDAPConnection2.bind(lDAPConnection.getProtocolVersion(), this.dn, this.passwd, (LDAPConstraints)lDAPSearchConstraints);
                            if (this.printVerbose) {
                                System.err.println("Bind: Successful " + string2 + " Bind to host " + string);
                            }
                        } else if (this.printVerbose) {
                            System.err.println("Bind: Anonymous connection to host " + string);
                        }
                        this.connections.put(string, lDAPConnection2);
                        lDAPReferralException = null;
                        break;
                    }
                    catch (Throwable throwable) {
                        try {
                            lDAPConnection2.disconnect();
                        }
                        catch (LDAPException lDAPException) {
                            // empty catch block
                        }
                        System.err.println("Bind: Exception on  Bind to host " + string + " - " + throwable.toString());
                        if (throwable instanceof LDAPReferralException) {
                            lDAPReferralException = (LDAPReferralException)throwable;
                            continue;
                        }
                        lDAPReferralException = new LDAPReferralException("Bind: Could not follow referrals", throwable);
                        lDAPReferralException.setFailedReferral(stringArray[i]);
                        if (!this.printVerbose || throwable instanceof LDAPException) continue;
                        throwable.printStackTrace();
                    }
                }
            }
            if (lDAPReferralException != null) {
                lDAPConnection2 = null;
                if (this.printVerbose) {
                    System.err.println("Bind: Throwing LDAPReferralException " + lDAPReferralException.toString());
                }
                throw lDAPReferralException;
            }
            return lDAPConnection2;
        }
    }

    private class AuthImpl
    implements LDAPAuthHandler {
        private String dn;
        private byte[] passwd;
        private boolean printVerbose;

        private AuthImpl(Options options) {
            this.dn = options.getLoginDN();
            this.printVerbose = options.getPrintVerbose();
            try {
                this.passwd = options.getLoginPasswd().getBytes("UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.out.println("Unable to encode password to UTF-8: " + unsupportedEncodingException.toString());
                System.exit(1);
            }
        }

        public LDAPAuthProvider getAuthProvider(String string, int n) {
            if (this.printVerbose) {
                System.err.println("\nReBind to host " + string + ":" + n);
            }
            return new LDAPAuthProvider(this.dn, this.passwd);
        }
    }
}

