/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.vrtest;

import com.novell.nds.dirxml.vrtest.Constants;
import com.novell.nds.dirxml.vrtest.Errors;
import com.novell.nds.dirxml.vrtest.VRTestAttributeList;
import com.novell.nds.dirxml.vrtest.VRTestConstants;
import com.novell.nds.dirxml.vrtest.VRTestDecoder;
import com.novell.nds.dirxml.vrtest.VRTestEncoder;
import com.novell.nds.dirxml.vrtest.VRTestEvent;
import com.novell.nds.dirxml.vrtest.VRTestEventType;
import com.novell.nds.dirxml.vrtest.VRTestException;
import com.novell.nds.dirxml.vrtest.VRTestHandle;
import com.novell.nds.dirxml.vrtest.VRTestInputStream;
import com.novell.nds.dirxml.vrtest.VRTestOutputStream;
import com.novell.nds.dirxml.vrtest.VRTestSchema;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;

public class VRTestAPI
implements Constants,
VRTestConstants {
    private static final String LOCAL_HOST = "localhost";
    private static final int PORT_OFFSET = 1;
    private int commandResponsePort;
    private int eventPort;
    private String host;
    private Socket commandResponseChannel = null;
    private Socket eventChannel = null;
    private Object commandResponseMutex = new short[0];
    public final Object findMutex = new short[0];
    public final Object connectMutex = new short[0];
    private VRTestOutputStream toServer = null;
    private VRTestInputStream fromServer = null;
    private VRTestInputStream events = null;
    private VRTestSchema schema = null;

    private void setPorts(int n) throws VRTestException {
        if (VRTestAPI.isInvalidPortNum(n)) {
            throw new VRTestException(Errors.ParamOutOfRange("basePort", String.valueOf(n)));
        }
        this.commandResponsePort = n;
        this.eventPort = n + 1;
    }

    private static boolean isInvalidPortNum(int n) {
        return n < 0 && n > 65534;
    }

    private boolean hostLookupRequired(String string) {
        return string == null || string.equalsIgnoreCase(LOCAL_HOST);
    }

    private void setHostName(String string) throws IOException {
        this.host = this.hostLookupRequired(string) ? InetAddress.getLocalHost().getHostName() : string;
    }

    private String sendCommand(String string) throws IOException {
        Object object = this.commandResponseMutex;
        synchronized (object) {
            if (this.commandResponseChannel == null) {
                throw new IOException("Session closed.");
            }
            this.toServer.write(string);
            String string2 = this.fromServer.read();
            return string2;
        }
    }

    public long create(String string, VRTestAttributeList vRTestAttributeList) throws VRTestException, IOException {
        if (string == null) {
            throw new IllegalArgumentException(Errors.NullParam("className"));
        }
        if (vRTestAttributeList == null) {
            throw new IllegalArgumentException(Errors.NullParam("attributes"));
        }
        VRTestEncoder vRTestEncoder = new VRTestEncoder();
        vRTestEncoder.encodeCommand("CREATE");
        vRTestEncoder.encodeString(string);
        vRTestEncoder.encodeAttributes(vRTestAttributeList);
        String string2 = this.sendCommand(vRTestEncoder.getEncoding());
        VRTestDecoder vRTestDecoder = new VRTestDecoder(string2);
        String string3 = vRTestDecoder.getReturnType();
        if (string3 == "ERROR") {
            vRTestDecoder.getString();
            throw new VRTestException(vRTestDecoder.getString());
        }
        if (string3 == "HANDLE") {
            long l = vRTestDecoder.getHandle();
            if (VRTestHandle.IsInvalid(l)) {
                throw new VRTestException(Errors.BadHandle(l));
            }
            return l;
        }
        throw new VRTestException(Errors.UnsupportedReturnType(string3));
    }

    public void deleteByHandle(long l) throws VRTestException, IOException {
        if (VRTestHandle.IsInvalid(l)) {
            throw new VRTestException(Errors.BadHandle(l));
        }
        VRTestEncoder vRTestEncoder = new VRTestEncoder();
        vRTestEncoder.encodeCommand("DELETE");
        vRTestEncoder.encodeHandle(l);
        String string = this.sendCommand(vRTestEncoder.getEncoding());
        VRTestDecoder vRTestDecoder = new VRTestDecoder(string);
        String string2 = vRTestDecoder.getReturnType();
        if (string2 == "ERROR") {
            vRTestDecoder.getString();
            throw new VRTestException(vRTestDecoder.getString());
        }
        if (string2 != "ACK") {
            throw new VRTestException(Errors.UnsupportedReturnType(string2));
        }
    }

    public void modifyByHandle(long l, VRTestAttributeList vRTestAttributeList) throws VRTestException, IOException {
        if (VRTestHandle.IsInvalid(l)) {
            throw new VRTestException(Errors.BadHandle(l));
        }
        if (vRTestAttributeList == null) {
            throw new IllegalArgumentException(Errors.NullParam("attributes"));
        }
        VRTestEncoder vRTestEncoder = new VRTestEncoder();
        vRTestEncoder.encodeCommand("MODIFY");
        vRTestEncoder.encodeHandle(l);
        vRTestEncoder.encodeAttributes(vRTestAttributeList);
        String string = this.sendCommand(vRTestEncoder.getEncoding());
        VRTestDecoder vRTestDecoder = new VRTestDecoder(string);
        String string2 = vRTestDecoder.getReturnType();
        if (string2 == "ERROR") {
            vRTestDecoder.getString();
            throw new VRTestException(vRTestDecoder.getString());
        }
        if (string2 == "HANDLE") {
            long l2 = vRTestDecoder.getHandle();
            if (l != l2) {
                throw new VRTestException("Handle mismatch.");
            }
            return;
        }
        throw new VRTestException(Errors.UnsupportedReturnType(string2));
    }

    public int getClientID() throws VRTestException, IOException {
        VRTestEncoder vRTestEncoder = new VRTestEncoder();
        vRTestEncoder.encodeCommand("GETCLIENTID");
        String string = this.sendCommand(vRTestEncoder.getEncoding());
        VRTestDecoder vRTestDecoder = new VRTestDecoder(string);
        String string2 = vRTestDecoder.getReturnType();
        if (string2 == "ERROR") {
            vRTestDecoder.getString();
            throw new VRTestException(vRTestDecoder.getString());
        }
        if (string2 == "CLIENTID") {
            return vRTestDecoder.getID();
        }
        throw new VRTestException(Errors.UnsupportedReturnType(string2));
    }

    public VRTestEvent waitForEvent() throws VRTestException, IOException {
        VRTestDecoder vRTestDecoder = new VRTestDecoder(this.events.read());
        VRTestEventType vRTestEventType = vRTestDecoder.getEventType();
        long l = vRTestDecoder.getHandle();
        String string = vRTestDecoder.getString();
        VRTestAttributeList vRTestAttributeList = vRTestDecoder.getAttributes();
        int n = vRTestDecoder.getID();
        return new VRTestEvent(vRTestEventType, l, string, vRTestAttributeList, n);
    }

    public VRTestAttributeList getAttributesByHandle(long l) throws VRTestException, IOException {
        if (VRTestHandle.IsInvalid(l)) {
            throw new VRTestException(Errors.BadHandle(l));
        }
        VRTestEncoder vRTestEncoder = new VRTestEncoder();
        vRTestEncoder.encodeCommand("GETATTRIBUTES");
        vRTestEncoder.encodeHandle(l);
        vRTestEncoder.encodeAttributes(null);
        String string = this.sendCommand(vRTestEncoder.getEncoding());
        VRTestDecoder vRTestDecoder = new VRTestDecoder(string);
        String string2 = vRTestDecoder.getReturnType();
        if (string2 == "ERROR") {
            return VRTestAttributeList.EMPTY;
        }
        if (string2 == "ATTRIBUTES") {
            if (l != vRTestDecoder.getHandle()) {
                throw new VRTestException("Handle mismatch.");
            }
            vRTestDecoder.getString();
            return vRTestDecoder.getAttributes();
        }
        throw new VRTestException(Errors.UnsupportedReturnType(string2));
    }

    public VRTestSchema getSchema() throws VRTestException, IOException {
        if (this.schema == null) {
            this.getSchemaFromServer();
        }
        return this.schema;
    }

    private void getSchemaFromServer() throws VRTestException, IOException {
        VRTestEncoder vRTestEncoder = new VRTestEncoder();
        vRTestEncoder.encodeCommand("GETSCHEMA");
        String string = this.sendCommand(vRTestEncoder.getEncoding());
        VRTestDecoder vRTestDecoder = new VRTestDecoder(string);
        String string2 = vRTestDecoder.getReturnType();
        if (string2 == "ERROR") {
            vRTestDecoder.getString();
            throw new VRTestException(vRTestDecoder.getString());
        }
        if (string2 != "SCHEMA") {
            throw new VRTestException(Errors.UnsupportedReturnType(string2));
        }
        this.schema = new VRTestSchema(vRTestDecoder.getString());
    }

    public long findFirst(String string, VRTestAttributeList vRTestAttributeList) throws VRTestException, IOException {
        if (string == null) {
            throw new IllegalArgumentException(Errors.NullParam("className"));
        }
        VRTestEncoder vRTestEncoder = new VRTestEncoder();
        vRTestEncoder.encodeCommand("FINDFIRST");
        vRTestEncoder.encodeString(string);
        vRTestEncoder.encodeAttributes(vRTestAttributeList);
        String string2 = this.sendCommand(vRTestEncoder.getEncoding());
        VRTestDecoder vRTestDecoder = new VRTestDecoder(string2);
        String string3 = vRTestDecoder.getReturnType();
        if (string3 == "ERROR") {
            vRTestDecoder.getString();
            throw new VRTestException(vRTestDecoder.getString());
        }
        if (string3 == "HANDLE") {
            return vRTestDecoder.getHandle();
        }
        throw new VRTestException(Errors.UnsupportedReturnType(string3));
    }

    public long findNext() throws VRTestException, IOException {
        VRTestEncoder vRTestEncoder = new VRTestEncoder();
        vRTestEncoder.encodeCommand("FINDNEXT");
        String string = this.sendCommand(vRTestEncoder.getEncoding());
        VRTestDecoder vRTestDecoder = new VRTestDecoder(string);
        String string2 = vRTestDecoder.getReturnType();
        if (string2 == "ERROR") {
            vRTestDecoder.getString();
            throw new VRTestException(vRTestDecoder.getString());
        }
        if (string2 == "HANDLE") {
            return vRTestDecoder.getHandle();
        }
        throw new VRTestException(Errors.UnsupportedReturnType(string2));
    }

    public void startSession(String string, int n) throws VRTestException, IOException {
        if (this.commandResponseChannel == null) {
            Object object = this.commandResponseMutex;
            synchronized (object) {
                this.setHostName(string);
                this.setPorts(n);
                this.commandResponseChannel = new Socket(this.host, this.commandResponsePort);
                this.eventChannel = new Socket(this.host, this.eventPort);
                this.fromServer = new VRTestInputStream(this.commandResponseChannel.getInputStream());
                this.toServer = new VRTestOutputStream(this.commandResponseChannel.getOutputStream());
                this.events = new VRTestInputStream(this.eventChannel.getInputStream());
            }
        }
    }

    public void endSession() {
        if (this.commandResponseChannel != null) {
            try {
                try {
                    Object object = this.commandResponseMutex;
                    synchronized (object) {
                        this.commandResponseChannel.close();
                    }
                    Object var4_5 = null;
                    this.commandResponseChannel = null;
                }
                catch (IOException iOException) {
                    Object var4_6 = null;
                    this.commandResponseChannel = null;
                }
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                this.commandResponseChannel = null;
                throw throwable;
            }
            try {
                try {
                    this.eventChannel.close();
                }
                catch (IOException iOException) {
                    Object var6_10 = null;
                    this.eventChannel = null;
                }
                Object var6_9 = null;
                this.eventChannel = null;
            }
            catch (Throwable throwable) {
                Object var6_11 = null;
                this.eventChannel = null;
                throw throwable;
            }
        }
    }
}

