/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.vrtest;

import com.novell.nds.dirxml.vrtest.Constants;
import com.novell.nds.dirxml.vrtest.Errors;
import com.novell.nds.dirxml.vrtest.VRTestAction;
import com.novell.nds.dirxml.vrtest.VRTestAttribute;
import com.novell.nds.dirxml.vrtest.VRTestAttributeSchema;
import com.novell.nds.dirxml.vrtest.VRTestConstants;
import com.novell.nds.dirxml.vrtest.VRTestException;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

public class VRTestAttributeList
implements Constants,
VRTestConstants {
    public static final VRTestAttributeList EMPTY = new VRTestAttributeList();
    private LinkedList removeAttrs = null;
    private List attributes = new Vector();

    public boolean isEmpty() {
        return this.attributes.size() == 0;
    }

    public void removeCurrent() {
        ListIterator listIterator = this.removeAttrs.listIterator();
        while (listIterator.hasNext()) {
            VRTestAttribute vRTestAttribute = (VRTestAttribute)listIterator.next();
            this.attributes.remove(vRTestAttribute);
        }
        this.removeAttrs = null;
    }

    public VRTestAttribute getPath() {
        return this.getAttributeByName("Object Path");
    }

    public VRTestAttribute getID() {
        return this.getAttributeByName("Unique Id");
    }

    public VRTestAttribute getAttributeByName(String string) {
        int n = this.attributes.size();
        int n2 = 0;
        while (n2 < n) {
            VRTestAttribute vRTestAttribute = (VRTestAttribute)this.attributes.get(n2);
            if (string.compareTo(vRTestAttribute.getName()) == 0) {
                this.removeAttrs = new LinkedList();
                this.removeAttrs.add(vRTestAttribute);
                return vRTestAttribute;
            }
            ++n2;
        }
        return null;
    }

    public LinkedList getAttribute(VRTestAttributeSchema vRTestAttributeSchema) throws VRTestException {
        if (vRTestAttributeSchema == null) {
            throw new IllegalArgumentException(Errors.NullParam("attributeSchema"));
        }
        LinkedList<VRTestAttribute> linkedList = null;
        int n = this.attributes.size();
        int n2 = 0;
        while (n2 < n) {
            VRTestAttribute vRTestAttribute = (VRTestAttribute)this.attributes.get(n2);
            if (vRTestAttributeSchema.hasName(vRTestAttribute.getName())) {
                if (linkedList == null) {
                    linkedList = new LinkedList<VRTestAttribute>();
                }
                linkedList.add(vRTestAttribute);
            }
            ++n2;
        }
        this.removeAttrs = linkedList;
        return linkedList;
    }

    public List attributes() {
        return this.attributes;
    }

    public void addAttribute(String string, String string2, VRTestAction vRTestAction) throws VRTestException {
        this.attributes.add(new VRTestAttribute(string, string2, vRTestAction));
    }

    public void addAttribute(VRTestAttribute vRTestAttribute) throws VRTestException {
        if (vRTestAttribute == null) {
            throw new IllegalArgumentException(Errors.NullParam("attribute"));
        }
        this.attributes.add(vRTestAttribute);
    }

    public void clear() {
        this.attributes = new Vector();
    }
}

