/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.vrtest;

import com.novell.nds.dirxml.vrtest.Constants;
import com.novell.nds.dirxml.vrtest.VRTestAttributeKeyword;
import com.novell.nds.dirxml.vrtest.VRTestAttributeSchema;
import com.novell.nds.dirxml.vrtest.VRTestException;
import com.novell.nds.dirxml.vrtest.VRTestIntegerToken;
import com.novell.nds.dirxml.vrtest.VRTestKeyword;
import com.novell.nds.dirxml.vrtest.VRTestKeywordToken;
import com.novell.nds.dirxml.vrtest.VRTestStringToken;
import com.novell.nds.dirxml.vrtest.VRTestToken;
import com.novell.nds.dirxml.vrtest.VRTestTokenizer;

class VRTestAttributeSchemaParser
implements Constants {
    private boolean gotName;
    private VRTestTokenizer tokenizer;
    private VRTestAttributeSchema attributeSchema;

    VRTestAttributeSchemaParser(VRTestAttributeSchema vRTestAttributeSchema, VRTestTokenizer vRTestTokenizer) {
        this.attributeSchema = vRTestAttributeSchema;
        this.tokenizer = vRTestTokenizer;
        this.gotName = false;
    }

    void parse() throws VRTestException {
        boolean bl = false;
        do {
            VRTestToken vRTestToken;
            if ((vRTestToken = this.tokenizer.peekNextToken()) instanceof VRTestKeywordToken) {
                VRTestKeyword vRTestKeyword = ((VRTestKeywordToken)vRTestToken).getKeyword();
                if (vRTestKeyword instanceof VRTestAttributeKeyword) {
                    this.tokenizer.consumeToken();
                    this.handleKeyword(vRTestKeyword);
                    continue;
                }
                bl = true;
                continue;
            }
            if (vRTestToken == null) {
                bl = true;
                continue;
            }
            throw new VRTestException("Parse Error!  Expecting keyword.");
        } while (!bl);
        if (!this.gotName) {
            throw new VRTestException("Parse Error!  No attribute schema name.");
        }
    }

    private void handleKeyword(VRTestKeyword vRTestKeyword) throws VRTestException {
        if (vRTestKeyword == VRTestKeyword.NAME) {
            this.gotName = true;
            this.handleName();
        } else if (vRTestKeyword == VRTestKeyword.MAXLENGTH) {
            this.handleMaxLength();
        } else {
            this.handleBoolean(vRTestKeyword);
        }
    }

    private void handleName() throws VRTestException {
        VRTestToken vRTestToken = this.tokenizer.getNextToken();
        if (!(vRTestToken instanceof VRTestStringToken)) {
            throw new VRTestException("Parse Error!  Expecting string.");
        }
        this.attributeSchema.setName(((VRTestStringToken)vRTestToken).getString());
    }

    private void handleMaxLength() throws VRTestException {
        VRTestToken vRTestToken = this.tokenizer.getNextToken();
        if (!(vRTestToken instanceof VRTestIntegerToken)) {
            throw new VRTestException("Parse Error!  Expecting integer.");
        }
        this.attributeSchema.setMaxLength(((VRTestIntegerToken)vRTestToken).getInt());
    }

    private void handleBoolean(VRTestKeyword vRTestKeyword) throws VRTestException {
        boolean bl = this.tokenizer.getBooleanValue();
        if (vRTestKeyword == VRTestKeyword.REQUIRED) {
            this.attributeSchema.setRequired(bl);
        } else if (vRTestKeyword == VRTestKeyword.MULTIVALUED) {
            this.attributeSchema.setMultiValued(bl);
        } else if (vRTestKeyword == VRTestKeyword.INDEXED) {
            this.attributeSchema.setIndexed(bl);
        } else if (vRTestKeyword == VRTestKeyword.CASESENSITIVE) {
            this.attributeSchema.setCaseSensitive(bl);
        } else if (vRTestKeyword == VRTestKeyword.UNIQUE) {
            this.attributeSchema.setUnique(bl);
        } else if (vRTestKeyword == VRTestKeyword.READONLY) {
            this.attributeSchema.setReadOnly(bl);
        }
    }
}

