/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.vrtest;

import com.novell.nds.dirxml.vrtest.Constants;
import com.novell.nds.dirxml.vrtest.Errors;
import com.novell.nds.dirxml.vrtest.VRTestAttributeSchema;
import com.novell.nds.dirxml.vrtest.VRTestAttributeSchemaParser;
import com.novell.nds.dirxml.vrtest.VRTestClassKeyword;
import com.novell.nds.dirxml.vrtest.VRTestClassSchema;
import com.novell.nds.dirxml.vrtest.VRTestException;
import com.novell.nds.dirxml.vrtest.VRTestKeyword;
import com.novell.nds.dirxml.vrtest.VRTestKeywordToken;
import com.novell.nds.dirxml.vrtest.VRTestStringToken;
import com.novell.nds.dirxml.vrtest.VRTestToken;
import com.novell.nds.dirxml.vrtest.VRTestTokenizer;

class VRTestClassSchemaParser
implements Constants {
    private boolean gotName;
    private VRTestTokenizer tokenizer;
    private VRTestClassSchema classSchema;

    VRTestClassSchemaParser(VRTestClassSchema vRTestClassSchema, VRTestTokenizer vRTestTokenizer) throws VRTestException {
        this.classSchema = vRTestClassSchema;
        this.tokenizer = vRTestTokenizer;
        this.gotName = false;
    }

    void parse() throws VRTestException {
        boolean bl = false;
        do {
            VRTestToken vRTestToken;
            if ((vRTestToken = this.tokenizer.peekNextToken()) instanceof VRTestKeywordToken) {
                VRTestKeyword vRTestKeyword = ((VRTestKeywordToken)vRTestToken).getKeyword();
                if (vRTestKeyword instanceof VRTestClassKeyword) {
                    this.tokenizer.consumeToken();
                    this.handleKeyword(vRTestKeyword);
                    continue;
                }
                bl = true;
                continue;
            }
            if (vRTestToken == null) {
                bl = true;
                continue;
            }
            throw new VRTestException("Parse Error!  Expecting keyword.");
        } while (!bl);
        if (!this.gotName) {
            throw new VRTestException("Parse Error!  No class schema name.");
        }
        if (this.classSchema.getNamingAttributeSchema() == null) {
            throw new VRTestException(Errors.NoNamingAttributeSchema(this.classSchema.toString()));
        }
    }

    private void handleKeyword(VRTestKeyword vRTestKeyword) throws VRTestException {
        if (vRTestKeyword == VRTestKeyword.NAME) {
            this.gotName = true;
            this.handleName();
        } else if (vRTestKeyword == VRTestKeyword.ATTRIBUTE) {
            this.handleAttribute();
        } else {
            this.handleBoolean(vRTestKeyword);
        }
    }

    private void handleName() throws VRTestException {
        VRTestToken vRTestToken = this.tokenizer.getNextToken();
        if (!(vRTestToken instanceof VRTestStringToken)) {
            throw new VRTestException("Parse Error!  Expecting string.");
        }
        this.classSchema.setName(((VRTestStringToken)vRTestToken).getString());
    }

    private void handleAttribute() throws VRTestException {
        VRTestAttributeSchema vRTestAttributeSchema = new VRTestAttributeSchema();
        vRTestAttributeSchema.setCaseSensitive(this.classSchema.isCaseSensitive());
        VRTestAttributeSchemaParser vRTestAttributeSchemaParser = new VRTestAttributeSchemaParser(vRTestAttributeSchema, this.tokenizer);
        vRTestAttributeSchemaParser.parse();
        this.classSchema.addAttributeSchema(vRTestAttributeSchema);
    }

    private void handleBoolean(VRTestKeyword vRTestKeyword) throws VRTestException {
        boolean bl = this.tokenizer.getBooleanValue();
        if (vRTestKeyword == VRTestKeyword.CONTAINER) {
            this.classSchema.setContainer(bl);
        } else if (vRTestKeyword == VRTestKeyword.CASESENSITIVE) {
            this.classSchema.setCaseSensitive(bl);
        }
    }
}

